/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.IValueObject;
import com.iizix.value.ImmutableXMLGregorianCalendar;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Element;

public class XMLGregorianCalendarValue
implements IValueObject<ImmutableXMLGregorianCalendar> {
    private static final ImmutableXMLGregorianCalendar a = new ImmutableXMLGregorianCalendar(Value.getXMLDataFactory().newXMLGregorianCalendar());

    @Override
    public final Value.Type getValueType() {
        return Value.Type.XMLGregorianCalendar;
    }

    @Override
    public Class<ImmutableXMLGregorianCalendar> getValueClass() {
        return ImmutableXMLGregorianCalendar.class;
    }

    @Override
    public String getDescription() {
        return "Representation for W3C XML Schema 1.0 date/time datatypes. Specifically,\nthese date/time datatypes are dateTime, time, date, gYear, gYearMonth,\ngMonth, gMonthDay and gDay defined in the XML Namespace";
    }

    @Override
    public ImmutableXMLGregorianCalendar createDefault() {
        return a;
    }

    @Override
    public ImmutableXMLGregorianCalendar parse(String string) throws ParseException {
        try {
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(string.trim());
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        catch (Exception exception) {
            ParseException parseException = new ParseException(exception.getMessage(), 0);
            parseException.initCause(exception);
            throw parseException;
        }
    }

    @Override
    public ImmutableXMLGregorianCalendar parse(String string, String string2, LocaleInfo localeInfo) throws ParseException, IllegalArgumentException, Exception {
        return this.parse(string);
    }

    @Override
    public Format getFormatter(String string, LocaleInfo localeInfo) {
        return null;
    }

    @Override
    public String toString(ImmutableXMLGregorianCalendar immutableXMLGregorianCalendar) {
        return String.valueOf(immutableXMLGregorianCalendar);
    }

    @Override
    public String toString(ImmutableXMLGregorianCalendar immutableXMLGregorianCalendar, String string, LocaleInfo localeInfo) {
        return String.valueOf(immutableXMLGregorianCalendar);
    }

    @Override
    public ImmutableXMLGregorianCalendar load(String string, Element element) throws Exception {
        XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(string);
        return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
    }

    @Override
    public String save(ImmutableXMLGregorianCalendar immutableXMLGregorianCalendar, Element element) throws Exception {
        return immutableXMLGregorianCalendar.toString();
    }

    @Override
    public ImmutableXMLGregorianCalendar convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof ImmutableXMLGregorianCalendar) {
            return (ImmutableXMLGregorianCalendar)object;
        }
        if (object instanceof XMLGregorianCalendar) {
            return new ImmutableXMLGregorianCalendar((XMLGregorianCalendar)object);
        }
        if (object instanceof Number) {
            Instant instant = Instant.ofEpochMilli(((Number)object).longValue());
            localeInfo = LocaleInfo.getNonNull(localeInfo, false);
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, localeInfo.getZoneId());
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() / 1000000, localeInfo.getTimeZone().getRawOffset() / 60000);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof LocalDateTime) {
            localeInfo = LocaleInfo.getNonNull(localeInfo, false);
            LocalDateTime localDateTime = (LocalDateTime)object;
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() / 1000000, localeInfo.getTimeZone().getRawOffset() / 60000);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(offsetDateTime.getYear(), offsetDateTime.getMonthValue(), offsetDateTime.getDayOfMonth(), offsetDateTime.getHour(), offsetDateTime.getMinute(), offsetDateTime.getSecond(), offsetDateTime.getNano() / 1000000, offsetDateTime.getOffset().getTotalSeconds() / 60);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), zonedDateTime.getMinute(), zonedDateTime.getSecond(), zonedDateTime.getNano() / 1000000, zonedDateTime.getOffset().getTotalSeconds() / 60);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof LocalDate) {
            localeInfo = LocaleInfo.getNonNull(localeInfo, false);
            LocalDate localDate = (LocalDate)object;
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendarDate(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), localeInfo.getTimeZone().getRawOffset() / 60000);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof LocalTime) {
            localeInfo = LocaleInfo.getNonNull(localeInfo, false);
            LocalTime localTime = (LocalTime)object;
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendarTime(localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano() / 1000000, localeInfo.getTimeZone().getRawOffset() / 60000);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendarTime(offsetTime.getHour(), offsetTime.getMinute(), offsetTime.getSecond(), offsetTime.getNano() / 1000000, offsetTime.getOffset().getTotalSeconds() / 60);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof Year) {
            Year year = (Year)object;
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendarDate(year.getValue(), 1, 1, 0);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)object;
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendarDate(yearMonth.getYear(), yearMonth.getMonthValue(), 1, 0);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof MonthDay) {
            MonthDay monthDay = (MonthDay)object;
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendarDate(1970, monthDay.getMonthValue(), monthDay.getDayOfMonth(), 0);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof Timestamp) {
            localeInfo = LocaleInfo.getNonNull(localeInfo, false);
            LocalDateTime localDateTime = ((Timestamp)object).toLocalDateTime();
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() / 1000000, localeInfo.getTimeZone().getRawOffset() / 60000);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof Date) {
            localeInfo = LocaleInfo.getNonNull(localeInfo, false);
            Instant instant = Instant.ofEpochMilli(((Date)object).getTime());
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() / 1000000, localeInfo.getTimeZone().getRawOffset() / 60000);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (object instanceof GregorianCalendar) {
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar((GregorianCalendar)object);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            localeInfo = LocaleInfo.getNonNull(localeInfo, false);
            Instant instant = Instant.ofEpochMilli(l2);
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() / 1000000, localeInfo.getTimeZone().getRawOffset() / 60000);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        String string = (type != null ? type.valueObject.toStringForced(object) : String.valueOf(object)).trim();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = Value.getXMLDataFactory().newXMLGregorianCalendar(string);
            return new ImmutableXMLGregorianCalendar(xMLGregorianCalendar);
        }
        catch (Exception exception) {
            ParseException parseException = new ParseException(exception.getMessage(), 0);
            parseException.initCause(exception);
            throw parseException;
        }
    }

    @Override
    public long asLong(ImmutableXMLGregorianCalendar immutableXMLGregorianCalendar, LocaleInfo localeInfo) {
        try {
            return immutableXMLGregorianCalendar.toGregorianCalendar().toInstant().toEpochMilli();
        }
        catch (Exception exception) {
            return Long.MIN_VALUE;
        }
    }
}

