/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import java.text.Format;
import java.text.ParseException;
import org.w3c.dom.Element;

public interface IValueObject<TYPE> {
    public static final String PATTERN_SHORT = "short";
    public static final String PATTERN_MEDIUM = "medium";
    public static final String PATTERN_LONG = "long";
    public static final String PATTERN_FULL = "full";
    public static final String PATTERN_BASIC_ISO_DATE = "BASIC_ISO_DATE";
    public static final String PATTERN_ISO_LOCAL_DATE = "ISO_LOCAL_DATE";
    public static final String PATTERN_ISO_OFFSET_DATE = "ISO_OFFSET_DATE";
    public static final String PATTERN_ISO_DATE = "ISO_DATE";
    public static final String PATTERN_ISO_LOCAL_TIME = "ISO_LOCAL_TIME";
    public static final String PATTERN_ISO_OFFSET_TIME = "ISO_OFFSET_TIME";
    public static final String PATTERN_ISO_TIME = "ISO_TIME";
    public static final String PATTERN_ISO_LOCAL_DATE_TIME = "ISO_LOCAL_DATE_TIME";
    public static final String PATTERN_ISO_OFFSET_DATE_TIME = "ISO_OFFSET_DATE_TIME";
    public static final String PATTERN_ISO_ZONED_DATE_TIME = "ISO_ZONED_DATE_TIME";
    public static final String PATTERN_ISO_DATE_TIME = "ISO_DATE_TIME";
    public static final String PATTERN_ISO_ORDINAL_DATE = "ISO_ORDINAL_DATE";
    public static final String PATTERN_ISO_WEEK_DATE = "ISO_WEEK_DATE";
    public static final String PATTERN_ISO_INSTANT = "ISO_INSTANT";
    public static final String PATTERN_RFC_1123_DATE_TIME = "RFC_1123_DATE_TIME";
    public static final String PATTERN_INTEGER = "integer";
    public static final String PATTERN_PERCENT = "percent";
    public static final String PATTERN_CURRENCY = "currency";
    public static final String RESOLVER_STRICT = "[strict]";
    public static final String RESOLVER_STRICT_NO_BRACKETS = "strict";
    public static final String RESOLVER_SMART = "[smart]";
    public static final String RESOLVER_SMART_NO_BRACKETS = "smart";
    public static final String RESOLVER_LENIENT = "[lenient]";
    public static final String RESOLVER_LENIENT_NO_BRACKETS = "lenient";

    public Value.Type getValueType();

    public Class<TYPE> getValueClass();

    public String getDescription();

    public TYPE createDefault();

    default public boolean isRightAligned() {
        return false;
    }

    public Format getFormatter(String var1, LocaleInfo var2) throws IllegalArgumentException;

    public String toString(TYPE var1);

    default public String toStringForced(Object object) {
        try {
            return this.toString(object != null ? (TYPE)this.getValueClass().cast(object) : null);
        }
        catch (ClassCastException classCastException) {
            return String.valueOf(object);
        }
    }

    public String toString(TYPE var1, String var2, LocaleInfo var3) throws IllegalArgumentException, Exception;

    default public String toStringCast(Object object, String string, LocaleInfo localeInfo) throws IllegalArgumentException, Exception {
        return this.toString(object, string, localeInfo);
    }

    public TYPE parse(String var1) throws ParseException, IllegalArgumentException, Exception;

    public TYPE parse(String var1, String var2, LocaleInfo var3) throws ParseException, IllegalArgumentException, Exception;

    public TYPE load(String var1, Element var2) throws Exception;

    public String save(TYPE var1, Element var2) throws Exception;

    default public String saveCast(Object object, Element element) throws Exception {
        return this.save(object, element);
    }

    public TYPE convert(Object var1, Value.Type var2, LocaleInfo var3) throws Exception;

    public long asLong(TYPE var1, LocaleInfo var2);

    default public long asLongCast(Object object, LocaleInfo localeInfo) {
        try {
            return this.asLong(this.getValueClass().cast(object), localeInfo);
        }
        catch (Exception exception) {
            return Long.MIN_VALUE;
        }
    }
}

