/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.urn.svg;

import com.iizix.Utilities;
import com.iizix.prop.GSize;
import com.iizix.prop.image.SVGInfo;
import com.iizix.urn.URN;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.xml.sax.SAXException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SVG_URN
extends URN
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 947935876538661770L;
    private final SVGInfo a;
    private final GSize a;

    public static SVG_URN fromURL(String string, int n2, int n3) throws IOException, SAXException {
        SVGInfo sVGInfo = SVGInfo.fromString(Objects.requireNonNull(string));
        GSize gSize = null;
        if (n2 > 0 && n3 > 0) {
            gSize = new GSize(n2, n3);
            sVGInfo.setScale(n2, n3);
        }
        String string2 = sVGInfo.getSVGForHTML();
        String string3 = "urn:iz-svg" + Utilities.encodeURIComponent(string2);
        if (n2 > 0 && n3 > 0) {
            string3 = string3 + "?=size:" + n2 + "x" + n3;
        }
        return new SVG_URN(string3, sVGInfo, gSize);
    }

    SVG_URN(String string, SVGInfo sVGInfo, GSize gSize) {
        super(string);
        this.a = sVGInfo;
        this.a = gSize;
    }

    @Override
    public String getURL() {
        return "data:image/svg+xml;base64," + Utilities.encodeBase64(this.a.getSVGForHTML().getBytes(StandardCharsets.UTF_8));
    }

    public GSize getScaledSize() {
        return this.a;
    }

    public String getSVGForHTML() {
        return this.a.getSVGForHTML();
    }

    @Override
    public String getParamString() {
        String string = "svg=" + this.a.getSVGForHTML();
        if (this.a != null) {
            string = string + ",size[width=" + this.a.getCX() + ",height=" + this.a.getCY() + "]";
        }
        return string;
    }

    @Override
    public int hashCode() {
        int n2 = (31 + this.a.getSVGForHTML().hashCode()) * 31;
        if (this.a != null) {
            n2 += this.a.hashCode();
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SVG_URN sVG_URN = (SVG_URN)object;
        return Objects.equals(this.a, sVG_URN.a) && this.a.getSVGForHTML().equals(sVG_URN.a.getSVGForHTML());
    }
}

