/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.urn;

import com.iizix.prop.image.IImageTarget;
import com.iizix.urn.URNException;
import com.iizix.urn.URNFactory;
import com.iizix.urn.URNResource;
import java.io.IOException;
import java.util.Objects;

public abstract class URN {
    protected final String urnString;

    public static URN from(String string) throws URNException {
        return URNFactory.getInstance().from(string);
    }

    protected URN(String string) {
        this.urnString = Objects.requireNonNull(string);
    }

    public abstract String getURL() throws IOException;

    public boolean isURNResource() {
        return false;
    }

    public URNResource asURNResource() {
        return null;
    }

    public boolean isImageTargetSupported() {
        return false;
    }

    public IImageTarget getImageTarget() {
        return null;
    }

    public final String getURNString() {
        return this.urnString;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String getParamString();

    public final String toString() {
        return this.getClass().getName() + "[" + this.getParamString() + "," + this.urnString + "]";
    }
}

