/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.run;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.prop.Atom;
import com.iizix.prop.KStringProp;
import com.iizix.prop.PKCS12IdentityProp;
import com.iizix.prop.PasswordProp;
import com.iizix.prop.PropException;
import com.iizix.prop.RuntimeBuilderProps;
import com.iizix.prop.TextTable;
import com.iizix.run.BuilderError;
import com.iizix.security.CertificateHelper;
import com.iizix.security.GenerateKeystore;
import com.iizix.selector.LanguageMatch;
import com.iizix.text.KString;
import com.iizix.text.KStringPLAINTextTableTag;
import com.iizix.text.KStringTag;
import com.iizix.text.PlainKString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RuntimeBuilderSettings {
    public static final String[] ICONS_COMMON = new String[]{"16.png", "24.png", "32.png", "48.png", "64.png", "72.png", "96.png", "128.png", "144.png", "192.png", "128.png", "128.png", "256.png", "384.png", "512.png", "1024.png"};
    public static final String[] ICONS_ANDROID_STANDARD = new String[]{"36.png", "48.png", "72.png", "96.png", "144.png", "192.png"};
    public static final int[] ICONS_ANDROID_ADAPTIVE_SIZE = new int[]{48, 64, 96, 128, 192, 256};
    public static final String[] ICONS_ANDROID_ADAPTIVE_DENSITY = new String[]{"ldpi", "mdpi", "hdpi", "xhdpi", "xxhdpi", "xxxhdpi"};
    public static final String[] ICONS_IOS = new String[]{"60.png", "120.png", "180.png", "152.png", "40.png", "80.png", "167.png", "29.png", "58.png", "87.png", "20.png", "48.png", "55.png", "88.png", "100.png", "172.png", "176.png", "196.png", "1024.png", "50.png", "57.png", "66.png", "72.png", "92.png", "102.png", "114.png", "144.png", "216.png", "234.png"};
    public static final int TOTAL_ICONS_COUNT = ICONS_COMMON.length + ICONS_ANDROID_STANDARD.length + ICONS_IOS.length;
    public final RuntimeBuilderProps props;
    private File a;
    public final String build_version;
    public final boolean build_android;
    public final int build_android_release;
    public final boolean build_ios;
    public final int build_target_types;
    public final String build_remote;
    public final boolean build_remote_tls;
    public final boolean build_remote_all;
    public final String app_id;
    public final String app_name;
    public final String default_locale;
    public final String app_textTable;
    protected TextTable textTable;
    private TextTable[] a;
    public final String assets_folder;
    public final PlainKString app_locName;
    public final PlainKString app_descr;
    public final PlainKString author_name;
    public final String author_email;
    public final String author_href;
    public final String cert_CN;
    public final String cert_O;
    public final String cert_OU;
    public final String cert_L;
    public final String cert_ST;
    public final String cert_C;
    public final String server_addr;
    public final int server_port;
    public final boolean server_secure;
    public final boolean server_validate;
    public final String srv_app_id;
    public final String srv_app_descr;
    public final String login_user;
    public final String login_password;
    public final String deepLink_urlscheme;
    public final int deepLink_op;
    public final String output_path;
    private File b;
    public final String jdk_path;
    public final boolean plugin_camera;
    public final boolean plugin_firebase;
    public final boolean plugin_geolocation;
    public final boolean plugin_media;
    public final boolean plugin_media_capture;
    public final boolean plugin_native_settings;
    public final boolean plugin_fingerprint;
    public final boolean plugin_vibration;
    public final boolean plugin_barcode_scanner;
    public final boolean plugin_wifi;
    public final boolean plugin_flashlight;
    public final String app_id_android;
    private boolean a;
    public boolean useAdaptiveBGColor;
    public final String app_id_ios;
    public final boolean iOS_criticalAlerts;
    public final String iOS_debug_developmentTeam;
    public final String iOS_release_developmentTeam;
    public final boolean fb_analyticsCollection;
    public final boolean fb_performanceCollection;
    public final boolean fb_crashlyticsCollection;

    public RuntimeBuilderSettings(RuntimeBuilderProps runtimeBuilderProps) {
        this.props = runtimeBuilderProps;
        this.build_version = runtimeBuilderProps.getString("build_version");
        this.build_android = runtimeBuilderProps.getBool("build_android", true);
        this.build_ios = runtimeBuilderProps.getBool("build_ios", true);
        this.build_target_types = runtimeBuilderProps.getInt("build_target_types", 1);
        this.build_android_release = runtimeBuilderProps.getInt("build_android_release", 1);
        this.build_remote = runtimeBuilderProps.getString("build_remote");
        this.build_remote_tls = runtimeBuilderProps.getBool("build_remote_tls");
        this.build_remote_all = runtimeBuilderProps.getBool("build_remote_all");
        this.app_id = runtimeBuilderProps.getString("app_id");
        this.app_name = runtimeBuilderProps.getString("app_name");
        this.app_locName = runtimeBuilderProps.getPropValue("app_locName", PlainKString.class);
        this.app_descr = runtimeBuilderProps.getPropValue("app_descr", PlainKString.class);
        this.assets_folder = runtimeBuilderProps.getString("assets_folder");
        this.author_name = runtimeBuilderProps.getPropValue("author_name", PlainKString.class);
        this.author_email = runtimeBuilderProps.getString("author_email");
        this.author_href = runtimeBuilderProps.getString("author_href");
        this.cert_CN = runtimeBuilderProps.getString("cert_CN");
        this.cert_O = runtimeBuilderProps.getString("cert_O");
        this.cert_OU = runtimeBuilderProps.getString("cert_OU");
        this.cert_L = runtimeBuilderProps.getString("cert_L");
        this.cert_ST = runtimeBuilderProps.getString("cert_ST");
        this.cert_C = runtimeBuilderProps.getString("cert_C");
        this.server_addr = runtimeBuilderProps.getString("server_addr");
        this.server_port = runtimeBuilderProps.getInt("server_port", 443);
        this.server_secure = runtimeBuilderProps.getBool("server_secure", true);
        this.server_validate = runtimeBuilderProps.getBool("server_validate", true);
        this.srv_app_id = runtimeBuilderProps.getString("srv_app_id");
        this.srv_app_descr = runtimeBuilderProps.getString("srv_app_descr");
        String string = runtimeBuilderProps.getString("login_user");
        String string2 = runtimeBuilderProps.getString("login_password");
        this.login_user = string != null && !string.isEmpty() ? string : "iiziRun Developer";
        this.login_password = string2 != null && !string2.isEmpty() ? string2 : "secret";
        this.deepLink_urlscheme = runtimeBuilderProps.getString("deepLink_urlscheme");
        this.deepLink_op = runtimeBuilderProps.getInt("deepLink_op", 0);
        this.output_path = runtimeBuilderProps.getString("output_path", "iiziRun");
        this.jdk_path = runtimeBuilderProps.getString("jdk_path");
        this.plugin_camera = runtimeBuilderProps.getBool("plugin_camera");
        this.plugin_firebase = runtimeBuilderProps.getBool("plugin_firebase");
        this.plugin_geolocation = runtimeBuilderProps.getBool("plugin_geolocation", true);
        this.plugin_media = runtimeBuilderProps.getBool("plugin_media");
        this.plugin_media_capture = runtimeBuilderProps.getBool("plugin_media_capture");
        this.plugin_native_settings = runtimeBuilderProps.getBool("plugin_native_settings", true);
        this.plugin_fingerprint = runtimeBuilderProps.getBool("plugin_fingerprint");
        this.plugin_vibration = runtimeBuilderProps.getBool("plugin_vibration");
        this.plugin_barcode_scanner = runtimeBuilderProps.getBool("plugin_barcode_scanner");
        this.plugin_flashlight = runtimeBuilderProps.getBool("plugin_flashlight");
        this.plugin_wifi = runtimeBuilderProps.getBool("plugin_wifi");
        String string3 = runtimeBuilderProps.getString("locale");
        if (string3 == null || string3.isEmpty()) {
            string3 = "en-US";
        }
        this.default_locale = string3;
        this.app_textTable = runtimeBuilderProps.getTextTableReference();
        this.textTable = runtimeBuilderProps.getTextTable();
        this.app_id_android = runtimeBuilderProps.getString("app_id_android");
        this.app_id_ios = runtimeBuilderProps.getString("app_id_ios");
        this.iOS_criticalAlerts = runtimeBuilderProps.getBool("iOS_criticalAlerts");
        this.iOS_debug_developmentTeam = runtimeBuilderProps.getString("iOS_debug_developmentTeam");
        this.iOS_release_developmentTeam = runtimeBuilderProps.getString("iOS_release_developmentTeam");
        this.fb_analyticsCollection = runtimeBuilderProps.getBool("fb_analyticsCollection", true);
        this.fb_performanceCollection = runtimeBuilderProps.getBool("fb_performanceCollection", true);
        this.fb_crashlyticsCollection = runtimeBuilderProps.getBool("fb_crashlyticsCollection", true);
    }

    private String a(String string) {
        char c2;
        char[] cArray;
        if (string == null || string.isEmpty()) {
            return "cannot be empty";
        }
        char[] cArray2 = cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            c2 = cArray2[n3];
            if (!(c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '_' || c2 == ' ' || c2 >= '0' && c2 <= '9')) {
                return "contains illegal characters, must be a-z, A-Z, 0-9, space or underscore";
            }
            ++n3;
        }
        c2 = cArray[0];
        if (!(c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
            return "must start with a-z or A-Z";
        }
        return null;
    }

    private String b(String string) {
        char c2;
        char[] cArray;
        if (string == null || string.isEmpty()) {
            return "cannot be empty";
        }
        char[] cArray2 = cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            c2 = cArray2[n3];
            if (!(c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '_' || c2 >= '0' && c2 <= '9')) {
                return "contains illegal characters, must be a-z, A-Z, 0-9 or underscore";
            }
            ++n3;
        }
        c2 = cArray[0];
        if (!(c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
            return "must start with a-z or A-Z";
        }
        return null;
    }

    private String c(String string) {
        char c2;
        char[] cArray;
        if (string == null || string.isEmpty()) {
            return "cannot be empty";
        }
        char[] cArray2 = cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            c2 = cArray2[n3];
            if (!(c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '_' || c2 == '.' || c2 >= '0' && c2 <= '9')) {
                return "contains illegal characters, must be a-z, A-Z, 0-9, underscore or '.' (dot)";
            }
            ++n3;
        }
        c2 = cArray[0];
        if (!(c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
            return "must start with a-z or A-Z";
        }
        return null;
    }

    private String a(PlainKString plainKString) {
        if (plainKString != null) {
            KStringTag<?>[] kStringTagArray = plainKString.getTags();
            int n2 = kStringTagArray.length;
            int n3 = 0;
            while (n3 < n2) {
                KStringTag<?> kStringTag = kStringTagArray[n3];
                if (kStringTag instanceof KStringPLAINTextTableTag) {
                    KString kString;
                    KStringPLAINTextTableTag kStringPLAINTextTableTag = (KStringPLAINTextTableTag)kStringTag;
                    String string = kStringPLAINTextTableTag.getReference();
                    if (string == null || string.isEmpty()) {
                        return "text table tag reference must be specified";
                    }
                    String string2 = this.app_textTable + "/";
                    if (!string.startsWith(string2)) {
                        return "text table tag reference must start with \"" + string2 + "\"";
                    }
                    KStringProp kStringProp = this.textTable.getProp(string.substring(string2.length()), KStringProp.class);
                    if (kStringProp == null || (kString = kStringProp.getKString()) == null) {
                        return "text table tag reference \"" + string + "\" is not found";
                    }
                    if (kString.isHTML()) {
                        return "text table tag reference \"" + string + "\" refers to HTML string that is not allowed, only plain strings";
                    }
                    if (kString.hasReferenceTags()) {
                        return "text table tag reference \"" + string + "\" has itself illegal tag references: it must be a plain string";
                    }
                } else {
                    return "can only contain text table tags {tt=\"ref\"}";
                }
                ++n3;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String d(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        try {
            String string2;
            int n2 = 0;
            do {
                String string3;
                if ((string3 = stringTokenizer.nextToken()).equals(".")) {
                    return "invalid format: double-dot not allowed";
                }
                ++n2;
                String string4 = this.b(string3);
                if (string4 != null) {
                    return "invalid format: sub-ID " + string4;
                }
                if (stringTokenizer.hasMoreTokens()) continue;
                if (n2 >= 2) return null;
                return "invalid format: must contain at least two sub-ID's (e.g. 'com.app')";
            } while ((string2 = stringTokenizer.nextToken()).equals("."));
            return "invalid format: expected '.'";
        }
        catch (Exception exception) {
            return "invalid format (must be e.g. 'com.your.name')";
        }
    }

    /*
     * Unable to fully structure code
     */
    public void verify(boolean var1_1, boolean var2_2, File var3_3, Set<String> var4_4, ArrayList<BuilderError> var5_5) {
        block128: {
            block127: {
                block126: {
                    var6_6 = this.build_target_types == 0 || this.build_target_types == 2;
                    v0 = var7_7 = this.build_target_types == 1 || this.build_target_types == 2;
                    if (this.build_version == null || this.build_version.isEmpty()) {
                        var5_5.add(new BuilderError("build_version", "Version", "Version must be specified as 'major.minor.patch'"));
                    } else {
                        block125: {
                            var9_8 = new StringTokenizer(this.build_version, ".", true);
                            var8_16 = "invalid format";
                            try {
                                var10_17 = var9_8.nextToken();
                                var11_20 = var9_8.nextToken();
                                var12_27 = var9_8.nextToken();
                                var13_30 = var9_8.nextToken();
                                var14_32 = var9_8.nextToken();
                                if (var9_8.hasMoreTokens() || !var11_20.equals(".") || !var13_30.equals(".")) break block125;
                                var8_16 = "major range 0 to 99";
                                var15_35 = Integer.parseInt((String)var10_17);
                                if (var15_35 < 0 || var15_35 > 99) break block125;
                                var8_16 = "minor range 0 to 99";
                                var16_37 = Integer.parseInt((String)var12_27);
                                if (var16_37 < 0 || var16_37 > 99) break block125;
                                var8_16 = "patch range 0 to 99";
                                var17_41 = Integer.parseInt((String)var14_32);
                                if (var17_41 < 0 || var17_41 > 99) break block125;
                                if (var15_35 + var16_37 + var17_41 != 0) break block126;
                                var8_16 = "all number cannot be zero";
                            }
                            catch (Exception var10_18) {
                                // empty catch block
                            }
                        }
                        var5_5.add(new BuilderError("build_version", "Version", "Version 'major.minor.patch', " + (String)var8_16));
                    }
                }
                if (this.build_remote != null) {
                    var8_16 = null;
                    var9_9 = this.build_remote.indexOf(58);
                    if (var9_9 < 0) {
                        var8_16 = "Missing port";
                    } else if (var9_9 < 2) {
                        var8_16 = "Invalid remote address";
                    } else {
                        var10_17 = this.build_remote.substring(var9_9 + 1);
                        try {
                            var11_21 = Integer.parseInt((String)var10_17);
                            if (var11_21 < 1 || var11_21 > 65534) {
                                var8_16 = "Invalid port number, range is 1 to 65534";
                            }
                        }
                        catch (NumberFormatException var11_22) {
                            var8_16 = "Invalid port number: " + (String)var10_17;
                        }
                        if (var2_2 && var8_16 == null) {
                            try {
                                new URI((this.build_remote_tls != false ? "https://" : "http://") + this.build_remote + "/apps").toURL().openStream().close();
                            }
                            catch (Exception var11_23) {
                                var8_16 = "Connection failed: " + var11_23.getMessage();
                            }
                        }
                    }
                    if (var8_16 != null) {
                        var5_5.add(new BuilderError("build_remote", "Remote builder", (String)var8_16));
                    }
                } else if ((this.build_remote_all || SystemConfig.isWindows && this.build_ios || SystemConfig.isLinux && this.build_ios) && (this.build_remote == null || this.build_remote.isEmpty())) {
                    var5_5.add(new BuilderError("build_remote", "Remote builder", "Remote builder must be specified due to your seletion"));
                }
                if (this.app_id == null || this.app_id.isEmpty()) {
                    var5_5.add(new BuilderError("app_id", "ID", false, "ID must be specified (e.g. 'com.your.name')"));
                } else {
                    var8_16 = this.d(this.app_id);
                    if (var8_16 != null) {
                        var5_5.add(new BuilderError("app_id", "ID", "App ID " + (String)var8_16));
                    }
                }
                var8_16 = this.a(this.app_name);
                if (var8_16 != null) {
                    var5_5.add(new BuilderError("app_name", "Name", "App name " + (String)var8_16));
                }
                if (this.textTable == null && (this.app_textTable == null || this.app_textTable.isEmpty())) {
                    var5_5.add(new BuilderError("app_textTable", "Text table", false, "Text table must be specified"));
                } else if (this.textTable == null) {
                    var5_5.add(new BuilderError("app_textTable", "Text table", "Text table is not found"));
                } else {
                    if (var4_4 != null) {
                        for (String var9_10 : var4_4) {
                            if (this.textTable.getText(var9_10) != null) continue;
                            var5_5.add(new BuilderError("app_textTable", "Text table", "Text table ID not found: " + var9_10));
                        }
                    }
                    var9_11 = this.getDerivedTextTables();
                    var13_30 = var9_11;
                    var12_28 = var9_11.length;
                    var11_24 = 0;
                    while (var11_24 < var12_28) {
                        var10_17 = var13_30[var11_24];
                        if (var10_17.getLanguageCode() == null) {
                            var5_5.add(new BuilderError("app_textTable", "Text table", "Text table " + var10_17.getReferencePropName() + " does not specify a language code"));
                        }
                        var17_42 = var10_17.getProps(KStringProp.class);
                        var16_37 = var17_42.length;
                        var15_35 = 0;
                        while (var15_35 < var16_37) {
                            var14_32 = var17_42[var15_35];
                            var18_44 = var14_32.getKString();
                            if (var18_44.isHTML()) {
                                var5_5.add(new BuilderError("app_textTable", "Text table", "Text table " + var10_17.getReferencePropName() + " cannot have HTML text entry: ID = " + var14_32.getPropName() + " = " + var18_44.getRawString()));
                            } else if (var18_44.getTags().length > 0) {
                                var5_5.add(new BuilderError("app_textTable", "Text table", "Text table " + var10_17.getReferencePropName() + " cannot have tags in text entry: ID = " + var14_32.getPropName() + " = " + var18_44.getRawString()));
                            }
                            ++var15_35;
                        }
                        ++var11_24;
                    }
                }
                if (this.app_locName == null || this.app_locName.isEmpty()) {
                    var5_5.add(new BuilderError("app_locName", "Localized name", false, "Localized name must be specified"));
                } else {
                    var8_16 = this.a(this.app_locName);
                    if (var8_16 != null) {
                        var5_5.add(new BuilderError("app_locName", "Localized name", "Localized name " + (String)var8_16));
                    }
                }
                if (this.app_descr == null || this.app_descr.isEmpty()) {
                    var5_5.add(new BuilderError("app_descr", "Description", false, "Description must be specified"));
                } else {
                    var8_16 = this.a(this.app_locName);
                    if (var8_16 != null) {
                        var5_5.add(new BuilderError("app_locName", "Description", "Description " + (String)var8_16));
                    }
                }
                if (this.assets_folder != null && !this.assets_folder.isEmpty()) break block127;
                var5_5.add(new BuilderError("assets_folder", "Assets folder", false, "Assets folder name must be specified"));
                break block128;
            }
            var9_12 = this.props.getAssetsDirectory();
            if (var9_12 == null) ** GOTO lbl213
            var10_17 = this.assets_folder.equals(".") != false ? var9_12 : new File(var9_12, this.assets_folder);
            var11_25 = new File((File)var10_17, "icons");
            var8_16 = null;
            if (!var9_12.isDirectory()) {
                var8_16 = "Cannot find the project Assets directory: " + var9_12.getPath();
            } else if (!var10_17.isDirectory()) {
                var8_16 = "Cannot find the project Assets directory for icons and splash screens: " + var10_17.getPath();
            } else {
                this.a = var10_17;
                if (!var11_25.isDirectory()) {
                    var8_16 = "Cannot find the project Assets directory for icons: " + var11_25.getPath();
                } else {
                    var12_27 = new ArrayList<E>();
                    var12_27.addAll(List.of(RuntimeBuilderSettings.ICONS_COMMON));
                    if (this.build_android) {
                        var16_38 = RuntimeBuilderSettings.ICONS_ANDROID_STANDARD;
                        var15_35 = RuntimeBuilderSettings.ICONS_ANDROID_STANDARD.length;
                        var14_33 = 0;
                        while (var14_33 < var15_35) {
                            var13_30 = var16_38[var14_33];
                            var12_27.add("android/" + (String)var13_30);
                            ++var14_33;
                        }
                        var13_30 = new File(var11_25, "android/adaptive");
                        this.a = var13_30.isDirectory();
                        if (this.a) {
                            var17_43 = RuntimeBuilderSettings.ICONS_ANDROID_ADAPTIVE_SIZE;
                            var16_39 = RuntimeBuilderSettings.ICONS_ANDROID_ADAPTIVE_SIZE.length;
                            var15_35 = 0;
                            while (var15_35 < var16_39) {
                                var14_33 = var17_43[var15_35];
                                var12_27.add("android/adaptive/f" + var14_33 + ".png");
                                ++var15_35;
                            }
                            this.useAdaptiveBGColor = new File((File)var13_30, "bgcolor.xml").isFile();
                            if (!this.useAdaptiveBGColor) {
                                var17_43 = RuntimeBuilderSettings.ICONS_ANDROID_ADAPTIVE_SIZE;
                                var16_39 = RuntimeBuilderSettings.ICONS_ANDROID_ADAPTIVE_SIZE.length;
                                var15_35 = 0;
                                while (var15_35 < var16_39) {
                                    var14_33 = var17_43[var15_35];
                                    var12_27.add("android/adaptive/b" + var14_33 + ".png");
                                    ++var15_35;
                                }
                            }
                        }
                    }
                    if (this.build_ios) {
                        var16_40 = RuntimeBuilderSettings.ICONS_IOS;
                        var15_35 = RuntimeBuilderSettings.ICONS_IOS.length;
                        var14_34 = 0;
                        while (var14_34 < var15_35) {
                            var13_30 = var16_40[var14_34];
                            var12_27.add("ios/" + (String)var13_30);
                            ++var14_34;
                        }
                    }
                    var14_32 = var12_27.iterator();
                    while (var14_32.hasNext()) {
                        var13_30 = (String)var14_32.next();
                        var15_36 = new File(var11_25, var13_30.replace('/', File.separatorChar));
                        if (var15_36.isFile()) continue;
                        var5_5.add(new BuilderError("assets_folder", "Assets folder", "Icon file missing: " + var15_36.getPath()));
                    }
                    if (this.plugin_firebase) {
                        if (this.build_android && !(var13_30 = new File((File)var10_17, "google-services.json")).isFile()) {
                            var5_5.add(new BuilderError("assets_folder", "Assets folder", "Missing Firebase file in Assets directory: " + var13_30.getPath()));
                        }
                        if (this.build_ios && !(var13_30 = new File((File)var10_17, "GoogleService-Info.plist")).isFile()) {
                            var5_5.add(new BuilderError("assets_folder", "Assets folder", "Missing Firebase file in Assets directory: " + var13_30.getPath()));
                        }
                    }
lbl213:
                    // 6 sources

                    if (var8_16 != null) {
                        var5_5.add(new BuilderError("assets_folder", "Assets folder", (String)var8_16));
                    }
                }
            }
        }
        if (this.author_name == null || this.author_name.isEmpty()) {
            var5_5.add(new BuilderError("author_name", "Author name", false, "Author name must be specified"));
        } else {
            var8_16 = this.a(this.app_locName);
            if (var8_16 != null) {
                var5_5.add(new BuilderError("author_name", "Author name", "Author name " + (String)var8_16));
            }
        }
        if (this.author_email == null || this.author_email.isEmpty()) {
            var5_5.add(new BuilderError("author_email", "Author email", false, "Author name must be specified"));
        } else if (!Utilities.isValidEmail(this.author_email)) {
            var5_5.add(new BuilderError("author_email", "Author email", "Author email is not valid"));
        }
        if (this.author_href == null || this.author_href.isEmpty()) {
            var5_5.add(new BuilderError("author_href", "Author website", false, "Author website must be specified"));
        } else if (!Utilities.isValidURL(this.author_href, new String[]{"http", "https"})) {
            var5_5.add(new BuilderError("author_href", "Author website", "Author website is not valid"));
        }
        if (!this.isInternalBuild()) {
            if (this.build_android) {
                if (this.cert_OU == null || this.cert_OU.isEmpty()) {
                    var5_5.add(new BuilderError("cert_OU", "Origanizational unit", false, "Origanizational unit must be filled in"));
                }
                if (this.cert_L == null || this.cert_L.isEmpty()) {
                    var5_5.add(new BuilderError("cert_L", "Locality (city)", false, "Locality (city) must be filled in"));
                }
                if (this.cert_ST == null || this.cert_ST.isEmpty()) {
                    var5_5.add(new BuilderError("cert_ST", "State", false, "State must be filled in"));
                }
                if (this.cert_C == null || this.cert_C.length() != 2) {
                    var5_5.add(new BuilderError("cert_C", "Country", false, "Country must be filled in as two letters country code"));
                } else if (!LanguageMatch.countryNames.containsKey(this.cert_C.toUpperCase())) {
                    var5_5.add(new BuilderError("cert_C", "Country", "Country code '" + this.cert_C + "' is not a valid country code"));
                }
            }
            if (this.build_ios) {
                if (var6_6 && (this.iOS_debug_developmentTeam == null || this.iOS_debug_developmentTeam.isEmpty())) {
                    var5_5.add(new BuilderError("iOS_debug_developmentTeam", "Debug development team", "Debug development team must be specified"));
                }
                if (var7_7 && (this.iOS_release_developmentTeam == null || this.iOS_release_developmentTeam.isEmpty())) {
                    var5_5.add(new BuilderError("iOS_release_developmentTeam", "Debug development team", "Debug development team must be specified"));
                }
            }
            var9_13 = var2_2;
            if (this.server_addr == null || this.server_addr.isEmpty()) {
                var5_5.add(new BuilderError("server_addr", "Address", false, "Address must be specified"));
                var9_13 = false;
            }
            if (this.server_port < 1 || this.server_port > 65534) {
                var5_5.add(new BuilderError("server_port", "Port", "Invalid port number, range is 1 to 65534"));
                var9_13 = false;
            }
            if (var9_13) {
                try {
                    if (this.server_validate) {
                        new URI((this.server_secure != false ? "https://" : "http://") + this.server_addr + ":" + this.server_port + "/apps").toURL().openStream().close();
                    }
                }
                catch (Exception var10_19) {
                    var8_16 = "Connection failed: " + var10_19.getMessage();
                    var5_5.add(new BuilderError("server_addr", "Address", (String)var8_16));
                }
            }
            if (this.srv_app_id == null || this.srv_app_id.isEmpty()) {
                var5_5.add(new BuilderError("srv_app_id", "ID", false, "Server App ID must be specified"));
            } else {
                var8_16 = this.c(this.srv_app_id);
                if (var8_16 != null) {
                    var5_5.add(new BuilderError("srv_app_id", "ID", "Server App ID " + (String)var8_16));
                }
            }
        }
        if (this.deepLink_urlscheme != null) {
            var9_14 = this.deepLink_urlscheme.length();
            if (var9_14 < 4 || var9_14 > 32) {
                var5_5.add(new BuilderError("deepLink_urlscheme", "URL scheme", var9_14 > 4, "URL scheme length must be between 4 and 32 characters"));
            } else {
                var10_17 = this.deepLink_urlscheme.toCharArray();
                if (var10_17[0] >= 48 && var10_17[0] <= 57) {
                    var5_5.add(new BuilderError("deepLink_urlscheme", "URL scheme", false, "URL scheme cannot start with a digit"));
                } else {
                    var14_32 = var10_17;
                    var13_31 = ((Object)var14_32).length;
                    var12_29 = 0;
                    while (var12_29 < var13_31) {
                        var11_26 = var14_32[var12_29];
                        if (var11_26 < 97 || var11_26 > 122 || var11_26 >= 48 && var11_26 <= 57) {
                            var5_5.add(new BuilderError("deepLink_urlscheme", "URL scheme", false, "URL scheme cannot start with a digit"));
                        }
                        ++var12_29;
                    }
                }
            }
        }
        if (this.output_path == null || this.output_path.isEmpty()) {
            var5_5.add(new BuilderError("output_path", "Output path", false, "Output path must be specified"));
        } else if (this.output_path.equals(".") || this.output_path.startsWith("..")) {
            var5_5.add(new BuilderError("output_path", "Output path", false, "Output cannot be current directory or a relative path starting with \"..\""));
        } else if (var3_3 != null) {
            if (!(var3_3 = Utilities.getCanonicalFile(var3_3)).isDirectory()) {
                var5_5.add(new BuilderError("output_path", "Output path", "Project directory \"" + String.valueOf(var3_3) + "\" is not present"));
            } else {
                this.b = Utilities.getCanonicalFile(new File(var3_3, this.output_path));
                if (!this.b.isDirectory()) {
                    this.b = Utilities.getCanonicalFile(new File(this.output_path));
                    if (!this.b.isDirectory()) {
                        var5_5.add(new BuilderError("output_path", "Output path", "Output directory \"" + this.output_path + "\" is not found, either relative project nor by absolute path"));
                    }
                }
            }
        } else {
            this.b = Utilities.getCanonicalFile(new File(this.output_path));
            if (this.b.exists() && !this.b.isDirectory()) {
                var5_5.add(new BuilderError("output_path", "Output path", "Output directory \"" + String.valueOf(this.b) + "\" is not a directory"));
            }
        }
        if (this.jdk_path != null) {
            if (this.jdk_path.isEmpty()) {
                var5_5.add(new BuilderError("jdk_path", "JDK path", false, "JDK path cannot be empty"));
            } else {
                var9_15 = Utilities.getCanonicalFile(new File(this.jdk_path));
                if (!var9_15.isDirectory()) {
                    var5_5.add(new BuilderError("jdk_path", "JDK path", "JDK directory \"" + String.valueOf(var9_15) + "\" is not present"));
                } else {
                    var10_17 = Utilities.getCanonicalFile(new File(var9_15, "bin"));
                    if (!var10_17.isDirectory()) {
                        var5_5.add(new BuilderError("jdk_path", "JDK path", "JDK Java Runtime subdirectory \"" + String.valueOf(var10_17) + "\" is not present"));
                    }
                }
            }
        }
        if ((this.plugin_camera || this.plugin_firebase || this.plugin_geolocation || this.plugin_media || this.plugin_media_capture) && this.textTable == null) {
            var5_5.add(new BuilderError("app_textTable", "Text table", "A plugin requires the presence of the text table for prompts to the user"));
        }
        if (this.build_android) {
            if (this.app_id_android != null) {
                if (this.app_id_android.isEmpty()) {
                    var5_5.add(new BuilderError("app_id_android", "App ID", false, "Android App ID must be specified (e.g. 'com.your.name') or left undefined for default '" + this.app_id + "'"));
                } else {
                    var8_16 = this.d(this.app_id_android);
                    if (var8_16 != null) {
                        var5_5.add(new BuilderError("app_id_android", "App ID", "Android App ID " + (String)var8_16));
                    }
                }
            }
            if (!this.isInternalBuild()) {
                if (!(this.build_target_types != 0 && this.build_target_types != 2 || this.hasAndroidKeyStore(false))) {
                    var5_5.add(new BuilderError("android_cert_debug_p12", "Debug code signing certificate", false, "Android Debug code signing certificate must be generated"));
                }
                if (!(this.build_target_types != 1 && this.build_target_types != 2 || this.hasAndroidKeyStore(true))) {
                    var5_5.add(new BuilderError("android_cert_release_p12", "Release code signing certificate", false, "Android Release code signing certificate must be generated"));
                }
            }
        }
        if (this.build_ios && this.app_id_ios != null) {
            if (this.app_id_ios.isEmpty()) {
                var5_5.add(new BuilderError("app_id_ios", "App ID", false, "iOS App ID must be specified (e.g. 'com.your.name') or left undefined for default '" + this.app_id + "'"));
            } else {
                var8_16 = this.d(this.app_id_ios);
                if (var8_16 != null) {
                    var5_5.add(new BuilderError("app_id_ios", "App ID", "iOS App ID " + (String)var8_16));
                }
            }
        }
    }

    public File getOutputDirectory() {
        return this.b;
    }

    public String getLocalizedString(PlainKString plainKString, String string) {
        String string2;
        try {
            string2 = plainKString.getPLAINString(this.textTable, string);
        }
        catch (NullPointerException nullPointerException) {
            string2 = plainKString.getRawString();
            ILog.SEVERE(this.getClass(), "PlainKString contains references to text table, but app settings has no text table defined: " + string2);
        }
        catch (Throwable throwable) {
            string2 = plainKString.getRawString();
            ILog.SEVERE(this.getClass(), "Unexcepted error for PlainKString: " + string2, throwable);
        }
        return string2;
    }

    public File getAssetsSubdirectory() {
        return this.a;
    }

    public boolean hasAndroidKeyStore(boolean bl) {
        return RuntimeBuilderSettings.hasAndroidKeyStore(this.props, bl);
    }

    public static boolean hasAndroidKeyStore(RuntimeBuilderProps runtimeBuilderProps, boolean bl) {
        String string;
        String string2 = string = bl ? "release" : "debug";
        return runtimeBuilderProps.containsProp("android_cert_" + string + "_p12") && runtimeBuilderProps.containsProp("android_cert_" + string + "_pw");
    }

    public static String getAndroidDebugAlias() {
        return "androiddebugkey";
    }

    public static String getAndroidReleaseAlias() {
        return "iizi";
    }

    public static String getAndroidDebugPassword() {
        return "android";
    }

    public String getAndroidReleasePassword() {
        return RuntimeBuilderSettings.getAndroidReleasePassword(this.props);
    }

    public static String getAndroidReleasePassword(RuntimeBuilderProps runtimeBuilderProps) {
        PasswordProp passwordProp = runtimeBuilderProps.getProp("android_cert_release_pw", PasswordProp.class);
        return passwordProp != null ? passwordProp.getString() : null;
    }

    public static X500Principal getAndroidDebugOwner() {
        return new X500Principal("CN=Android Debug,O=Android,C=US");
    }

    public X500Principal getAndroidCertificateOwner() throws Exception {
        String string = this.cert_CN;
        if (string == null || string.isEmpty()) {
            string = this.getLocalizedString(this.author_name, null);
        }
        return CertificateHelper.createX500Principal(string, this.cert_OU, this.cert_O != null ? this.cert_O : string, this.cert_L, this.cert_ST, this.cert_C);
    }

    public File generateAndroidDebugKeyStore(File file) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, IllegalStateException, SignatureException, KeyStoreException, CertificateException, IOException, PropException {
        return RuntimeBuilderSettings.generateAndroidDebugKeyStore(this.props, file);
    }

    public static File generateAndroidDebugKeyStore(RuntimeBuilderProps runtimeBuilderProps, File file) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, IllegalStateException, SignatureException, KeyStoreException, CertificateException, IOException, PropException {
        String string = RuntimeBuilderSettings.getAndroidDebugPassword();
        char[] cArray = string.toCharArray();
        X500Principal x500Principal = RuntimeBuilderSettings.getAndroidDebugOwner();
        KeyStore keyStore = GenerateKeystore.generateSelfSignedX509Certificate(x500Principal, RuntimeBuilderSettings.getAndroidDebugAlias(), cArray);
        PasswordProp passwordProp = new PasswordProp(Atom.get("android_cert_debug_pw"), string);
        PKCS12IdentityProp pKCS12IdentityProp = new PKCS12IdentityProp(Atom.get("android_cert_debug_p12"));
        pKCS12IdentityProp.setKeyStore(keyStore, cArray, "Android Debug code signing: " + String.valueOf(x500Principal));
        runtimeBuilderProps.removeProp("android_cert_debug_p12");
        runtimeBuilderProps.removeProp("android_cert_debug_pw");
        runtimeBuilderProps.addProp(pKCS12IdentityProp);
        runtimeBuilderProps.addProp(passwordProp);
        File file2 = null;
        if (file != null) {
            file2 = new File(file, "android-debug.p12");
            RuntimeBuilderSettings.writeAndroidKeyStore(runtimeBuilderProps, file2, false);
        }
        return file2;
    }

    public File generateAndroidReleaseKeyStore(X500Principal x500Principal, File file) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, IllegalStateException, SignatureException, KeyStoreException, CertificateException, IOException, PropException {
        return RuntimeBuilderSettings.generateAndroidReleaseKeyStore(this.props, x500Principal, file);
    }

    public static File generateAndroidReleaseKeyStore(RuntimeBuilderProps runtimeBuilderProps, X500Principal x500Principal, File file) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, IllegalStateException, SignatureException, KeyStoreException, CertificateException, IOException, PropException {
        String string = RuntimeBuilderSettings.getAndroidReleaseAlias();
        String string2 = "mindus";
        char[] cArray = string2.toCharArray();
        KeyStore keyStore = GenerateKeystore.generateSelfSignedX509Certificate(x500Principal, string, cArray);
        PasswordProp passwordProp = new PasswordProp(Atom.get("android_cert_release_pw"), string2);
        PKCS12IdentityProp pKCS12IdentityProp = new PKCS12IdentityProp(Atom.get("android_cert_release_p12"));
        pKCS12IdentityProp.setKeyStore(keyStore, cArray, "Android Release code signing: " + String.valueOf(x500Principal));
        runtimeBuilderProps.removeProp("android_cert_release_p12");
        runtimeBuilderProps.removeProp("android_cert_release_pw");
        runtimeBuilderProps.addProp(pKCS12IdentityProp);
        runtimeBuilderProps.addProp(passwordProp);
        File file2 = null;
        if (file != null) {
            file2 = new File(file, "android-release.p12");
            RuntimeBuilderSettings.writeAndroidKeyStore(runtimeBuilderProps, file2, true);
        }
        return file2;
    }

    public String writeAndroidKeyStore(File file, boolean bl) throws NotFoundException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return RuntimeBuilderSettings.writeAndroidKeyStore(this.props, file, bl);
    }

    public static String writeAndroidKeyStore(RuntimeBuilderProps runtimeBuilderProps, File file, boolean bl) throws NotFoundException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String string = bl ? "release" : "debug";
        PKCS12IdentityProp pKCS12IdentityProp = runtimeBuilderProps.getProp("android_cert_" + string + "_p12", PKCS12IdentityProp.class);
        PasswordProp passwordProp = runtimeBuilderProps.getProp("android_cert_" + string + "_pw", PasswordProp.class);
        if (pKCS12IdentityProp == null || passwordProp == null) {
            throw new NotFoundException("The Android " + string + " keystore is not found");
        }
        String string2 = passwordProp.getString();
        char[] cArray = string2.toCharArray();
        KeyStore keyStore = pKCS12IdentityProp.getKeyStore(cArray);
        Throwable throwable = null;
        Object var10_11 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            keyStore.store(fileOutputStream, cArray);
            fileOutputStream.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return string2;
    }

    public TextTable getTextTable() {
        return this.textTable;
    }

    public TextTable[] getDerivedTextTables() {
        if (this.a == null) {
            this.a = this.textTable != null ? this.textTable.getDerivedTextTables() : TextTable.EMPTY_ARRAY;
        }
        return this.a;
    }

    public boolean isInternalBuild() {
        return false;
    }
}

