/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.vs;

import com.iizix.NotFoundException;
import com.iizix.api.IAnnotationReferenceProcessor;
import com.iizix.prop.GProp;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VirtualSpace;

public class VSAnnotationReferenceProcessor
implements IAnnotationReferenceProcessor<VirtualSpace, VSComponent> {
    @Override
    public Class<VirtualSpace> getScopeClass() {
        return VirtualSpace.class;
    }

    @Override
    public VSComponent resolveReference(GProp<?> gProp, String string) throws PropTypeException, NotFoundException {
        if (!(gProp instanceof VirtualSpace)) {
            throw new PropTypeException(gProp, "scope '" + gProp.getReferencePropName() + "' should be an instance of " + VirtualSpace.class.getName());
        }
        VirtualSpace virtualSpace = (VirtualSpace)gProp;
        VSComponent vSComponent = virtualSpace.getVSComponent(string, VSComponent.class);
        if (vSComponent == null) {
            throw new NotFoundException("VS component reference '" + string + "' is not found in '" + gProp.getReferencePropName() + "'");
        }
        return vSComponent;
    }

    @Override
    public String getReferencePath(GProp<?> gProp) throws IllegalStateException, PropTypeException {
        if (gProp instanceof VSComponent) {
            return ((VSComponent)gProp).getVSRef();
        }
        throw new PropTypeException(gProp, "Not instanceof VSComponent");
    }
}

