/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.Size;
import com.iizix.Value;
import com.iizix.api.ui.UISelectionEvent;
import com.iizix.event.GEvent;
import com.iizix.event.IPostEventProcessing;
import com.iizix.prop.Atom;
import com.iizix.prop.ClassReference;
import com.iizix.prop.GProp;
import com.iizix.prop.MethodReference;
import com.iizix.prop.PropException;
import com.iizix.prop.ValueConversionException;
import com.iizix.prop.ui.IUICheckComponent;
import com.iizix.prop.ui.IUIContextMenuOwner;
import com.iizix.prop.ui.IUIFocusComp;
import com.iizix.prop.ui.IUILabelForTarget;
import com.iizix.prop.ui.IUISelectionListener;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.vs.VSField;
import java.lang.reflect.Method;
import java.util.List;

public class UICheckBox
extends UIComp
implements IUICheckComponent,
IUIContextMenuOwner,
IUIFocusComp,
IUILabelForTarget {
    private Method f;
    private GenericListener<IUISelectionListener> a;

    public UICheckBox() {
    }

    public UICheckBox(Atom atom) {
        super(atom);
    }

    public UICheckBox(Atom atom, GProp<?>[] gPropArray) throws PropException {
        super(atom, gPropArray);
    }

    @Override
    public UICheckBox clone() {
        UICheckBox uICheckBox = (UICheckBox)super.clone();
        uICheckBox.a = null;
        return uICheckBox;
    }

    @Override
    public Atom getSelectionPropAtom() {
        return CHECKED_ATOM;
    }

    @Override
    public synchronized GenericListener<IUISelectionListener> getSelectionListenerHandler(boolean bl) {
        if (this.a == null && bl) {
            this.a = new GenericListener<IUISelectionListener>(IUISelectionListener.class);
        }
        return this.a;
    }

    @Override
    public final int getDeviceType() {
        return 0;
    }

    @Override
    public boolean isMobileContextMenuSupported() {
        return true;
    }

    @Override
    public boolean canFillX() {
        return false;
    }

    @Override
    public boolean canFillY() {
        return false;
    }

    @Override
    public void onValueChanged(VSField vSField, Value value, GProp<?> gProp, IPostEventProcessing iPostEventProcessing) {
        if (this.getVSField() == vSField) {
            UICheckBox.onValueChanged(this, vSField);
        }
    }

    @Override
    protected void onSelectionChanged(GEvent gEvent) {
        VSField vSField = this.getVSField();
        if (vSField != null) {
            UICheckBox.setComponentCheckStateToVSField(this, vSField);
        }
    }

    public static int setComponentCheckStateToVSField(UIComp uIComp, VSField vSField) {
        if (uIComp.enterVSProcessing(vSField)) {
            try {
                String string;
                Value value = null;
                switch (uIComp.getInt("checked", -1)) {
                    case 0: {
                        value = uIComp.getValue("uncheckedValue");
                        string = "Unchecked";
                        break;
                    }
                    case 1: {
                        value = uIComp.getValue("checkedValue");
                        string = "Checked";
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                if (value == null) {
                    ILog.SEVERE(uIComp.getClass(), "CheckBox component does not have the " + string + " value defined", (Object)("Component " + uIComp.getReferencePropName() + ": " + String.valueOf(uIComp)));
                    return 0;
                }
                vSField.setValue(value, true, uIComp);
                uIComp.setVSFieldMessageToComponent(vSField, true);
                return 1;
            }
            catch (ValueConversionException valueConversionException) {
                uIComp.setErrorMessage(valueConversionException);
                return -1;
            }
            finally {
                uIComp.exitVSProcessing();
            }
        }
        return 0;
    }

    public static int onValueChanged(UIComp uIComp, VSField vSField) {
        if (vSField == uIComp.getVSField() && uIComp.enterVSProcessing(vSField)) {
            try {
                int n2 = vSField.convertEqualsValue(uIComp, uIComp.getValue("uncheckedValue"), uIComp.getValue("checkedValue"));
                if (n2 < 0) {
                    switch (uIComp.getInt("checkNoMatch")) {
                        default: {
                            return -1;
                        }
                        case 1: {
                            n2 = 0;
                            break;
                        }
                        case 2: {
                            n2 = 1;
                            break;
                        }
                        case 3: {
                            n2 = 2;
                        }
                    }
                }
                uIComp.setInt("checked", n2);
                int n3 = n2;
                return n3;
            }
            finally {
                uIComp.exitVSProcessing();
            }
        }
        return -1;
    }

    @Override
    protected void onPrepare(ClassReference classReference, List<Throwable> list) {
        super.onPrepare(classReference, list);
        MethodReference methodReference = this.getProp("$OnUISelection", MethodReference.class);
        if (methodReference != null) {
            this.f = methodReference.lookupMethod(classReference, list, UISelectionEvent.class);
        }
    }

    @Override
    public Method getOnUISelectionMethod() {
        return this.f;
    }

    @Override
    public Size getApproximateSize() {
        return new Size(16, 16);
    }
}

