/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.image;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.XMLUtilities;
import com.iizix.prop.AssetReference;
import com.iizix.prop.IPropErrorItem;
import com.iizix.prop.PropErrorItem;
import com.iizix.prop.image.SVGDefinition;
import com.iizix.text.KStringHTMLImageTag;
import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SVGInfo {
    private static Transformer a;
    private static long a;
    private final Document a;
    public final double width;
    public final double height;
    private final boolean a;
    private String a;
    private double a;
    private double b;
    private boolean b;

    private static synchronized String a() {
        return "IzS" + ++a + "-";
    }

    private static Transformer a() throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        if (a != null) {
            return a;
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("method", "html");
        a = transformer;
        return a;
    }

    public static SVGInfo fromDefinition(File file) {
        Document document;
        try {
            document = XMLUtilities.loadXMLDocument(file);
        }
        catch (IOException | SAXException exception) {
            return null;
        }
        return SVGInfo.a(document, file.getAbsolutePath(), null, null, true);
    }

    public static SVGInfo fromString(String string) throws IOException, SAXException {
        StringBuilder stringBuilder = new StringBuilder();
        SVGInfo sVGInfo = SVGInfo.a(XMLUtilities.loadXMLDocument(string), null, stringBuilder, null, true);
        if (sVGInfo != null) {
            return sVGInfo;
        }
        throw new SAXException("SVG string error: " + String.valueOf(stringBuilder));
    }

    static SVGInfo a(Document document, String string, StringBuilder stringBuilder, int[] nArray, boolean bl) {
        Element element = document.getDocumentElement();
        String string2 = element.getTagName();
        SVGInfo sVGInfo = null;
        Object object = null;
        int n2 = 2;
        if (!string2.equals("svg")) {
            object = "document element is not \"svg\" but \"" + string2 + "\"";
        } else {
            String string3 = "invalid 'viewbox' attribute value";
            try {
                Object[] objectArray;
                String string4 = element.getAttribute("viewBox");
                boolean bl2 = !string4.isEmpty();
                String string5 = element.getAttribute("width");
                String string6 = element.getAttribute("height");
                if (bl2 && (string5.isEmpty() || string6.isEmpty()) && (objectArray = string4.split(" ")).length == 4) {
                    if (string5.isEmpty()) {
                        try {
                            string5 = Double.toString(Double.parseDouble(objectArray[2]));
                            element.setAttribute("width", string5 + "px");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string6.isEmpty()) {
                        try {
                            string6 = Double.toString(Double.parseDouble(objectArray[3]));
                            element.setAttribute("height", string5 + "px");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (string5.isEmpty()) {
                    object = "width is not specified";
                } else if (string6.isEmpty()) {
                    object = "height is not specified";
                } else {
                    objectArray = new boolean[1];
                    string3 = "invalid width";
                    double d2 = SVGInfo.a(string5, (boolean[])objectArray);
                    if (d2 <= 0.0) {
                        throw new Exception();
                    }
                    string3 = "invalid height";
                    double d3 = SVGInfo.a(string6, (boolean[])objectArray);
                    if (d3 <= 0.0) {
                        throw new Exception();
                    }
                    if (objectArray[0] != false) {
                        ILog.WARNING(SVGInfo.class, (String)(string != null ? "SVG file \"" + string + "\" width/height is not in 'px' (pixels): assuming pixels instead" : "SVG string width/height is not in 'px' (pixels): assuming pixels instead"));
                    }
                    string3 = "Failed cleaning up SVG";
                    SVGInfo.a(element, bl);
                    sVGInfo = new SVGInfo(document, d2, d3, bl2);
                    sVGInfo.a();
                }
            }
            catch (Throwable throwable) {
                object = string3;
            }
        }
        if (stringBuilder != null && object != null) {
            stringBuilder.append((String)object);
            if (nArray != null) {
                nArray[0] = n2;
            }
        }
        return sVGInfo;
    }

    private static double a(String string, boolean[] blArray) throws NumberFormatException {
        int n2 = (string = string.trim()).length();
        if (n2 == 0) {
            return -1.0;
        }
        if (string.toLowerCase().endsWith("px")) {
            string = string.substring(0, n2 - 2).trim();
        } else {
            char c2 = string.charAt(n2 - 1);
            blArray[0] = (c2 < '0' || c2 > '9') && c2 != '.';
            while (n2 > 0) {
                c2 = string.charAt(n2 - 1);
                if (c2 >= '0' && c2 <= '9') {
                    string = string.substring(0, n2).trim();
                    break;
                }
                --n2;
            }
        }
        return Double.parseDouble(string);
    }

    public static SVGInfo fromDefinition(SVGDefinition sVGDefinition) {
        Object object;
        Object object2;
        AssetReference assetReference = sVGDefinition.getAssetReference();
        if (assetReference == null) {
            return null;
        }
        URL uRL = assetReference.getFileURL();
        if (uRL == null) {
            return null;
        }
        SVGInfo sVGInfo = null;
        int n2 = 0;
        Object object3 = null;
        try {
            Document document = XMLUtilities.loadXMLDocument(uRL);
            object2 = new StringBuilder();
            object = new int[1];
            sVGInfo = SVGInfo.a(document, uRL.toExternalForm(), (StringBuilder)object2, object, sVGDefinition.getBool("removeXY", true));
            n2 = object[0];
            if (n2 != 0) {
                object3 = ((StringBuilder)object2).toString();
            } else {
                SVGInfo.a(document, uRL);
            }
        }
        catch (CSSException | IOException | SAXException throwable) {
            n2 = 2;
            object3 = "Failed loading SVG file \"" + uRL.toExternalForm() + "\": " + throwable.getMessage();
        }
        catch (Throwable throwable) {
            n2 = 2;
            object3 = "Failed loading SVG file \"" + uRL.toExternalForm() + "\": " + throwable.getMessage();
            ILog.SEVERE(SVGInfo.class, (String)object3, throwable);
        }
        object2 = object3 != null ? new PropErrorItem("file", (String)object3, "SVG definition", n2, new String[0]) : null;
        object = sVGDefinition.getPropError("file");
        if (object2 != null ? !object2.equals(object) : object != null) {
            if (object2 == null) {
                sVGDefinition.removePropError("file");
            } else {
                sVGDefinition.addPropError((IPropErrorItem)object2);
            }
        }
        if (sVGInfo != null) {
            sVGInfo.updateFromDefinition(sVGDefinition);
        }
        return sVGInfo;
    }

    private static void a(Element element, boolean bl) {
        element.removeAttribute("id");
        if (bl) {
            element.removeAttribute("x");
            element.removeAttribute("y");
        }
        NodeList nodeList = element.getElementsByTagName("metadata");
        int n2 = nodeList.getLength();
        while (--n2 >= 0) {
            Node node = nodeList.item(n2);
            node.getParentNode().removeChild(node);
        }
        SVGInfo.a(element);
    }

    private static void a(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            switch (node.getNodeType()) {
                case 8: {
                    element.removeChild(node);
                    break;
                }
                case 3: {
                    if (!node.getTextContent().isBlank()) break;
                    element.removeChild(node);
                    break;
                }
                case 1: {
                    if (!(node instanceof Element)) break;
                    SVGInfo.a((Element)node);
                }
            }
            node = node2;
        }
    }

    private static void a(Document document, URL uRL) throws IOException, CSSException {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("style");
        int n2 = nodeList.getLength();
        if (n2 == 0) {
            return;
        }
        String[] stringArray = new String[1];
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n3 = 0;
        while (n3 < n2) {
            SVGInfo.a(uRL, nodeList.item(n3), linkedHashMap, stringArray);
            ++n3;
        }
        if (linkedHashMap.isEmpty()) {
            return;
        }
        SVGInfo.a(element, linkedHashMap);
    }

    private static void a(URL uRL, Node node, Map<String, String> map, String[] stringArray) throws IOException, CSSException {
        Object object2;
        String string = node.getTextContent();
        if (string.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = null;
        StyleSheet styleSheet = CSSFactory.parseString((String)string, (URL)uRL);
        for (Object object2 : styleSheet.asList()) {
            if (!SVGInfo.a(object2, map, stringArray)) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(object2.toString().replace("\t", "").replace("\n", ""));
        }
        if (stringBuilder != null && !((String)(object2 = stringBuilder.toString())).equals(string)) {
            node.setTextContent((String)object2);
        }
    }

    private static boolean a(RuleBlock<?> ruleBlock, Map<String, String> map, String[] stringArray) {
        boolean bl = false;
        if (ruleBlock instanceof RuleSet) {
            bl = SVGInfo.a((RuleSet)ruleBlock, map, stringArray);
        }
        return bl;
    }

    private static boolean a(RuleSet ruleSet, Map<String, String> map, String[] stringArray) {
        boolean bl = false;
        CombinedSelector[] combinedSelectorArray = ruleSet.getSelectors();
        int n2 = combinedSelectorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            CombinedSelector combinedSelector = combinedSelectorArray[n3];
            for (Selector selector : combinedSelector.asList()) {
                for (Object e2 : selector.asList()) {
                    if (!(e2 instanceof Selector.ElementClass)) continue;
                    Selector.ElementClass elementClass = (Selector.ElementClass)e2;
                    String string = elementClass.getClassName();
                    Object object = map.get(string);
                    if (object == null) {
                        object = stringArray[0];
                        if (object == null) {
                            stringArray[0] = SVGInfo.a();
                            object = stringArray[0];
                        }
                        object = (String)object + Integer.toString(map.size() + 1);
                        map.put(string, (String)object);
                    }
                    bl = true;
                    elementClass.setClassName((String)object);
                }
            }
            ++n3;
        }
        return bl;
    }

    private static void a(Element element, Map<String, String> map) {
        Object object;
        Object object2;
        String string = element.getAttribute("class");
        if (!string.isEmpty()) {
            object2 = new StringBuilder();
            Object object3 = new StringTokenizer(string, " ");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object = ((StringTokenizer)object3).nextToken();
                Object object4 = map.get(object);
                if (object4 == null) {
                    object4 = object;
                }
                if (((StringBuilder)object2).length() > 0) {
                    ((StringBuilder)object2).append(' ');
                }
                ((StringBuilder)object2).append((String)(object4 != null ? object4 : object));
            }
            object3 = ((StringBuilder)object2).toString();
            if (!((String)object3).equals(string)) {
                element.setAttribute("class", (String)object3);
            }
        }
        object2 = element.getChildNodes();
        int n2 = object2.getLength();
        while (--n2 >= 0) {
            object = object2.item(n2);
            if (!(object instanceof Element)) continue;
            SVGInfo.a((Element)object, map);
        }
    }

    private SVGInfo(Document document, double d2, double d3, boolean bl) {
        this.a = document;
        this.width = d2;
        this.height = d3;
        this.a = bl;
    }

    public void updateFromDefinition(SVGDefinition sVGDefinition) {
        if (!this.a) {
            this.b = sVGDefinition.getBool("addViewBox");
            Element element = this.a.getDocumentElement();
            boolean bl = element.getAttribute("viewbox").isEmpty();
            if (bl != this.b) {
                if (bl) {
                    element.removeAttribute("viewbox");
                } else {
                    String string = "0 0 " + Utilities.getShortestDouble(this.width) + " " + Utilities.getShortestDouble(this.height);
                    element.setAttribute("viewbox", string);
                }
            }
        }
        this.setScale(sVGDefinition.getInt("cx"), sVGDefinition.getInt("cy"));
    }

    public void setScale(int n2, int n3) {
        double d2 = n2;
        double d3 = n3;
        if (n2 > 0 || n3 > 0) {
            if (n2 <= 0 && n3 > 0) {
                d2 = this.width * d3 / this.height;
            }
            if (n3 <= 0 && n2 > 0) {
                d3 = this.height * d2 / this.width;
            }
        }
        this.a = d2;
        this.b = d3;
        this.a();
    }

    public String getXMLString() {
        try {
            return XMLUtilities.getXMLDocument(this.a);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    private void a() {
        this.a = this.a(this.getWidth(), this.getHeight());
    }

    private String a(double d2, double d3) {
        Element element = (Element)this.a.getDocumentElement().cloneNode(true);
        element.setAttribute("width", Utilities.getShortestDouble(d2) + "px");
        element.setAttribute("height", Utilities.getShortestDouble(d3) + "px");
        try {
            StringWriter stringWriter = new StringWriter();
            SVGInfo.a().transform(new DOMSource(element), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            ILog.SEVERE(this.getClass(), "Failed SVG string transformation", transformerException);
            return "<em>SVG failed</em>";
        }
    }

    public double getWidth() {
        return this.a > 0.0 ? this.a : this.width;
    }

    public double getHeight() {
        return this.b > 0.0 ? this.b : this.height;
    }

    public String getSVGForHTML() {
        return this.a;
    }

    public boolean hasViewBox() {
        return this.a;
    }

    public String getKStringSVG(KStringHTMLImageTag kStringHTMLImageTag) {
        String string = this.a;
        String string2 = kStringHTMLImageTag.getAttribute("width");
        String string3 = kStringHTMLImageTag.getAttribute("height");
        if (string2 != null || string3 != null) {
            double d2 = 0.0;
            if (string2 != null) {
                try {
                    d2 = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            double d3 = 0.0;
            if (string3 != null) {
                try {
                    d3 = Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string = this.getKStringSVG(d2, d3);
        }
        return string != null ? string : "<em>SVG failed</em>";
    }

    public String getKStringSVG(double d2, double d3) {
        String string = this.a;
        if (d2 > 0.0 || d3 > 0.0) {
            if (d2 <= 0.0 || d3 <= 0.0) {
                if (d3 > 0.0) {
                    d2 = this.width * d3 / this.height;
                } else {
                    d3 = this.height * d2 / this.width;
                }
            }
            string = this.a(d2, d3);
        }
        return string != null ? string : "<em>SVG failed</em>";
    }
}

