/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.GFill;
import com.iizix.prop.GRect;
import com.iizix.prop.IPropMgrInfoProvider;
import com.iizix.prop.PropMgr;
import com.iizix.prop.image.ClientImageData;
import com.iizix.prop.image.IImageTarget;
import java.util.StringTokenizer;

public class GFillPattern
extends GFill {
    public final int x;
    public final int y;
    public final int cx;
    public final int cy;
    public final String imageReference;

    GFillPattern(StringTokenizer stringTokenizer) throws IllegalArgumentException, NumberFormatException {
        this.x = Integer.parseInt(stringTokenizer.nextToken());
        if (this.x < 0) {
            throw new IllegalArgumentException("x is negative");
        }
        this.y = Integer.parseInt(stringTokenizer.nextToken());
        if (this.y < 0) {
            throw new IllegalArgumentException("y is negative");
        }
        this.cx = Integer.parseInt(stringTokenizer.nextToken());
        if (this.cx < 0) {
            throw new IllegalArgumentException("cx is negative");
        }
        this.cy = Integer.parseInt(stringTokenizer.nextToken());
        if (this.cy < 0) {
            throw new IllegalArgumentException("cy is negative");
        }
        this.imageReference = stringTokenizer.nextToken("\t").substring(1);
    }

    GFillPattern(ReadTransaction readTransaction) {
        this.x = readTransaction.readUnsigned();
        this.y = readTransaction.readUnsigned();
        this.cx = readTransaction.readUnsigned();
        this.cy = readTransaction.readUnsigned();
        this.imageReference = readTransaction.readString();
    }

    public GFillPattern(int n2, int n3, int n4, int n5, String string) {
        if (n2 < 0) {
            throw new IllegalArgumentException("x is negative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("y is negative");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("width is negative");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("height is negative");
        }
        if (string == null) {
            throw new NullPointerException("imageReference is null");
        }
        this.x = n2;
        this.y = n3;
        this.cx = n4;
        this.cy = n5;
        this.imageReference = string;
    }

    public GRect getRect() {
        return new GRect(this.x, this.y, this.cx, this.cy);
    }

    public String getImageReference() {
        return this.imageReference;
    }

    @Override
    public GFill.Type getType() {
        return GFill.Type.PATTERN;
    }

    @Override
    void a(PropMgr propMgr, SendTransaction sendTransaction) {
        ClientImageData clientImageData;
        IImageTarget iImageTarget;
        sendTransaction.appendByte(2);
        sendTransaction.appendUnsigned(this.x);
        sendTransaction.appendUnsigned(this.y);
        sendTransaction.appendUnsigned(this.cx);
        sendTransaction.appendUnsigned(this.cy);
        Object object = this.imageReference;
        IPropMgrInfoProvider iPropMgrInfoProvider = propMgr.getProvider();
        if (iPropMgrInfoProvider != null && (iImageTarget = iPropMgrInfoProvider.getImageTarget((String)(object = "images/unresolved.png"))) != null && iImageTarget.isImageTargetValid() && (clientImageData = iImageTarget.getClientImageData()) != null) {
            clientImageData = clientImageData.adjustTo(iPropMgrInfoProvider.getDPR());
            String string = iPropMgrInfoProvider.getHTTPServer();
            String string2 = clientImageData.getDefaultResource();
            if (string != null && string2 != null) {
                object = string + iPropMgrInfoProvider.getResourcePrefix() + string2;
            }
        }
        sendTransaction.appendString((String)object);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GFillPattern) {
            GFillPattern gFillPattern = (GFillPattern)object;
            return this.x == gFillPattern.x && this.y == gFillPattern.y && this.cx == gFillPattern.cx && this.cy == gFillPattern.cy && this.imageReference.equals(gFillPattern.imageReference);
        }
        return false;
    }

    @Override
    public GFillPattern clone() {
        return this;
    }

    @Override
    protected String paramString() {
        return this.x + "," + this.y + "," + this.cx + "," + this.cy + "," + this.imageReference;
    }
}

