/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.Atom;
import com.iizix.prop.GColor;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;

public class ColorProp
extends GProp<GColor> {
    private static final Class<?>[] a = new Class[]{GColor.class, Long.class, Integer.class, String.class};

    public ColorProp() {
    }

    public ColorProp(Atom atom) {
        super(atom);
    }

    public ColorProp(Atom atom, GColor gColor) {
        super(atom);
        this.setPropValue(gColor);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPropValue(GColor gColor) {
        try {
            return super.setPropValue(gColor);
        }
        catch (PropException propException) {
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof GColor)) {
            throw new PropTypeException(this, "newValue not GColor");
        }
    }

    public GColor getColor() {
        GColor gColor = (GColor)this.getPropValue();
        if (gColor == null) {
            gColor = GColor.NONE;
        }
        return gColor;
    }

    public boolean setColor(GColor gColor) {
        return this.setPropValue(gColor);
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        GColor gColor = (GColor)object;
        if (gColor == null) {
            gColor = GColor.NONE;
        }
        gColor.appendColor(sendTransaction);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        GColor gColor = GColor.from(readTransaction);
        return this.setPropValue((Object)gColor, propMgr);
    }

    @Override
    public Object fromElementString(String string) throws PropException {
        try {
            return GColor.createGColor(string);
        }
        catch (Exception exception) {
            throw new PropException(this, "fromElementString (" + string + ") error: " + String.valueOf(exception), exception);
        }
    }

    @Override
    public String toElementString(Object object) {
        return ((GColor)object).getString();
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return (long)((GColor)object).getColor();
            }
            case 2: {
                return ((GColor)object).getColor();
            }
            case 3: {
                return ((GColor)object).getString();
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return new GColor(((Long)object).intValue(), true);
            }
            case 2: {
                return new GColor((Integer)object, true);
            }
            case 3: {
                return GColor.createGColor((String)object);
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    public String getCSSValue() {
        GColor gColor = (GColor)this.getPropValue();
        return gColor != null ? gColor.getCSSValue() : null;
    }
}

