/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.Utilities;
import com.iizix.editor.GeneratedAtom;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Atom
implements Cloneable,
Comparable<Atom> {
    public static final String RESERVED_CHARS = ":/\\{}\"'?*^,;";
    private static final WeakHashMap<String, WeakReference<Atom>> a = new WeakHashMap(2048);
    private final String a;
    public static final Atom SYSTEM = Atom.get("$system");
    public static final Atom SERVER = Atom.get("$server");
    public static final Atom CLIENT = Atom.get("$client");
    public static final Atom EVENT = Atom.get("$event");
    public static final Atom ENV = Atom.get("$env");
    public static final Atom HEADER = Atom.get("$header");
    public static final Atom ERROR = Atom.get("$error");
    public static final Atom INDEX = Atom.get("$index");
    public static final Atom APPS = Atom.get("$apps");
    public static final Atom FILENAME = Atom.get("$fileName");
    public static final Atom ROOT = Atom.get("$root");
    public static final Atom ICON = Atom.get("$icon");
    public static final Atom BINDINGS = Atom.get("$bindings");
    public static final Atom PORT = Atom.get("$port");
    public static final Atom BIND = Atom.get("$bind");
    public static final Atom RESOLVE = Atom.get("$resolve");
    public static final Atom HOST = Atom.get("$host");
    public static final Atom SSL = Atom.get("$SSL");
    public static final Atom PROXYHOST = Atom.get("$proxyHost");
    public static final Atom PROXYPORT = Atom.get("$proxyPort");
    public static final Atom PROXYTYPE = Atom.get("$proxyType");
    public static final Atom WEBSOCKET = Atom.get("$webSocket");
    public static final Atom USER = Atom.get("$user");
    public static final Atom EXTENDS = Atom.get("$extends");
    public static final Atom STYLES = Atom.get("$styles");
    public static final Atom CLIENT_STYLES = Atom.get("$cstyles");
    public static final Atom SETTINGS = Atom.get("$settings");
    public static final Atom ROWS = Atom.get("$rows");
    public static final Atom RAW = Atom.get("$raw");
    public static final Atom NULL = Atom.get("$null");
    public static final Atom ACTORS = Atom.get("$actors");
    public static final Atom PATTERN = Atom.get("$pattern");
    public static final Atom FOCUS = Atom.get("$focus");
    public static final Atom TRANSACTION = Atom.get("$transaction");
    public static final Atom CONNECTORS = Atom.get("$connectors");
    public static final Atom TYPE = Atom.get("$type");
    public static final Atom COMPONENTS = Atom.get("$components");
    public static final Atom COMPONENT = Atom.get("$component");
    public static final Atom UI_CONTAINER = Atom.get("$uiContainer");
    public static final Atom UI_COMPONENT = Atom.get("$uiComponent");
    public static final Atom UI_PREVIEW = Atom.get("$uiPreview");
    public static final Atom VISIBLE = Atom.get("$visible");
    public static final Atom ENABLED = Atom.get("$enabled");
    public static final Atom READONLY = Atom.get("$readOnly");
    public static final Atom SELECTED = Atom.get("$selected");
    public static final Atom SELECTOR = Atom.get("$selector");
    public static final Atom LAYOUT = Atom.get("$layout");
    public static final Atom LAYOUT_MANAGER = Atom.get("$layoutManager");
    public static final Atom TEXT = Atom.get("$text");
    public static final Atom CHARUPDATE = Atom.get("$charUpdate");
    public static final Atom DATA_CONTAINER = Atom.get("$dataContainer");
    public static final Atom PANEL = Atom.get("$panel");
    public static final Atom HSCROLL = Atom.get("$hscroll");
    public static final Atom VSCROLL = Atom.get("$vscroll");
    public static final Atom TITLE = Atom.get("$title");
    public static final Atom TOOLTIP = Atom.get("$tooltip");
    public static final Atom MESSAGE = Atom.get("$message");
    public static final Atom TOASTER = Atom.get("$toaster");
    public static final Atom BADGE = Atom.get("$badge");
    public static final Atom POPUP = Atom.get("$popup");
    public static final Atom PLUGINS = Atom.get("$plugins");
    public static final Atom CLASS = Atom.get("$class");
    public static final Atom INPUT = Atom.get("$input");
    public static final Atom BODY = Atom.get("$body");
    public static final Atom OUTPUT = Atom.get("$output");
    public static final Atom JAVA = Atom.get("$java");
    public static final Atom TIMESTAMP = Atom.get("$timestamp");
    public static final Atom WIDTH = Atom.get("$width");
    public static final Atom HEIGHT = Atom.get("$height");
    public static final Atom FIELDS = Atom.get("$fields");
    public static final Atom CID = Atom.get("$cid");
    public static final Atom ID = Atom.get("$id");
    public static final Atom IDS = Atom.get("$ids");
    public static final Atom ACTION = Atom.get("$action");
    public static final Atom ACTIONS = Atom.get("$actions");
    public static final Atom ALIGN = Atom.get("$align");
    public static final Atom RTL = Atom.get("$rtl");
    public static final Atom LOCATION = Atom.get("$location");
    public static final Atom DELAY = Atom.get("$delay");
    public static final Atom DERIVES = Atom.get("$derives");
    public static final Atom VSFIELD = Atom.get("$vsField");
    public static final Atom VSTABLE = Atom.get("$vsTable");
    public static final Atom VSCOLUMN = Atom.get("$vsColumn");
    public static final Atom QNAME = Atom.get("$qname");
    public static final Atom NAME = Atom.get("$name");
    public static final Atom ENCODING = Atom.get("$encoding");
    public static final Atom REFERENCE = Atom.get("$ref");
    public static final Atom VIRTUALSPACE = Atom.get("$vs");
    public static final Atom PARTICIPANTS = Atom.get("$participants");
    public static final Atom PRIMARY = Atom.get("$primary");
    public static final Atom VALUE = Atom.get("$value");
    public static final Atom MSG = Atom.get("$msg");
    public static final Atom MCAT = Atom.get("$mcat");
    public static final Atom DESCR = Atom.get("$descr");
    public static final Atom DEFAULT = Atom.get("$default");
    public static final Atom GEO = Atom.get("$geo");
    public static final Atom ZONES = Atom.get("$zones");
    public static final Atom LANG = Atom.get("$lang");
    public static final Atom THEMES = Atom.get("$themes");
    public static final Atom DEVICE = Atom.get("$device");
    public static final Atom URI = Atom.get("$uri");
    public static final Atom URI_PARAMS = Atom.get("$uriParams");
    public static final Atom METHOD = Atom.get("$method");
    public static final Atom OVERRIDE_METHOD = Atom.get("$overrideMethod");
    public static final Atom READ_TIMEOUT = Atom.get("$readTimeout");
    public static final Atom IGNORE = Atom.get("$ignore");
    public static final Atom DOC = Atom.get("$doc");
    public static final Atom CACHE = Atom.get("$cache");
    public static final Atom STYLE = Atom.get("$style");
    public static final Atom WEIGHT = Atom.get("$weight");
    public static final Atom RANGE = Atom.get("$range");
    public static final Atom CONTEXT_MENU = Atom.get("$contextMenu");
    public static final Atom CONTEXT_MENU_REF = Atom.get("$contextMenuRef");
    public static final Atom CSS_CLASSNAME = Atom.get("$cssNames");
    public static final Atom DESIGNER = Atom.get("$designer");
    public static final Atom MODULE_APP = Atom.get("$moduleApp");
    public static final Atom PWA = Atom.get("$pwa");
    public static final Atom PUSH = Atom.get("$push");
    public static final String ON_VS_CREATE = "$OnVSCreate";
    public static final String ON_VS_DESTROY = "$OnVSDestroy";
    public static final String ON_VS_ACTION = "$OnVSAction";
    public static final String ON_VS_CHANGE = "$OnVSChange";
    public static final String ON_VS_FOCUS = "$OnVSFocus";
    public static final String ON_VS_STATE = "$OnVSState";
    public static final String ON_UI_CONNECT = "$OnUIConnect";
    public static final String ON_UI_CREATE = "$OnUICreate";
    public static final String ON_UI_DESTROY = "$OnUIDestroy";
    public static final String ON_UI_ACTION = "$OnUIAction";
    public static final String ON_UI_BACK = "$OnUIBack";
    public static final String ON_UI_TEXT_CHANGE = "$OnUITextChange";
    public static final String ON_UI_VALUE_CHANGE = "$OnUIValueChange";
    public static final String ON_UI_FOCUS = "$OnUIFocus";
    public static final String ON_UI_SELECTION = "$OnUISelection";
    public static final Atom ATOM_ON_VS_CREATE = Atom.get("$OnVSCreate");
    public static final Atom ATOM_ON_VS_DESTROY = Atom.get("$OnVSDestroy");
    public static final Atom ATOM_ON_VS_ACTION = Atom.get("$OnVSAction");
    public static final Atom ATOM_ON_VS_CHANGE = Atom.get("$OnVSChange");
    public static final Atom ATOM_ON_VS_FOCUS = Atom.get("$OnVSFocus");
    public static final Atom ATOM_ON_VS_STATE = Atom.get("$OnVSState");
    public static final Atom ATOM_ON_UI_CONNECT = Atom.get("$OnUIConnect");
    public static final Atom ATOM_ON_UI_CREATE = Atom.get("$OnUICreate");
    public static final Atom ATOM_ON_UI_DESTROY = Atom.get("$OnUIDestroy");
    public static final Atom ATOM_ON_UI_ACTION = Atom.get("$OnUIAction");
    public static final Atom ATOM_ON_UI_BACK = Atom.get("$OnUIBack");
    public static final Atom ATOM_ON_UI_TEXT_CHANGE = Atom.get("$OnUITextChange");
    public static final Atom ATOM_ON_UI_VALUE_CHANGE = Atom.get("$OnUIValueChange");
    public static final Atom ATOM_ON_UI_FOCUS = Atom.get("$OnUIFocus");
    public static final Atom ATOM_ON_UI_SELECTION = Atom.get("$OnUISelection");
    public static final String VSFIELD_NAME = "$vsField";

    public static synchronized Atom get(String string) {
        Atom atom;
        if (string == null) {
            throw new NullPointerException("name = null");
        }
        WeakReference<Atom> weakReference = a.get(string);
        if (weakReference == null || (atom = (Atom)weakReference.get()) == null) {
            String string2 = Atom.validateName(string);
            if (string2 != null) {
                throw new IllegalArgumentException("Invalid atom name (" + string + "): " + string2);
            }
            string = string.intern();
            atom = new Atom(string);
            a.put(string, new WeakReference<Atom>(atom));
        }
        return atom;
    }

    public static synchronized Atom find(String string) {
        WeakReference<Atom> weakReference = a.get(string);
        return weakReference != null ? (Atom)weakReference.get() : null;
    }

    public static boolean isValidName(String string) {
        return Atom.validateName(string) == null;
    }

    public static boolean isValidName(String string, boolean bl) {
        return Atom.validateName(string, bl) == null;
    }

    public static String validateName(String string) {
        return Atom.validateName(string, true);
    }

    public static String validateName(String string, boolean bl) {
        int n2 = string.length();
        if (n2 == 0) {
            return "cannot be empty";
        }
        if (string.equals(".")) {
            return "cannot be \".\"";
        }
        if (string.equals("..")) {
            return "cannot be \"..\"";
        }
        if (!bl && string.charAt(0) == '$') {
            return "cannot start with '$'";
        }
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 < ' ') {
                return "character codepoint range error: " + c2 + " must be >= 32 (space)";
            }
            if (RESERVED_CHARS.indexOf(c2) >= 0) {
                return c2 == '\"' ? "cannot contain the character: '" + c2 + "'" : "cannot contain the character: \"" + c2 + "\"";
            }
            ++n3;
        }
        return null;
    }

    public static String createValidName(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 >= ' ' && RESERVED_CHARS.indexOf(c2) < 0 && (n2 != 0 || c2 != '$' || bl)) {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        String string2 = stringBuilder.toString();
        if (string2.equals(".") || string2.equals("..")) {
            string2 = "";
        }
        return string2;
    }

    public static boolean isInside(Atom atom, Atom[] atomArray) {
        Atom[] atomArray2 = atomArray;
        int n2 = atomArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Atom atom2 = atomArray2[n3];
            if (atom2 == atom) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private Atom(String string) {
        this.a = string;
    }

    protected Atom(String string, int n2) {
        if (!this.getClass().equals(GeneratedAtom.class)) {
            throw new IllegalArgumentException("Only for GAtom!");
        }
        this.a = string;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int compareTo(Atom atom) {
        return Utilities.COLLATOR.compare(this.a, atom.a);
    }

    public String getAtomName() {
        return this.a;
    }

    public String toString() {
        return "atom[" + this.a + "]";
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public Atom clone() {
        return this;
    }
}

