/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.event.GEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.ModuleApp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.StringArrayProp;
import com.iizix.prop.TextTable;
import com.iizix.util.WindowsLikeFilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AppLanguages
extends PropCnr {
    private StringArrayProp a;
    private Data a;

    protected AppLanguages() {
    }

    AppLanguages(Atom atom) {
        super(atom);
    }

    @Override
    protected void addPredefinedProps() throws PropException {
        super.addPredefinedProps();
        this.a = this.maybeAddProp(new StringArrayProp(Atom.LANG));
    }

    @Override
    protected void getPredefinedProps() {
        super.getPredefinedProps();
        this.a = this.getProp(Atom.LANG, StringArrayProp.class);
    }

    @Override
    public AppLanguages clone() {
        try {
            AppLanguages appLanguages = (AppLanguages)super.clone();
            return appLanguages;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Can't be", cloneNotSupportedException);
        }
    }

    @Override
    protected void onPropInvalidateCache() {
        this.a = null;
    }

    @Override
    public void onEventSelf(GEvent gEvent) {
        switch (gEvent.getEventID()) {
            case 1: 
            case 2: 
            case 3: {
                this.onPropInvalidateCache();
            }
        }
    }

    public ModuleApp getModuleApp() {
        ModuleApp moduleApp = this.getParent(ModuleApp.class);
        if (moduleApp == null) {
            throw new InternalError("ModuleApp is null in " + String.valueOf(this));
        }
        return moduleApp;
    }

    public TextTable getTextTable() {
        return this.getModuleApp().getTextTable();
    }

    public boolean isAppLocalized() {
        return this.getBool("localized");
    }

    public String getDefaultLanguageCode() {
        return this.getString("defaultLang");
    }

    public boolean setDefaultLanguageCode(String string) {
        return string == null || string.isEmpty() ? this.removeProp2("defaultLang") : this.setString("defaultLang", string);
    }

    public Result mapLanguage(String string) {
        return this.getData().mapLanguage(string);
    }

    public StringArrayProp getLanguageDefinitions() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data getData() {
        Data data = this.a;
        if (data == null) {
            String string = this.getDefaultLanguageCode();
            StringArrayProp stringArrayProp = this.getProp(Atom.LANG, StringArrayProp.class);
            AppLanguages appLanguages = this;
            synchronized (appLanguages) {
                data = this.a;
                if (data == null) {
                    data = this.a = this.a(string, stringArrayProp != null ? stringArrayProp.getArrayList() : Collections.emptyList());
                }
            }
        }
        return data;
    }

    private Data a(String string, List<String> list) {
        Result result = string != null ? new Result(string, string) : null;
        LinkedHashMap<Object, Result> linkedHashMap = new LinkedHashMap<Object, Result>();
        LinkedHashMap<Object, Result> linkedHashMap2 = new LinkedHashMap<Object, Result>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            Object object;
            Result result2;
            int n2 = string2.indexOf(9);
            if (n2 < 0) {
                ILog.SEVERE(this.getClass(), "Ignored invalid language map entry '" + string2 + "' in AppLanguages property " + this.getReferencePropName());
                continue;
            }
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            if (string4.isEmpty()) {
                result2 = new Result(string3, null);
                object = linkedHashMap.putIfAbsent(string3, result2);
                if (object == null || ((Result)object).equals(result2)) continue;
                arrayList.add("Application-defined language '" + string3 + "' is already defined by: " + String.valueOf(object));
                continue;
            }
            result2 = new Result(string3, string3);
            linkedHashMap.put(string3, result2);
            String[] stringArray = string4.split(",");
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                object = stringArray[n4];
                if (((String)object).isEmpty()) {
                    arrayList.add("Empty 'Used for' specification: '" + string4 + "'");
                } else if (((String)object).indexOf(42) < 0 && ((String)object).indexOf(63) < 0) {
                    var17_21 = linkedHashMap.putIfAbsent(object, result2);
                    if (var17_21 != null && !var17_21.equals(result2)) {
                        arrayList.add("Used-for language '" + (String)object + "' is already defined by: " + String.valueOf(var17_21));
                    }
                } else {
                    var17_21 = linkedHashMap2.putIfAbsent(object, result2);
                    if (var17_21 != null && !var17_21.equals(result2)) {
                        arrayList.add("Wildcard used-for language '" + (String)object + "' is already defined by: " + String.valueOf(var17_21));
                    }
                }
                ++n4;
            }
        }
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("Language defintions in ").append(this.getReferencePropName()).append(" produced the following errors: ");
            for (String string5 : arrayList) {
                stringBuilder.append("\n - ").append(string5);
            }
            ILog.WARNING(this.getClass(), stringBuilder.toString());
        }
        return new Data(Collections.unmodifiableMap(linkedHashMap), Collections.unmodifiableMap(linkedHashMap2), result, arrayList);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class Data {
        public final Map<String, Result> languageCodeMap;
        public final Map<String, Result> wildCardMap;
        public final List<String> errors;
        private final Result a;
        private final ConcurrentHashMap<String, Result> a = new ConcurrentHashMap();

        private Data(Map<String, Result> map, Map<String, Result> map2, Result result, ArrayList<String> arrayList) {
            this.languageCodeMap = map;
            this.wildCardMap = map2;
            this.a = result;
            this.errors = arrayList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(arrayList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Result mapLanguage(String string) {
            Result result = this.languageCodeMap.get(string);
            if (result == null) {
                Map.Entry<String, Result> entry2 = this;
                synchronized (entry2) {
                    result = (Result)((ConcurrentHashMap)((Object)this.a)).get(string);
                }
                if (result == null) {
                    result = this.a;
                    for (Map.Entry<String, Result> entry2 : this.wildCardMap.entrySet()) {
                        if (!WindowsLikeFilenameFilter.isMatching(string, (String)entry2.getKey(), true, false)) continue;
                        result = (Result)entry2.getValue();
                        break;
                    }
                    if (result == null) {
                        result = new Result(string);
                    }
                    result = ((ConcurrentHashMap)((Object)this.a)).putIfAbsent(string, result);
                }
            }
            return result;
        }
    }

    public static class Result {
        public final String applicationLanguageCode;
        public final String userLanguageCode;
        public final boolean isUnknownLanguage;

        private Result(String string) {
            this.isUnknownLanguage = true;
            this.applicationLanguageCode = string;
            this.userLanguageCode = null;
        }

        private Result(String string, String string2) {
            this.isUnknownLanguage = false;
            this.applicationLanguageCode = string;
            this.userLanguageCode = string2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Result)) {
                return false;
            }
            Result result = (Result)object;
            return this.isUnknownLanguage == result.isUnknownLanguage && this.applicationLanguageCode.equals(result.applicationLanguageCode) && (this.userLanguageCode != null ? this.userLanguageCode.equals(result.userLanguageCode) : result.userLanguageCode == null);
        }

        public int hashCode() {
            int n2 = this.applicationLanguageCode.hashCode();
            if (this.userLanguageCode != null) {
                n2 = 31 * n2 + this.userLanguageCode.hashCode();
            }
            return this.isUnknownLanguage ? ~n2 : n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("language code '").append(this.applicationLanguageCode).append('\'');
            if (this.userLanguageCode != null) {
                stringBuilder.append(", change user language to '").append(this.userLanguageCode).append('\'');
            }
            if (this.isUnknownLanguage) {
                stringBuilder.append(", unknown language code");
            }
            return stringBuilder.toString();
        }
    }
}

