/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.FixedVirtualizedAbstractReference;
import com.iizix.prop.IGProp;
import com.iizix.prop.IPropCnr;
import com.iizix.prop.PropCnr;
import com.iizix.prop.ReferenceString;

public abstract class AbstractFixedVirtualizedBaseRelativeReference<TARGET extends IPropCnr>
extends FixedVirtualizedAbstractReference<TARGET> {
    protected AbstractFixedVirtualizedBaseRelativeReference() {
    }

    public AbstractFixedVirtualizedBaseRelativeReference(Atom atom) {
        super(atom);
    }

    public AbstractFixedVirtualizedBaseRelativeReference(Atom atom, String string) {
        super(atom, string);
    }

    @Override
    protected boolean doPostResolve() {
        return true;
    }

    @Override
    protected String getLookupPropReference(ReferenceString referenceString) {
        String string = referenceString.toString();
        PropCnr propCnr = this.getPropBaseReference();
        if (propCnr != null) {
            String string2 = propCnr.getReferencePropName();
            string = string.isEmpty() ? string2 : string2 + "/" + string;
        } else {
            ILog.WARNING(this.getClass(), "Base reference not found", "This reference instance: " + this.getReferencePropName() + ": " + String.valueOf(this), "Look-up reference: " + string);
        }
        return string;
    }

    @Override
    protected String setLookedUpReference(String string) {
        String string2;
        PropCnr propCnr = this.getPropBaseReference();
        if (propCnr != null && string.startsWith(string2 = propCnr.getReferencePropName())) {
            int n2 = string2.length();
            if (string.length() > n2) {
                if (string.charAt(n2) == '/') {
                    return string.substring(n2 + 1);
                }
                ILog.WARNING(this.getClass(), "Base reference '" + string2 + "' not parent of looked-up base reference '" + string + "'", "This reference instance: " + this.getReferencePropName() + ": " + String.valueOf(this), "Base property: " + string2 + ": " + String.valueOf(propCnr));
                return string;
            }
            return "";
        }
        ILog.WARNING(this.getClass(), "Base reference not found", "This reference instance: " + this.getReferencePropName() + ": " + String.valueOf(this), "Looked-up Base relative reference: " + string);
        return string;
    }

    @Override
    protected String validateReferenceScope(TARGET TARGET) {
        PropCnr propCnr = this.getPropBaseReference();
        return propCnr == null ? "Base property container not found" : (propCnr == TARGET || propCnr.isChild((IGProp<?>)TARGET) ? null : this.getScopeErrorMessage());
    }

    protected String getScopeErrorMessage() {
        return "Target reference is not a child of the base property container";
    }
}

