/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.comm.oauth;

import com.iizix.SessionInfo;
import com.iizix.text.ILocaleString;
import com.iizix.text.LocaleString;

public enum AuthenticationProvider {
    Internal("Internal", false),
    Apple("Apple", true),
    Facebook("Facebook", true),
    Google("Google", true),
    LinkedIn("LinkedIn", true),
    Microsoft("Microsoft", true),
    Twitter("Twitter", true);

    public final String providerName;
    public final boolean isExternal;
    public final String textID;

    private AuthenticationProvider(String string2, boolean bl) {
        this.providerName = string2;
        this.isExternal = bl;
        this.textID = "authProvider." + this.name();
    }

    public String getLocalizedName() {
        return LocaleString.asString(this.textID, this.providerName);
    }

    public String getLocalizedName(SessionInfo sessionInfo) {
        return LocaleString.asString(sessionInfo, this.textID, this.providerName);
    }

    public String getLocalizedName(ILocaleString iLocaleString) {
        return LocaleString.asString(iLocaleString, this.textID, this.providerName);
    }

    public static AuthenticationProvider fromProviderName(String string) {
        AuthenticationProvider[] authenticationProviderArray = AuthenticationProvider.values();
        int n2 = authenticationProviderArray.length;
        int n3 = 0;
        while (n3 < n2) {
            AuthenticationProvider authenticationProvider = authenticationProviderArray[n3];
            if (string.equalsIgnoreCase(authenticationProvider.providerName)) {
                return authenticationProvider;
            }
            ++n3;
        }
        return null;
    }
}

