/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.comm;

import com.iizix.comm.IPortController;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;

public class PortConfig {
    public final int port;
    public final boolean isHTTPS;
    public final boolean isFrontEndSecured;
    public final boolean isSecured;
    public final String bind;
    public final String externalHostName;
    public final int externalPort;
    public final String externalNameAndPort;
    public final IPortController controller;

    public PortConfig(int n2, boolean bl, boolean bl2, String string, String string2, int n3, IPortController iPortController) {
        if (n2 <= 0) {
            n2 = bl ? 443 : 80;
        }
        this.port = n2;
        this.isHTTPS = bl;
        this.isFrontEndSecured = bl2;
        this.bind = string;
        this.externalHostName = string2;
        this.externalPort = n3;
        this.controller = iPortController;
        boolean bl3 = bl;
        Object object = string2;
        if (object != null && n3 > 0) {
            if (bl2) {
                bl3 = true;
                if (n3 != 443) {
                    object = (String)object + ":" + n3;
                }
            } else if (n3 != 80) {
                object = (String)object + ":" + n3;
            }
        }
        this.externalNameAndPort = object;
        this.isSecured = bl3;
    }

    public void restartConnector() {
        this.controller.restart();
    }

    public boolean isSamePortConfig(PortConfig portConfig) {
        return this.port == portConfig.port && this.isHTTPS == portConfig.isHTTPS && this.externalPort == portConfig.externalPort && this.isFrontEndSecured == portConfig.isFrontEndSecured && Objects.equals(this.bind, portConfig.bind) && Objects.equals(this.externalHostName, portConfig.externalHostName);
    }

    public String getRemoteServerNameAndPort(HttpServletRequest httpServletRequest) {
        return this.getRemoteServerNameAndPort(httpServletRequest, true);
    }

    public String getRemoteServerNameAndPort(HttpServletRequest httpServletRequest, boolean bl) {
        if (bl && this.externalNameAndPort != null) {
            return this.externalNameAndPort;
        }
        String string = this.externalHostName != null ? this.externalHostName : httpServletRequest.getServerName();
        int n2 = this.externalPort;
        if (n2 == 0) {
            n2 = this.port;
        }
        if (this.isSecured ? bl && n2 == 443 : bl && n2 == 80) {
            return string;
        }
        return string + ":" + n2;
    }

    public String getRemoteProtocolServerNameAndPort(HttpServletRequest httpServletRequest) {
        return this.getRemoteProtocolServerNameAndPort(httpServletRequest, true);
    }

    public String getRemoteProtocolServerNameAndPort(HttpServletRequest httpServletRequest, boolean bl) {
        return (this.isSecured ? "https://" : "http://") + this.getRemoteServerNameAndPort(httpServletRequest, bl);
    }
}

