/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.user;

import com.iizix.gyro.IRuntimeImageCache;
import com.iizix.prop.image.RuntimeImageDefinition;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.gyro.ClientSessionGyro;
import com.iizix.server.user.AuthenticatedUser;
import com.iizix.server.user.UserProfileImageRequest;
import com.iizix.urn.user.IUserProfileImageRequest;
import com.iizix.urn.user.IUserProfileImageURNProvider;
import java.io.IOException;

public class UserProfileImageURNProvider
implements IUserProfileImageURNProvider {
    private static UserProfileImageURNProvider a = new UserProfileImageURNProvider();

    public static UserProfileImageURNProvider getInstance() {
        return a;
    }

    public UserProfileImageRequest createRequest() {
        return new UserProfileImageRequest();
    }

    public RuntimeImageDefinition getProfileImage(IUserProfileImageRequest iUserProfileImageRequest) throws IOException {
        UserProfileImageRequest userProfileImageRequest = (UserProfileImageRequest)iUserProfileImageRequest.clone();
        int n = userProfileImageRequest.getWidth();
        if (n <= 0) {
            throw new IllegalStateException("Missing width in request");
        }
        int n2 = userProfileImageRequest.getHeight();
        if (n2 <= 0) {
            throw new IllegalStateException("Missing height in request");
        }
        AuthenticatedUser authenticatedUser = userProfileImageRequest.getUser();
        AppSessionGyro appSessionGyro = userProfileImageRequest.getAppSessionGyro();
        ClientSessionGyro clientSessionGyro = userProfileImageRequest.getClientSessionGyro();
        if (appSessionGyro == null && clientSessionGyro == null) {
            clientSessionGyro = ClientSessionGyro.getSessionInstance();
            appSessionGyro = AppSessionGyro.getSessionInstance();
        }
        if (clientSessionGyro != null) {
            if (appSessionGyro == null) {
                appSessionGyro = clientSessionGyro.getAppSessionGyro();
            }
            if (authenticatedUser == null) {
                authenticatedUser = clientSessionGyro.getAppSessionGyro().getAuthenticatedUser();
            }
        } else if (appSessionGyro != null) {
            clientSessionGyro = ClientSessionGyro.getSessionInstance();
            if (clientSessionGyro.getAppSessionGyro() != appSessionGyro) {
                clientSessionGyro = null;
            }
            if (authenticatedUser == null) {
                AuthenticatedUser authenticatedUser2 = authenticatedUser = clientSessionGyro != null ? clientSessionGyro.getAppSessionGyro().getAuthenticatedUser() : appSessionGyro.getAuthenticatedUser();
            }
        }
        if (authenticatedUser == null) {
            if (!userProfileImageRequest.doCreateDefault()) {
                return null;
            }
            authenticatedUser = AuthenticatedUser.getUndefinedUser();
        }
        ClientSessionGyro clientSessionGyro2 = clientSessionGyro != null ? clientSessionGyro : (appSessionGyro != null ? appSessionGyro : authenticatedUser.a);
        return authenticatedUser.a((IRuntimeImageCache)clientSessionGyro2, n, n2, userProfileImageRequest.getQuality(), userProfileImageRequest.doCreateDefault(), userProfileImageRequest.getCorners(), userProfileImageRequest.getDPRs());
    }
}

