/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.prop;

import com.iizix.prop.Atom;
import com.iizix.prop.EnvProps;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IPropRoot;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.StringMapProp;
import com.iizix.server.ServerShell;
import com.iizix.server.prop.ServerSettings;
import java.io.File;
import java.io.IOException;

public class ServerProps
extends PropCnr
implements IPropRoot {
    protected EnvProps envProps;
    protected ServerSettings serverSettings;
    private final PropMgr a;

    public static ServerProps createServerProps(PropMgr propMgr) {
        ServerProps serverProps = new ServerProps(Atom.SERVER, propMgr);
        serverProps.resetChangedTree();
        return serverProps;
    }

    public ServerProps() {
        this.a = null;
    }

    protected ServerProps(Atom atom, PropMgr propMgr) {
        super(atom);
        this.a = propMgr;
    }

    protected boolean shouldSerializeToXML(int n) {
        return false;
    }

    public String getRootName(GProp<?> gProp) {
        return "";
    }

    public PropCnr getRootFromName(GProp<?> gProp, String string) {
        return string != null && string.isEmpty() ? this : null;
    }

    public final boolean isPropRoot() {
        return true;
    }

    protected boolean isPropRootTreeModificationsAllowed() {
        return !this.isDisposed();
    }

    public final boolean isPropReferenceTreeValid() {
        return !this.isDisposed();
    }

    public final PropMgr getPropRootPropMgr() {
        return this.a;
    }

    protected ServerSettings createServerSettings() {
        return new ServerSettings(Atom.SETTINGS);
    }

    protected void addPredefinedProps() throws PropException {
        super.addPredefinedProps();
        this.envProps = (EnvProps)this.maybeAddProp((IGProp)new EnvProps(Atom.ENV));
        this.serverSettings = (ServerSettings)this.maybeAddProp((IGProp)this.createServerSettings());
    }

    protected void getPredefinedProps() {
        super.getPredefinedProps();
        this.envProps = (EnvProps)this.getProp(Atom.ENV, EnvProps.class);
        this.serverSettings = (ServerSettings)this.getProp(Atom.SETTINGS, ServerSettings.class);
    }

    public ServerProps clone() {
        try {
            return (ServerProps)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public EnvProps getEnvironment() {
        return this.envProps;
    }

    public StringMapProp getServerEnv() {
        return this.envProps.getServerEnv();
    }

    public StringMapProp getClientEnv() {
        return this.envProps.getClientEnv();
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public ServerSettings loadServerSettings(ServerShell serverShell, File file) throws IOException, PropException {
        PropCnr propCnr = serverShell.loadFile(file);
        if (!(propCnr instanceof ServerSettings)) {
            throw new PropException((GProp)this, "File '" + file.getAbsolutePath() + "' is not a Server Settings property file");
        }
        ServerSettings serverSettings = (ServerSettings)propCnr;
        serverSettings.renameProp(Atom.SETTINGS);
        this.removeProp2(Atom.SETTINGS);
        this.addProp2((IGProp)serverSettings);
        this.serverSettings = serverSettings;
        return serverSettings;
    }
}

