/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.text;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.ImageRegistry;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.jface.PartAction;
import com.iizigo.project.ModuleModel;
import com.iizigo.prop.editor.ImageReferencePropEditor;
import com.iizigo.prop.editor.dialog.HyperlinkDialog;
import com.iizigo.prop.editor.dialog.ImageDefinitionFilter;
import com.iizigo.prop.editor.dialog.InsertTextIDDialog;
import com.iizigo.prop.editor.dialog.InsertTextVSDialog;
import com.iizigo.prop.editor.dialog.RichTextEditorDialog;
import com.iizigo.prop.editor.dialog.SelectPropDialog;
import com.iizigo.text.KStringStyledText;
import com.iizigo.text.TextTableEditor;
import com.iizigo.text.prop.EditorTextTable;
import com.iizigo.vs.VSHelper;
import com.iizigo.vs.prop.EditorVirtualSpace;
import com.iizix.IDisposedPart;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropErrorItem;
import com.iizix.prop.IPropUndoRedo;
import com.iizix.prop.KStringProp;
import com.iizix.prop.PropErrorItemValue;
import com.iizix.prop.vs.IVSAccessor;
import com.iizix.text.HTMLUtilities;
import com.iizix.text.IKStringHTMLHyperlink;
import com.iizix.text.IKStringTextTag;
import com.iizix.text.KString;
import com.iizix.text.KStringException;
import com.iizix.text.KStringHTMLImageTag;
import com.iizix.text.KStringTag;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CommonTextActions
implements CaretListener {
    private final Shell a;
    private final ModuleModel a;
    private final TextTableEditor a;
    private final IVSAccessor a;
    private final EditorTextTable a;
    private final IPropUndoRedo a;
    public final PartAction showRichText;
    public final PartAction insertImage;
    public final PartAction insertHyperlink;
    public final PartAction insertTextIDTag;
    public final PartAction insertTextVSTag;
    public final PartAction entryText;
    public final PartAction entryTextTag;
    public final PartAction entryHTML;
    public final PartAction entryHTMLTag;
    private KStringStyledText a;
    private Text a;
    private ViewerCell a;
    private KStringProp a;
    private int a;
    private boolean a;
    private boolean b;
    private final Listener a;
    private Boolean a;
    private final Listener b = event -> {
        int n2 = this.a.getCaretPosition();
        if (n2 != this.a) {
            this.a = n2;
            this.updateStates(this.a, false);
        }
    };
    private Listener c = event -> {
        if (this.a != null) {
            this.b.handleEvent(event);
        }
        this.b = false;
    };
    private Listener d = event -> {
        this.b = true;
    };
    private Listener e = event -> {
        this.a = null;
    };

    public CommonTextActions(Shell shell, ModuleModel moduleModel, TextTableEditor textTableEditor, IVSAccessor iVSAccessor, EditorTextTable editorTextTable, IPropUndoRedo iPropUndoRedo, Boolean bl) {
        this.a = shell;
        this.a = moduleModel;
        this.a = textTableEditor;
        this.a = iVSAccessor;
        this.a = editorTextTable;
        this.a = iPropUndoRedo;
        this.a = bl;
        ImageRegistry imageRegistry = ImageRegistry.getInstance();
        TextTableEditor textTableEditor2 = textTableEditor != null ? textTableEditor : iPropUndoRedo;
        this.showRichText = new PartAction((IDisposedPart)textTableEditor2, "Show &rich text editor...", "Shows the rich text editor for HTML text input", imageRegistry.get("rich_text.gif"), imageRegistry.get("rich_text_disabled.gif")).with(() -> {
            boolean bl = this.a(this.getCurrentNonErroredKString(), true);
        });
        this.insertTextIDTag = new PartAction((IDisposedPart)textTableEditor2, "Insert text ID tag...", "Inserts a tag with references to a text table", imageRegistry.get("insert_textid.png"), imageRegistry.get("insert_textid_disabled.png")).with(() -> {
            boolean bl = this.a(true, this.getCurrentNonErroredKString(), true);
        });
        this.insertTextVSTag = new PartAction((IDisposedPart)textTableEditor2, "Insert VirtualSpace Field tag...", "Inserts a tag with references to a VirtualSpace Field", imageRegistry.get("insert_textvs.png"), imageRegistry.get("insert_textvs_disabled.png")).with(() -> {
            boolean bl = this.a(false, this.getCurrentNonErroredKString(), true);
        });
        this.insertHyperlink = new PartAction((IDisposedPart)textTableEditor2, "Insert hyperlink...", "Inserts a hyperlink to an Action, UI component, resource or external site", imageRegistry.get("hyperlink.png"), imageRegistry.get("hyperlink_disabled.png")).with(() -> {
            boolean bl = this.b(this.getCurrentNonErroredKString(), true);
        });
        this.insertImage = new PartAction((IDisposedPart)textTableEditor2, "Insert image...", "Inserts an image from the Assets folder", imageRegistry.get("insert_image.png"), imageRegistry.get("insert_image_disabled.png")).with(() -> {
            boolean bl = this.c(this.getCurrentNonErroredKString(), true);
        });
        this.entryText = new PartAction((IDisposedPart)textTableEditor2, "Plain text", "Sets the entry to plain text type", imageRegistry.get("text_text.gif"), 2).with(() -> this.a(false, false));
        this.entryTextTag = new PartAction((IDisposedPart)textTableEditor2, "Plain text with tags", "Sets the entry to plain text type with tag processing", imageRegistry.get("text_text_tag.gif"), 2).with(() -> this.a(false, true));
        this.entryHTML = new PartAction((IDisposedPart)textTableEditor2, "HTML text", "Sets the entry to HTML text type", imageRegistry.get("text_html.gif"), 2).with(() -> this.a(true, false));
        this.entryHTMLTag = new PartAction((IDisposedPart)textTableEditor2, "HTML text with tags", "Sets the entry to HTML text type with tag processing", imageRegistry.get("text_html_tag.gif"), 2).with(() -> this.a(true, true));
        this.a = event -> {
            if (this.a != null) {
                this.b.handleEvent(event);
            }
            if (this.b) {
                this.b = false;
                if (this.a) {
                    if (this.insertImage.isEnabled()) {
                        this.insertImage.run();
                        return;
                    }
                    if (this.insertHyperlink.isEnabled()) {
                        this.insertHyperlink.run();
                        return;
                    }
                    if (this.insertTextIDTag.isEnabled()) {
                        this.insertTextIDTag.run();
                        return;
                    }
                    if (this.insertTextVSTag.isEnabled()) {
                        this.insertTextVSTag.run();
                        return;
                    }
                }
                if (this.a == null) {
                    this.openRichTextDialog();
                }
            }
        };
    }

    public void dispose() {
        this.showRichText.dispose();
        this.insertImage.dispose();
        this.insertHyperlink.dispose();
        this.insertTextIDTag.dispose();
        this.insertTextVSTag.dispose();
        this.entryText.dispose();
        this.entryTextTag.dispose();
        this.entryHTML.dispose();
        this.entryHTMLTag.dispose();
    }

    public void assignTextControl(KStringStyledText kStringStyledText) {
        this.a = kStringStyledText;
        if (kStringStyledText != null) {
            kStringStyledText.a = this.a;
            kStringStyledText.addCaretListener(this);
            this.a = kStringStyledText.getCaretOffset();
            kStringStyledText.addListener(3, this.c);
            kStringStyledText.addListener(4, this.a);
            kStringStyledText.addListener(8, this.d);
        }
    }

    public void assignTextControl(Text text, ViewerCell viewerCell) {
        if (text != this.a) {
            Text text2 = this.a;
            if (text2 != null) {
                text2.removeListener(3, this.c);
                text2.removeListener(4, this.a);
                text2.removeListener(8, this.d);
                text2.removeListener(5, this.b);
                text2.removeListener(37, this.b);
                text2.removeListener(38, this.b);
                text2.removeListener(1, this.b);
                text2.removeListener(2, this.b);
                text2.removeListener(15, this.b);
                text2.removeListener(12, this.e);
            }
            this.a = text;
            text.addListener(3, this.c);
            text.addListener(4, this.a);
            text.addListener(8, this.d);
            text.addListener(5, this.b);
            text.addListener(37, this.b);
            text.addListener(38, this.b);
            text.addListener(1, this.b);
            text.addListener(2, this.b);
            text.addListener(15, this.b);
            text.addListener(12, this.e);
        }
        this.a = text.getCaretPosition();
        this.updateStates(this.a, false);
        this.a = viewerCell;
    }

    public KString getCurrentNonErroredKString() {
        KString kString;
        KString kString2 = kString = this.a != null && !this.a.hasPropError() ? this.a.getKString() : null;
        if (kString != null && this.a != null && !this.a.isDisposed() && this.a.isVisible()) {
            try {
                boolean bl = this.a != null ? this.a.booleanValue() : kString.usesTagProcessing();
                kString = new KString(kString.getType(), this.a.getText(), bl);
            }
            catch (KStringException kStringException) {
                kString = null;
            }
        }
        return kString;
    }

    public void updateStates(KStringProp kStringProp, boolean bl) {
        KString kString;
        if (kStringProp != null && (this.a == null || bl && kStringProp != this.a)) {
            kString = kStringProp.getKString();
            this.a = kString != null && kString.usesTagProcessing();
        }
        this.a = kStringProp;
        this.a(false, false, this.entryText);
        this.a(false, true, this.entryTextTag);
        this.a(true, false, this.entryHTML);
        this.a(true, true, this.entryHTMLTag);
        kString = this.getCurrentNonErroredKString();
        this.showRichText.setEnabled(this.a(kString, false));
        this.insertImage.setEnabled(this.c(kString, false));
        this.insertHyperlink.setEnabled(this.b(kString, false));
        this.insertTextIDTag.setEnabled(this.a(true, kString, false));
        this.insertTextVSTag.setEnabled(this.a(false, kString, false));
    }

    private void a(boolean bl, boolean bl2, PartAction partAction) {
        int n2 = this.a(false, bl, bl2);
        partAction.setEnabled(n2 >= 0);
        partAction.setChecked(n2 > 0);
    }

    private void a(boolean bl, boolean bl2) {
        this.a(true, bl, bl2);
    }

    private int a(boolean bl, boolean bl2, boolean bl3) {
        if (this.a == null) {
            return -1;
        }
        KString kString = this.a.getKString();
        if (kString != null && kString.isHTML() == bl2 || kString == null) {
            if (bl) {
                this.a = bl3;
                if (this.a != null) {
                    this.a.a = this.a;
                }
                if (kString != null) {
                    try {
                        String string = null;
                        IPropErrorItem iPropErrorItem = this.a.getPropError(null);
                        string = iPropErrorItem instanceof PropErrorItemValue ? ((PropErrorItemValue)iPropErrorItem).getInput() : kString.getRawString();
                        if (!kString.isHTML() && kString.usesTagProcessing() != bl3) {
                            string = bl3 ? string.replace("{", "{{") : string.replace("{{", "{");
                        }
                        KString kString2 = new KString(kString.isHTML() ? KString.Type.HTML : KString.Type.PLAIN, string, bl3);
                        ComplexOperation complexOperation = new ComplexOperation("Convert value", null, this.a);
                        if (iPropErrorItem != null) {
                            complexOperation.removePropError((GProp<?>)this.a, null);
                        }
                        complexOperation.setPropValue((GProp<?>)this.a, kString2);
                        PropHelper.executeOperation(this.a, complexOperation);
                    }
                    catch (KStringException kStringException) {
                        Activator.messageBox(this.a, "KString type conversion error", "Failed conversion of KString: " + kStringException.getMessage(), 33);
                    }
                    this.updateStates(this.a, false);
                }
            }
            return Boolean.valueOf(bl3).equals(this.a) ? 1 : 0;
        }
        if (bl) {
            Object object;
            KString kString3 = null;
            String string = null;
            String string2 = null;
            IPropErrorItem iPropErrorItem = this.a.getPropError(null);
            if (iPropErrorItem instanceof PropErrorItemValue) {
                object = ((PropErrorItemValue)iPropErrorItem).getInput();
                try {
                    kString3 = new KString(bl2 ? KString.Type.HTML : KString.Type.PLAIN, (String)object, bl3);
                }
                catch (KStringException kStringException) {
                    string2 = object;
                    string = kStringException.getMessage();
                }
            } else if (bl2) {
                string2 = kString.getRawHTMLString();
                try {
                    kString3 = new KString(KString.Type.HTML, string2, bl3);
                }
                catch (KStringException kStringException) {
                    string = kStringException.getMessage();
                }
            } else {
                string2 = kString.getPLAINString(null);
                try {
                    kString3 = new KString(KString.Type.PLAIN, string2, bl3);
                    if (!kString3.getPLAINString(null).equals(string2) && Activator.messageBox(this.a, "Text conversion from HTML to plain text", "You will lose formatting and style information if you convert the HTML text into plain text.\n\nDo you wish to proceed?", 192) != 64) {
                        return 0;
                    }
                }
                catch (KStringException kStringException) {
                    string = kStringException.getMessage();
                }
            }
            if (kString3 == null) {
                try {
                    kString3 = new KString(bl2 ? KString.Type.HTML : KString.Type.PLAIN, "", bl3);
                }
                catch (KStringException kStringException) {
                    // empty catch block
                }
            }
            object = new ComplexOperation("Convert value", null, this.a);
            ((ComplexOperation)((Object)object)).setPropValue((GProp<?>)this.a, kString3);
            if (string != null) {
                ((ComplexOperation)((Object)object)).addPropError((GProp<?>)this.a, (IPropErrorItem)new PropErrorItemValue(string2, string));
            } else if (iPropErrorItem != null) {
                ((ComplexOperation)((Object)object)).removePropError((GProp<?>)this.a, null);
            }
            this.a = bl3;
            PropHelper.executeOperation(this.a, (AbstractOperation)object);
            this.updateStates(this.a, false);
        }
        return 0;
    }

    private void a(KString kString, String string) {
        ComplexOperation complexOperation = new ComplexOperation(string, null, this.a);
        complexOperation.setPropValue((GProp<?>)this.a, kString);
        PropHelper.executeOperation(this.a, complexOperation);
    }

    public void openRichTextDialog() {
        KString kString = this.getCurrentNonErroredKString();
        this.a(kString, true);
    }

    private boolean a(KString kString, boolean bl) {
        if (RichTextEditorDialog.isEnabled() && kString != null && kString.isHTML()) {
            if (bl && (kString = new RichTextEditorDialog(this.a, this.a, kString, this.a).open()) != null) {
                this.a(kString, "Edit rich text");
            }
            return true;
        }
        return false;
    }

    public void caretMoved(CaretEvent caretEvent) {
        this.a = caretEvent.caretOffset;
        this.updateStates(this.a, false);
    }

    private int a() {
        return this.a;
    }

    private void a(int n2, int n3) {
        if (this.a != null) {
            this.a.setSelection(n2, n3);
        } else if (this.a != null) {
            this.a.setSelection(n2, n3);
        }
    }

    private String a() {
        if (this.a != null) {
            return this.a.getText();
        }
        if (this.a != null && !this.a.isDisposed() && this.a.isVisible()) {
            return this.a.getText();
        }
        return null;
    }

    private void a(String string, String string2, int n2, int n3) {
        if (this.a != null) {
            this.a.insert(string);
            this.a.setSelection(n2, n2 + string.length());
        } else if (this.a != null && this.a != null) {
            this.a.a(this.a);
            String string3 = string2.substring(0, n2) + string + string2.substring(n3);
            this.a.setText(string3);
            this.a.setSelection(n2, n2 + string.length());
        }
    }

    private boolean a() {
        return this.a != null && this.a.getSelectionCount() > 0 || this.a != null && this.a.getSelectionCount() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean b(KString kString, boolean bl) {
        KStringTag kStringTag;
        int n2;
        if (kString == null || !kString.isHTML() || !this.a.booleanValue()) {
            return false;
        }
        String string = this.a();
        if (string == null) {
            return false;
        }
        String[] stringArray = new String[4];
        IKStringHTMLHyperlink iKStringHTMLHyperlink = null;
        int n3 = n2 = this.a();
        int n4 = n2;
        KStringTag kStringTag2 = kStringTag = n2 >= 0 ? kString.getTag(n2, true) : null;
        if (kStringTag != null) {
            if (!(kStringTag instanceof IKStringHTMLHyperlink)) {
                if (this.a() || kStringTag.getSourcePosition() != n2) return false;
                if (!bl) return true;
                kStringTag = null;
            } else {
                iKStringHTMLHyperlink = (IKStringHTMLHyperlink)kStringTag;
                n3 = iKStringHTMLHyperlink.getSourcePosition();
                n4 = iKStringHTMLHyperlink.getSourceEndPosition();
                stringArray[0] = kStringTag.getAttribute("title");
                stringArray[1] = kStringTag.getType().typeString;
                stringArray[2] = kStringTag.getReference();
                stringArray[3] = kStringTag.getAttribute("target");
                this.a = true;
            }
        }
        if (!bl) return true;
        this.a(n3, n4);
        int n5 = new HyperlinkDialog(this.a, this.a, stringArray).open();
        switch (n5) {
            case 0: {
                return false;
            }
            case 1: {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                String string4 = stringArray[2];
                String string5 = stringArray[3];
                if (iKStringHTMLHyperlink != null) {
                    kString = kString.clone();
                    iKStringHTMLHyperlink = (IKStringHTMLHyperlink)kString.getTag(n2, true);
                    iKStringHTMLHyperlink.setReference(string4);
                    iKStringHTMLHyperlink.setAttribute("title", string2 == null || string2.isEmpty() ? null : string2);
                    iKStringHTMLHyperlink.setTarget(string5.isEmpty() ? null : string5);
                    String string6 = iKStringHTMLHyperlink.getHTMLString(new StringBuilder(), null);
                    this.a(string6, string, n3, n4);
                    return true;
                }
                String string7 = "<A type=\"" + string3 + "\" ref=\"" + HTMLUtilities.escapeTagValueString((String)string4) + "\"";
                if (string2 != null && !string2.isEmpty()) {
                    String string8 = HTMLUtilities.escapeTagValueString((String)string2);
                    string7 = string7 + " title=\"" + string8 + "\">" + string8 + "</a>";
                } else {
                    string7 = string7 + ">TEXT</a>";
                }
                this.a(string7, string, n3, n4);
                return true;
            }
            case 2: {
                this.a("", string, n3, n4);
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean c(KString kString, boolean bl) {
        KStringTag kStringTag;
        if (kString == null || !kString.isHTML() || !this.a.booleanValue()) {
            return false;
        }
        String string = this.a();
        if (string == null) {
            return false;
        }
        String string2 = null;
        int n2 = this.a();
        KStringHTMLImageTag kStringHTMLImageTag = null;
        KStringTag kStringTag2 = kStringTag = n2 >= 0 ? kString.getTag(n2, true) : null;
        if (kStringTag != null) {
            if (!(kStringTag instanceof KStringHTMLImageTag)) {
                if (this.a() || kStringTag.getSourcePosition() != n2) return false;
                if (!bl) return true;
                kStringTag = null;
            } else {
                kStringHTMLImageTag = (KStringHTMLImageTag)kStringTag;
                string2 = kStringHTMLImageTag.getReference();
                this.a = true;
            }
        }
        if (!bl) return true;
        int n3 = n2;
        int n4 = n2;
        if (kStringHTMLImageTag != null) {
            n3 = kStringHTMLImageTag.getSourcePosition();
            n4 = kStringHTMLImageTag.getSourceEndPosition();
        }
        this.a(n3, n4);
        string2 = new SelectPropDialog(this.a, "Select Single Image Definition", ApplicationUI.getInstance().imageSingleImage, this.a, null, new ImageDefinitionFilter(true, false, true), ImageReferencePropEditor.CLASSES, string2, 6).open();
        if (string2 == null) return true;
        if (kStringHTMLImageTag != null) {
            kString = kString.clone();
            kStringHTMLImageTag = (KStringHTMLImageTag)kString.getTag(n2, true);
            kStringHTMLImageTag.setReference(string2);
            this.a(kString, kStringTag != null ? "Edit image reference" : "Insert image");
            return true;
        } else {
            this.a("<IMG src=\"" + string2 + "\">", string, n3, n4);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean a(boolean bl, KString kString, boolean bl2) {
        String string;
        int n2;
        String[] stringArray;
        Object object;
        int n3;
        KStringTag kStringTag;
        if (kString == null || !this.a.booleanValue()) {
            return false;
        }
        String string2 = this.a();
        if (string2 == null) {
            return false;
        }
        EditorVirtualSpace editorVirtualSpace = null;
        String string3 = null;
        int n4 = this.a();
        IKStringTextTag iKStringTextTag = null;
        KStringTag kStringTag2 = kStringTag = n4 >= 0 ? kString.getTag(n4, true) : null;
        if (kStringTag != null) {
            if (!(kStringTag instanceof IKStringTextTag)) {
                if (this.a() || kStringTag.getSourcePosition() != n4) return false;
                if (!bl2) return true;
                kStringTag = null;
            } else {
                iKStringTextTag = (IKStringTextTag)kStringTag;
                if (bl) {
                    if (iKStringTextTag.getType() != KStringTag.Type.TEXT_TABLE) {
                        return false;
                    }
                } else {
                    if (iKStringTextTag.getType() != KStringTag.Type.VIRTUAL_SPACE) {
                        return false;
                    }
                    if (this.a == null) {
                        return false;
                    }
                    editorVirtualSpace = (EditorVirtualSpace)this.a.getVirtualSpace();
                }
                string3 = iKStringTextTag.getReference();
                this.a = true;
            }
        }
        if (kStringTag == null) {
            if (bl) {
                if (this.a != null) {
                    GProp[] gPropArray = this.a.getProps();
                    int n5 = gPropArray.length;
                    n3 = 0;
                    while (n3 < n5) {
                        GProp gProp = gPropArray[n3];
                        if (gProp instanceof KStringProp) {
                            string3 = gProp.getReferencePropName();
                            break;
                        }
                        ++n3;
                    }
                }
            } else {
                if (this.a == null) {
                    return false;
                }
                editorVirtualSpace = (EditorVirtualSpace)this.a.getVirtualSpace();
                if (editorVirtualSpace == null) {
                    if (!bl2) {
                        return true;
                    }
                    editorVirtualSpace = VSHelper.getVirtualSpace(this.a, this.a, this.a, this.a);
                    if (editorVirtualSpace == null) {
                        return false;
                    }
                }
            }
        }
        if (!bl2) return true;
        int n6 = n4;
        n3 = n4;
        if (iKStringTextTag != null) {
            n6 = iKStringTextTag.getSourcePosition();
            n3 = iKStringTextTag.getSourceEndPosition();
        }
        this.a(n6, n3);
        String string4 = "";
        if (bl) {
            object = "tt";
            String string5 = "IZ type=\"tt\"";
            stringArray = new String[]{string3};
            n2 = new InsertTextIDDialog(this.a, this.a, stringArray).open();
        } else {
            object = "vs";
            String string6 = "IZ type=\"VS\"";
            String string7 = string = kStringTag != null ? kStringTag.getAttribute("display") : null;
            if (string != null) {
                string = HTMLUtilities.replaceCharacterEntities((String)string);
            }
            stringArray = new String[]{string3, string};
            n2 = new InsertTextVSDialog(this.a, editorVirtualSpace, stringArray).open();
            string4 = stringArray[1];
            string4 = string4 == null || string4.isEmpty() ? "" : " display=\"" + HTMLUtilities.escapeTagValueString((String)string4) + "\"";
        }
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                void var13_13;
                string3 = stringArray[0];
                if (iKStringTextTag != null) {
                    kString = kString.clone();
                    iKStringTextTag = (IKStringTextTag)kString.getTag(n4, true);
                    iKStringTextTag.setReference(string3);
                    if (stringArray.length == 2) {
                        string = stringArray[1];
                        iKStringTextTag.setAttribute("display", string == null || string.isEmpty() ? null : string);
                    }
                    this.a(kString, kStringTag != null ? "Edit text tag reference" : "Insert text tag");
                    return true;
                }
                object = kString.isHTML() ? "<" + (String)var13_13 + " ref=\"" + string3 + "\"" + string4 + ">" : "{" + (String)object + "=\"" + string3 + "\"" + string4 + "}";
                this.a((String)object, string2, n6, n3);
                return true;
            }
            case 2: {
                this.a("", string2, n6, n3);
            }
        }
        return true;
    }
}

