/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.quickfix.fixer;

import com.iizigo.Activator;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ProjectManager;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.quickfix.QuickFixAdapter;
import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.PropCnr;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class RecoverModuleSettings
extends QuickFixAdapter {
    public static final String ID = "RecoverModuleSettings";

    @Override
    public void run(IMarker iMarker) {
        IProject iProject = iMarker.getResource().getProject();
        ModuleModel moduleModel = ProjectManager.getInstance().getModuleModel(iProject);
        if (moduleModel == null) {
            Activator.messageBox("Recover Module project settings file", "The project is not of IIZI Module Nature, cannot proceed.", 33);
        } else {
            Shell shell = Activator.getSomeShell();
            try {
                FilePropCnr filePropCnr = (FilePropCnr)moduleModel.getRootContainer().getProp(Atom.SETTINGS);
                if (filePropCnr == null) {
                    throw new Exception("Cannot find module settings property container in project.");
                }
                IFile iFile = iProject.getFile(".iiziModuleProject");
                CreateFileOperation createFileOperation = new CreateFileOperation(iFile, null, Activator.createInputStream((PropCnr)filePropCnr), "Recover Module project settings file");
                try {
                    ResourcesPlugin.getWorkspace().run(iProgressMonitor -> {
                        try {
                            IStatus iStatus = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)createFileOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)shell));
                            if (!iStatus.isOK()) {
                                ILog.SEVERE(this.getClass(), (String)"Recover Module project settings file", (Object)iStatus);
                                throw new CoreException(iStatus);
                            }
                        }
                        catch (ExecutionException executionException) {
                            ILog.SEVERE(this.getClass(), (String)"Recover Module project settings file", (Throwable)executionException);
                            if (executionException.getCause() instanceof CoreException) {
                                throw (CoreException)executionException.getCause();
                            }
                            throw new CoreException((IStatus)new Status(4, "com.iizigo", executionException.getMessage(), (Throwable)executionException));
                        }
                    }, null, 1, null);
                    Activator.messageBox("Recover Module project settings file", "IIZI Module project file has successfully been recovered.", 34);
                }
                catch (CoreException coreException) {
                    ErrorDialog.openError((Shell)shell, (String)"Recover Module project settings file", (String)coreException.getMessage(), (IStatus)coreException.getStatus());
                }
            }
            catch (Exception exception) {
                Activator.messageBox("Recover Module project settings file", "Failed recovering the IIZI Module project file.\n\nError: " + exception.getMessage(), 33);
            }
        }
    }

    @Override
    public String getLabel() {
        return "Recover Module project settings file";
    }

    @Override
    public String getDescription() {
        return "Recovers the module settings file if accidentally removed. The contents of the file is currently in memory and can therefore be written to a new file.";
    }
}

