/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizix.prop.GUnit;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.Text;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TransformValidator {
    public static final String[] ANGLE_UNITS = new String[]{"deg", "grad", "rad", "turn"};
    private static final Object[] a = new Object[]{"matrix", 6, 0, "translate", 2, 1, "translateX", 1, 1, "translateY", 1, 1, "scale", 2, 0, "scaleX", 1, 0, "scaleY", 1, 0, "rotate", 1, 2, "skew", 2, 2, "skewX", 1, 2, "skewY", 1, 2};
    public final String input;
    public String function;
    public final ArrayList<Object> values = new ArrayList();
    public String error;
    private boolean a;

    public TransformValidator(String string) {
        this.input = string;
        if (string == null) {
            return;
        }
        string = string.trim();
        Object object = null;
        int n2 = string.indexOf(40);
        if (n2 < 0) {
            object = "Missing transform function parenthesis for parameters";
        } else if (!string.endsWith(")")) {
            object = "Missing end of function parameter list parenthesis";
        } else {
            this.function = string.substring(0, n2).toLowerCase();
            int n3 = 0;
            while (true) {
                if (n3 >= a.length) {
                    this.a(null, "Unknown transform function \"" + this.function + "\"");
                    return;
                }
                if (this.function.equalsIgnoreCase((String)a[n3])) break;
                n3 += 3;
            }
            int n4 = (Integer)a[++n3];
            int n5 = (Integer)a[++n3];
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2 + 1, string.length() - 1), ",");
            if (stringTokenizer.countTokens() != n4) {
                object = "Invalid parameter count, should be " + n4;
            } else {
                int n6 = 1;
                while (n6 <= n4) {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = null;
                    if (string2.isEmpty()) {
                        string3 = "Parameter empty";
                    } else {
                        try {
                            switch (n5) {
                                case 0: {
                                    this.values.add(Double.valueOf(string2));
                                    break;
                                }
                                case 1: {
                                    GUnit gUnit = GUnit.createGUnit((String)string2, (String[])new String[0]);
                                    int n7 = gUnit.getType();
                                    if (n7 == 5) {
                                        throw new Exception("Dialog units cannot be used");
                                    }
                                    if (n7 == 126) {
                                        throw new Exception("Formula in parameter for unit is not allowed");
                                    }
                                    this.values.add(gUnit);
                                    break;
                                }
                                default: {
                                    this.values.add(Angle.parseAngle(string2));
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            string3 = exception.getMessage();
                        }
                    }
                    if (string3 != null) {
                        this.a("Parameter " + n6, string3);
                    }
                    ++n6;
                }
            }
        }
        if (object != null) {
            this.a(null, (String)object);
        }
    }

    private void a(String string, String string2) {
        if (this.error == null) {
            this.a = true;
            this.error = string != null ? string + ": " + string2 : string2;
        } else {
            if (this.a) {
                this.error = "Multiple errors:\n - " + this.error.replace(": ", ":\t");
                this.a = false;
            }
            this.error = String.valueOf(this.error) + "\n - " + (String)(string != null ? string + "\t" + string2 : string2);
        }
    }

    public static String shortDouble(double d2) {
        long l2 = (long)d2;
        return (double)l2 == d2 ? Long.toString(l2) : Double.toString(d2);
    }

    public String getCSSValue() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(this.function).append('(');
        for (Object object : this.values) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            if (object instanceof GUnit) {
                GUnit gUnit = (GUnit)object;
                stringBuilder.append(gUnit.getCSSValue());
                continue;
            }
            if (object instanceof Angle) {
                stringBuilder.append(object.toString());
                continue;
            }
            stringBuilder.append(TransformValidator.shortDouble((Double)object));
        }
        return stringBuilder.append(')').toString();
    }

    public void setEntryFields(Text ... textArray) {
        int n2 = 0;
        Text[] textArray2 = textArray;
        int n3 = textArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string;
            Object object;
            Text text = textArray2[n4];
            if (this.values.size() == n2) break;
            if ((object = this.values.get(n2++)) instanceof GUnit) {
                GUnit gUnit = (GUnit)object;
                string = gUnit.getCSSValue();
            } else {
                string = object instanceof Angle ? object.toString() : TransformValidator.shortDouble((Double)object);
            }
            text.setText(string);
            ++n4;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class Angle {
        double a;
        int a;

        public static Angle parseAngle(String string) throws Exception {
            String string2;
            try {
                double d2 = Double.parseDouble(string);
                if (d2 == 0.0) {
                    Angle angle = new Angle();
                    angle.a = d2;
                    angle.a = 0;
                    return angle;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string = string.toLowerCase();
            int n2 = -1;
            do {
                if (++n2 != ANGLE_UNITS.length) continue;
                throw new Exception("Invalid Angle unit, must be deg, grad, rad or turn");
            } while (!string.endsWith(string2 = ANGLE_UNITS[n2]));
            string = string.substring(0, string.length() - string2.length()).trim();
            try {
                double d3 = Double.parseDouble(string);
                Angle angle = new Angle();
                angle.a = d3;
                angle.a = n2;
                return angle;
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Invalid Angle value \"" + string + "\"");
            }
        }

        public String toString() {
            Object object = TransformValidator.shortDouble(this.a);
            if (this.a != 0.0) {
                object = (String)object + ANGLE_UNITS[this.a];
            }
            return object;
        }
    }
}

