/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.IPropertyEditorController;
import com.iizigo.prop.PropertyEditorInfo;
import com.iizigo.prop.editor.IEntryValidator;
import com.iizix.prop.PropCnr;

public class NumberRange
implements IEntryValidator {
    @Override
    public String validate(IPropertyEditorController iPropertyEditorController, PropertyEditorInfo propertyEditorInfo, PropCnr[] propCnrArray, String string, String[] stringArray) {
        double[] dArray;
        try {
            dArray = this.a(stringArray);
        }
        catch (Exception exception) {
            return "NumberRange: " + String.valueOf(exception);
        }
        try {
            double d2 = Double.parseDouble(string);
            if (d2 < dArray[0]) {
                return "Minimum value is " + dArray[0];
            }
            if (d2 > dArray[1]) {
                return "Maximum value is " + dArray[1];
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid number";
        }
    }

    private double[] a(String[] stringArray) {
        double[] dArray = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        if (stringArray.length > 0) {
            String string = stringArray[0];
            int n2 = string.indexOf(58);
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid range (missing \":\"): " + string);
            }
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            if (string2.isEmpty() && string3.isEmpty()) {
                throw new IllegalArgumentException("Invalid range, no arguments: " + string);
            }
            if (!string2.isEmpty()) {
                dArray[0] = Double.parseDouble(string2);
            }
            if (!string3.isEmpty()) {
                dArray[1] = Double.parseDouble(string3);
            }
        }
        return dArray;
    }

    @Override
    public String getDescription(IPropertyEditorController iPropertyEditorController, PropertyEditorInfo propertyEditorInfo, PropCnr[] propCnrArray, String[] stringArray) {
        String string;
        try {
            double[] dArray = this.a(stringArray);
            if (dArray[0] == Double.NEGATIVE_INFINITY) {
                return "a number with a maximum of " + dArray[1];
            }
            if (dArray[1] == Double.POSITIVE_INFINITY) {
                return "a number with a minimum of " + dArray[0];
            }
            string = "a number between " + dArray[0] + " and " + dArray[1];
        }
        catch (Exception exception) {
            string = "Range error: " + String.valueOf(exception);
        }
        return string;
    }
}

