/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizix.prop.GColor;
import com.iizix.prop.GUnit;
import com.iizix.prop.GUnitException;
import java.text.ParseException;
import java.util.StringTokenizer;

public class BoxShadowValidator {
    public final String input;
    public boolean inset;
    public GUnit horz;
    public GUnit vert;
    public GUnit blur;
    public GUnit spread;
    public GColor color;
    public String error;
    private boolean a;
    public boolean tooManyParams;

    public BoxShadowValidator(String string) {
        this.input = string;
        if (string == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.isEmpty()) continue;
            if (string2.equalsIgnoreCase("inset")) {
                this.inset = true;
                continue;
            }
            if (!bl) {
                bl = true;
                try {
                    this.horz = GUnit.createGUnit((String)string2, (String[])new String[0]);
                }
                catch (GUnitException gUnitException) {
                    this.a("Horizontal offset", gUnitException.getLocalizedMessage());
                }
                continue;
            }
            if (!bl2) {
                bl2 = true;
                try {
                    this.vert = GUnit.createGUnit((String)string2, (String[])new String[0]);
                }
                catch (GUnitException gUnitException) {
                    this.a("Vertical offset", gUnitException.getLocalizedMessage());
                }
                continue;
            }
            if (bl5) {
                this.tooManyParams = true;
                break;
            }
            char c2 = Character.toUpperCase(string2.charAt(0));
            if (c2 == '#' || c2 == 'R') {
                bl5 = true;
                try {
                    this.color = GColor.parseGColor((String)string2);
                }
                catch (ParseException parseException) {
                    this.a("Color", parseException.getLocalizedMessage());
                }
                continue;
            }
            if (!bl3) {
                bl3 = true;
                try {
                    this.blur = GUnit.createGUnit((String)string2, (String[])new String[0]);
                }
                catch (GUnitException gUnitException) {
                    this.a("Blur radius", gUnitException.getLocalizedMessage());
                }
                continue;
            }
            if (!bl4) {
                bl4 = true;
                try {
                    this.spread = GUnit.createGUnit((String)string2, (String[])new String[0]);
                }
                catch (GUnitException gUnitException) {
                    this.a("Spread radius", gUnitException.getLocalizedMessage());
                }
                continue;
            }
            this.a("Color", "Expected color after Spread radius");
            break;
        }
    }

    private void a(String string, String string2) {
        if (this.error == null) {
            this.a = true;
            this.error = string + ":\t" + string2;
        } else {
            if (this.a) {
                this.error = "Multiple errors:\n - " + this.error;
                this.a = false;
            }
            this.error = String.valueOf(this.error) + "\n - " + string + "\t" + string2;
        }
    }

    public String getCSSValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.inset) {
            stringBuilder.append("inset ");
        }
        if (this.horz != null) {
            stringBuilder.append(this.horz);
            if (this.vert != null) {
                stringBuilder.append(' ').append(this.vert);
                if (this.blur != null) {
                    stringBuilder.append(' ').append(this.blur);
                    if (this.spread != null) {
                        stringBuilder.append(' ').append(this.spread);
                    }
                }
                if (this.color != null) {
                    stringBuilder.append(' ').append(this.color.getCSSValue());
                }
            }
        }
        return stringBuilder.toString();
    }
}

