/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.project;

import com.iizigo.project.IFolderFileChangeListener;
import com.iizigo.project.ProjectManager;
import com.iizigo.project.refactor.RefactoringOperation;
import com.iizix.ILog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FileChangesCollection
implements IFolderFileChangeListener,
IResourceDeltaVisitor,
IResourceVisitor {
    public final String description;
    private IFolder[] a;
    protected final ProjectManager projectManager;
    protected IProgressMonitor monitor;
    private MultiStatus a;

    public FileChangesCollection(String string, ProjectManager projectManager) {
        this(string, new IFolder[0], projectManager);
    }

    public FileChangesCollection(String string, IFolder[] iFolderArray, ProjectManager projectManager) {
        this.description = string;
        this.a = iFolderArray;
        this.projectManager = projectManager;
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    public final void setNewFolders(IFolder[] iFolderArray) {
        this.a = iFolderArray;
        this.onNewFolders(iFolderArray);
    }

    public void onNewFolders(IFolder[] iFolderArray) {
    }

    public IFolder[] getFolders() {
        return this.a;
    }

    public final boolean isProcessed(IResource iResource) {
        IFolder[] iFolderArray = this.a;
        int n2 = this.a.length;
        int n3 = 0;
        while (n3 < n2) {
            IFolder iFolder = iFolderArray[n3];
            if (iFolder.equals((Object)iResource)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public final synchronized void process(IResourceDelta iResourceDelta) throws CoreException {
        block3: {
            this.a = new MultiStatus("com.iizigo", 1, this.description, null);
            try {
                iResourceDelta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {
                ILog.SEVERE(this.getClass(), (String)"process(delta) failed", (Throwable)coreException);
                MultiStatus multiStatus = this.a;
                if (multiStatus == null) break block3;
                multiStatus.merge((IStatus)new Status(4, "com.iizigo", "Visit failed: " + this.description, (Throwable)coreException));
            }
        }
        MultiStatus multiStatus = this.a;
        if (multiStatus != null && !multiStatus.isOK()) {
            throw new CoreException((IStatus)multiStatus);
        }
    }

    public void setMultiStatus(MultiStatus multiStatus) {
        this.a = multiStatus;
    }

    public MultiStatus getMultiStatus() {
        return this.a;
    }

    public final boolean visit(IResource iResource) throws CoreException {
        return this.a(iResource, 1, null);
    }

    public final boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        return this.a(iResourceDelta.getResource(), iResourceDelta.getKind(), iResourceDelta);
    }

    private boolean a(IResource iResource, int n2, IResourceDelta iResourceDelta) throws CoreException {
        Exception exception;
        block38: {
            block37: {
                if (this.monitor != null && this.monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                exception = null;
                if (!(iResource instanceof IFile)) break block37;
                IFile iFile = (IFile)iResource;
                if (!this.isFileProcessed(iFile)) break block38;
                switch (n2) {
                    case 4: {
                        try {
                            this.onFileChanged(iFile, iResourceDelta.getFlags());
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                        }
                        if (this.projectManager != null) {
                            this.projectManager.onWorkspaceChange(RefactoringOperation.FILE_CHANGED);
                            break;
                        }
                        break block38;
                    }
                    case 1: {
                        IPath iPath = this.a(iResourceDelta);
                        if (iPath != null) {
                            try {
                                this.onFileMoved(iFile, iResource.getWorkspace().getRoot().getFile(iPath));
                            }
                            catch (Exception exception3) {
                                exception = exception3;
                            }
                            if (this.projectManager != null) {
                                this.projectManager.onWorkspaceChange(RefactoringOperation.FILE_RENAMED);
                                break;
                            }
                        } else {
                            try {
                                this.onFileAdded(iFile);
                            }
                            catch (Exception exception4) {
                                exception = exception4;
                            }
                            if (this.projectManager != null) {
                                this.projectManager.onWorkspaceChange(RefactoringOperation.FILE_ADDED);
                                break;
                            }
                        }
                        break block38;
                    }
                    case 2: {
                        if (this.a(iResourceDelta) != null) break block38;
                        try {
                            this.onFileRemoved(iFile);
                        }
                        catch (Exception exception5) {
                            exception = exception5;
                        }
                        if (this.projectManager == null) break block38;
                        this.projectManager.onWorkspaceChange(RefactoringOperation.FILE_REMOVED);
                    }
                    default: {
                        break;
                    }
                    {
                        break block38;
                    }
                }
                break block38;
            }
            if (iResource instanceof IFolder) {
                IFolder iFolder = (IFolder)iResource;
                switch (n2) {
                    case 1: {
                        IPath iPath = this.a(iResourceDelta);
                        if (iPath != null) {
                            try {
                                this.onFolderMoved(iFolder, iResource.getWorkspace().getRoot().getFolder(iPath));
                            }
                            catch (Exception exception6) {
                                exception = exception6;
                            }
                            if (this.projectManager == null) break;
                            this.projectManager.onWorkspaceChange(RefactoringOperation.FOLDER_RENAMED);
                            break;
                        }
                        try {
                            this.onFolderAdded(iFolder);
                        }
                        catch (Exception exception7) {
                            exception = exception7;
                        }
                        if (this.projectManager == null) break;
                        this.projectManager.onWorkspaceChange(RefactoringOperation.FOLDER_ADDED);
                        break;
                    }
                    case 2: {
                        if (this.a(iResourceDelta) != null) break;
                        try {
                            this.onFolderRemoved(iFolder);
                        }
                        catch (Exception exception8) {
                            exception = exception8;
                        }
                        if (this.projectManager == null) break;
                        this.projectManager.onWorkspaceChange(RefactoringOperation.FOLDER_REMOVED);
                    }
                }
            }
        }
        if (exception != null) {
            String string = "Visit resource '" + String.valueOf(iResource.getFullPath()) + "' failed";
            ILog.SEVERE(this.getClass(), (String)string, (Throwable)exception);
            MultiStatus multiStatus = this.a;
            if (multiStatus != null) {
                multiStatus.merge((IStatus)new Status(4, "com.iizigo", string, (Throwable)exception));
            }
        }
        return true;
    }

    private IPath a(IResourceDelta iResourceDelta) {
        if (iResourceDelta != null) {
            IPath iPath = iResourceDelta.getMovedFromPath();
            if (iPath == null && (iPath = iResourceDelta.getMovedToPath()) == null) {
                return null;
            }
            IFolder[] iFolderArray = this.a;
            int n2 = this.a.length;
            int n3 = 0;
            while (n3 < n2) {
                IFolder iFolder = iFolderArray[n3];
                if (iFolder.getFullPath().isPrefixOf(iPath)) {
                    return iPath;
                }
                ++n3;
            }
        }
        return null;
    }

    protected boolean isFileProcessed(IFile iFile) {
        return false;
    }

    @Override
    public void onFileAdded(IFile iFile) throws CoreException {
    }

    @Override
    public void onFileMoved(IFile iFile, IFile iFile2) throws CoreException {
    }

    @Override
    public void onFileChanged(IFile iFile, int n2) throws CoreException {
    }

    @Override
    public void onFileRemoved(IFile iFile) throws CoreException {
    }

    @Override
    public void onFolderAdded(IFolder iFolder) throws CoreException {
    }

    @Override
    public void onFolderMoved(IFolder iFolder, IFolder iFolder2) throws CoreException {
    }

    @Override
    public void onFolderRemoved(IFolder iFolder) throws CoreException {
    }
}

