/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.panel.prop.mlist;

import com.iizigo.ApplicationUI;
import com.iizigo.link.ILinkOperation;
import com.iizigo.link.LinkData;
import com.iizigo.panel.prop.IEUIComp;
import com.iizigo.panel.prop.IEUIComponentCreationType;
import com.iizigo.panel.prop.IInitializeSampleData;
import com.iizigo.panel.prop.UICompDesignerProp;
import com.iizigo.panel.prop.mlist.EMLGroup;
import com.iizigo.panel.prop.mlist.EMLItemProp0;
import com.iizigo.prop.IDynamicPropertyEditorList;
import com.iizigo.prop.PropertyEditorInfo;
import com.iizigo.prop.editor.dialog.SelectPropViewerFilter;
import com.iizigo.style.prop.EditorStyles;
import com.iizigo.style.prop.EditorStyles0;
import com.iizigo.vs.prop.EditorVSFocusReference;
import com.iizix.Value;
import com.iizix.api.AnnotationType;
import com.iizix.event.GEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.BoolProp;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.KStringProp;
import com.iizix.prop.NumberProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.Styles;
import com.iizix.prop.ValueProp;
import com.iizix.prop.ui.ImagePreview;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.datetime.UIDateTimeDataType;
import com.iizix.prop.ui.datetime.UIDateTimeType;
import com.iizix.prop.ui.mlist.MLItemProp;
import com.iizix.prop.ui.mlist.MLItemType;
import com.iizix.prop.vs.VSField;
import com.iizix.text.KString;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EMLItemProp
extends MLItemProp
implements IEUIComp,
IEUIComponentCreationType,
IInitializeSampleData,
IDynamicPropertyEditorList {
    private UICompDesignerProp a = new UICompDesignerProp((UIComp)this);
    private static final Class<?>[] a;
    private static final Class<?>[] b;
    private static final AnnotationType[][] a;
    private static final AnnotationType[] a;

    static {
        a = new Class[]{EMLGroup.class};
        b = new Class[]{EMLGroup.class};
        a = new AnnotationType[EMLItemProp0.b.length][];
        a = new AnnotationType[0];
    }

    public EMLItemProp() {
    }

    public EMLItemProp(Atom atom) {
        super(atom);
    }

    public EMLItemProp(MLItemType mLItemType) {
        this();
        this.setInt(Atom.TYPE, mLItemType.type);
    }

    @Override
    public String getCreationTypeName() {
        return this.getType().name();
    }

    @Override
    public UICompDesignerProp getDesigner() {
        return this.a;
    }

    protected Styles createStyles() {
        return new EditorStyles(Atom.STYLES);
    }

    public EMLItemProp clone() {
        EMLItemProp eMLItemProp = (EMLItemProp)super.clone();
        eMLItemProp.a = new UICompDesignerProp((UIComp)eMLItemProp);
        return eMLItemProp;
    }

    @Override
    public boolean hasEditedPropertyListChanged(GEvent gEvent) {
        GProp gProp = gEvent.getEventTarget();
        return gProp.getParent() == this && Atom.TYPE.equals((Object)gProp.getPropAtom());
    }

    @Override
    public ImagePreview getImagePreview() {
        return null;
    }

    @Override
    public Image getCNImage(boolean bl) {
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        Image image = applicationUI.imageMUISimpleListItem;
        switch (this.getType()) {
            case SIMPLE: {
                break;
            }
            case CHECKBOX: {
                image = applicationUI.imageMUICheckBox;
                break;
            }
            case SWITCH: {
                image = applicationUI.imageMUISwitch;
                break;
            }
            case RADIO_BUTTON: {
                image = applicationUI.imageMUIRadioButton;
                break;
            }
            case BUTTON_SET: {
                image = applicationUI.imageMUIButton;
                break;
            }
            case TEXT_ENTRY: {
                image = applicationUI.imageUIText;
                break;
            }
            case NUMERIC_SPINNER: {
                image = applicationUI.imageUISpinner;
                break;
            }
            case DATE_TIME: {
                image = applicationUI.imageUISpinner;
                break;
            }
            case CALENDAR: {
                image = applicationUI.imageUICalendar;
                break;
            }
            case COMBOBOX: {
                image = applicationUI.imageUIComboBox;
                break;
            }
            case SLIDER: {
                image = applicationUI.imageMUISlider;
            }
        }
        return image;
    }

    @Override
    public String getCNDescriptionType() {
        String string = "Simple list item";
        switch (this.getType()) {
            case SIMPLE: {
                break;
            }
            case CHECKBOX: {
                string = "Checkbox list item";
                break;
            }
            case SWITCH: {
                string = "Switch list item";
                break;
            }
            case RADIO_BUTTON: {
                string = "Radio button list item";
                break;
            }
            case BUTTON_SET: {
                string = "Button set list item";
                break;
            }
            case TEXT_ENTRY: {
                string = "Text field list item";
                break;
            }
            case NUMERIC_SPINNER: {
                string = "Spinner list item";
                break;
            }
            case DATE_TIME: {
                string = "DateTime list item";
                break;
            }
            case CALENDAR: {
                string = "Calendar list item";
                break;
            }
            case COMBOBOX: {
                string = "Combobox list item";
                break;
            }
            case SLIDER: {
                string = "Slider list item";
            }
        }
        return string;
    }

    @Override
    public void initializeSampleData(int n2) {
        GProp gProp = this.getProp(Atom.TEXT);
        if (gProp != null && !(gProp instanceof KStringProp)) {
            this.removeProp2((IGProp)gProp);
            gProp = null;
        }
        if (gProp == null) {
            this.setPropValue(Atom.TEXT, KString.newPlainKString((String)("New " + this.getDesigner().getCNDescriptionType())), KStringProp.class);
        }
    }

    @Override
    public Class<?>[] getPossibleContainerParents() {
        return a;
    }

    @Override
    public String getStylesName(EditorStyles editorStyles) {
        return "List item styles";
    }

    @Override
    public String[] getSupportedStyles(EditorStyles editorStyles) {
        return EditorStyles0.NO_SUPPORTED_STYLES;
    }

    public Class<?>[] getExtendsPossibleClasses() {
        return b;
    }

    @Override
    public String getSelectPropDialogTitle() {
        return "Select Extends List Item";
    }

    @Override
    public ViewerFilter getSelectPropViewerFilter() {
        return new SelectPropViewerFilter(b);
    }

    @Override
    public AnnotationType[] getMethodReferenceAnnotationTypes() {
        int n2 = this.getInt(Atom.TYPE, 0);
        if (n2 < 0 && n2 >= EMLItemProp0.b.length) {
            return a;
        }
        if (a[n2] == null) {
            ArrayList<AnnotationType> arrayList = new ArrayList<AnnotationType>();
            for (PropertyEditorInfo propertyEditorInfo : EMLItemProp0.b[n2].getPropertyEditorInfos((PropCnr)this)) {
                AnnotationType annotationType;
                if (propertyEditorInfo.atom == null || !propertyEditorInfo.atom.getAtomName().startsWith("$On") || (annotationType = AnnotationType.fromEventAtom((Atom)propertyEditorInfo.atom)) == null) continue;
                arrayList.add(annotationType);
            }
            EMLItemProp.a[n2] = arrayList.toArray(new AnnotationType[arrayList.size()]);
        }
        return a[n2];
    }

    @Override
    public IStatus isLinkCapable(LinkData linkData) {
        return this.isUIComponentLinkCapable(linkData);
    }

    @Override
    public Collection<ILinkOperation> getLinkOperations(LinkData linkData) {
        return this.getUIComponentLinkOperations(linkData);
    }

    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        switch (this.getType()) {
            case SIMPLE: {
                break;
            }
            case CHECKBOX: 
            case SWITCH: {
                if (this.getString(Atom.VSFIELD) == null) break;
                ValueProp valueProp = (ValueProp)this.getProp("checkedValue");
                ValueProp valueProp2 = (ValueProp)this.getProp("uncheckedValue");
                if (valueProp != null && valueProp2 != null) {
                    Value.Type type = valueProp.getValueType();
                    Value.Type type2 = valueProp2.getValueType();
                    if (type == null || type2 == null || type == type2) break;
                    String string = "Checked and unchecked values of different type: " + type.name() + " != " + type2.name();
                    propVerification.add(new PropVerificationError("check.valueType", PropVerificationError.Severity.WARNING, "Value type", (GProp)valueProp, string, new String[0]));
                    propVerification.add(new PropVerificationError("uncheck.valueType", PropVerificationError.Severity.WARNING, "Value type", (GProp)valueProp2, string, new String[0]));
                    break;
                }
                if (valueProp == null) {
                    propVerification.add(new PropVerificationError((PropCnr)this, "checkedValue", PropVerificationError.Severity.WARNING, "Checked value", "Missing Checked value", new String[0]));
                }
                if (valueProp2 != null) break;
                propVerification.add(new PropVerificationError((PropCnr)this, "uncheckedValue", PropVerificationError.Severity.WARNING, "Unchecked value", "Missing Unchecked value", new String[0]));
                break;
            }
            case RADIO_BUTTON: {
                ValueProp valueProp;
                if (this.getString(Atom.VSFIELD) == null || (valueProp = (ValueProp)this.getProp("selValue")) != null) break;
                propVerification.add(new PropVerificationError((PropCnr)this, "selValue", PropVerificationError.Severity.WARNING, "Selected value", "Missing Selected value", new String[0]));
                break;
            }
            case BUTTON_SET: {
                break;
            }
            case TEXT_ENTRY: {
                break;
            }
            case NUMERIC_SPINNER: {
                NumberProp numberProp;
                double d2;
                double d3;
                NumberProp numberProp2 = (NumberProp)this.getProp("max", NumberProp.class);
                NumberProp numberProp3 = (NumberProp)this.getProp("min", NumberProp.class);
                double d4 = numberProp2 != null ? numberProp2.getDouble(100.0) : 100.0;
                double d5 = d3 = numberProp3 != null ? numberProp3.getDouble(0.0) : 0.0;
                if (d3 >= d4) {
                    if (numberProp2 != null) {
                        propVerification.add(new PropVerificationError("range", PropVerificationError.Severity.WARNING, "Maximum value", (GProp)numberProp2, "Maximum value must be larger than minimum value (" + String.valueOf(numberProp3) + ")", new String[]{"DeleteProperty"}));
                    } else if (numberProp3 != null) {
                        propVerification.add(new PropVerificationError("range", PropVerificationError.Severity.WARNING, "Minimum value", (GProp)numberProp3, "Minumum value must be smaller than maximum value (" + String.valueOf(numberProp2) + ")", new String[]{"DeleteProperty"}));
                    }
                }
                double d6 = d2 = (numberProp = (NumberProp)this.getProp("step", NumberProp.class)) != null ? numberProp.getDouble(1.0) : 1.0;
                if (d2 > d4 - d3) {
                    if (numberProp != null) {
                        propVerification.add(new PropVerificationError("step", PropVerificationError.Severity.WARNING, "Step", (GProp)numberProp, "Step larger than value span", new String[]{"DeleteProperty"}));
                    } else {
                        propVerification.add(new PropVerificationError((PropCnr)this, "step", PropVerificationError.Severity.WARNING, "Step", "Step larger than value span", new String[0]));
                    }
                }
            }
            case COMBOBOX: {
                BoolProp boolProp = (BoolProp)this.getProp("vsfSel", BoolProp.class);
                if (boolProp != null && boolProp.getBool() && this.getProp("selColumn", BoolProp.class) == null) {
                    propVerification.add(new PropVerificationError("indexSelect", PropVerificationError.Severity.ERROR, "", (GProp)boolProp, "Index selection cannot be used on a component without VS-connected selection list", new String[0]));
                }
                VSField vSField = this.getVSField();
                BoolProp boolProp2 = (BoolProp)this.getProp("nullable", BoolProp.class);
                if (vSField == null || vSField.isNullAllowed() || boolProp2 == null || !boolProp2.getBool()) break;
                propVerification.add(new PropVerificationError("nullable", PropVerificationError.Severity.WARNING, "", (GProp)boolProp2, "The value should be required if connected to a non-nullable VS field", new String[0]));
                break;
            }
            case DATE_TIME: {
                Value.Type type;
                VSField vSField;
                BoolProp boolProp;
                BoolProp boolProp3;
                int n2 = this.getInt("dtType", 0);
                UIDateTimeType uIDateTimeType = UIDateTimeType.values()[n2 >>> 1 & 3];
                UIDateTimeDataType uIDateTimeDataType = UIDateTimeDataType.values()[n2 >>> 3];
                BoolProp boolProp4 = (BoolProp)this.getProp("useCal", BoolProp.class);
                if (boolProp4 != null && boolProp4.getBool()) {
                    if (uIDateTimeType != UIDateTimeType.Date && uIDateTimeType != UIDateTimeType.DateTime) {
                        propVerification.add(new PropVerificationError("cal", PropVerificationError.Severity.ERROR, "Use Calendar", (GProp)boolProp4, "The calendar picker can only be used for Date and DateTime types", new String[0]));
                    }
                    if ((boolProp3 = (IntProp)this.getProp("maxY", IntProp.class)) != null) {
                        propVerification.add(new PropVerificationError("maxY", PropVerificationError.Severity.WARNING, "Max year", (GProp)boolProp3, "Max year is only used for spinner selector.", new String[0]));
                    }
                    if ((boolProp3 = (IntProp)this.getProp("minY", IntProp.class)) != null) {
                        propVerification.add(new PropVerificationError("minY", PropVerificationError.Severity.WARNING, "Min year", (GProp)boolProp3, "Min year is only used for spinner selector.", new String[0]));
                    }
                }
                if ((boolProp3 = (BoolProp)this.getProp("useMS", BoolProp.class)) != null && boolProp3.getBool() && (uIDateTimeType == UIDateTimeType.ZoneId || uIDateTimeType == UIDateTimeType.Date)) {
                    propVerification.add(new PropVerificationError("ms", PropVerificationError.Severity.WARNING, "Use Milliseconds", (GProp)boolProp3, "The milliseconds time unit is ignored for ZoneId or Date Date/time type", new String[0]));
                }
                if ((boolProp = (BoolProp)this.getProp("useZone", BoolProp.class)) == null || !boolProp.getBool()) {
                    if (uIDateTimeType == UIDateTimeType.ZoneId) {
                        propVerification.add(new PropVerificationError("zone", PropVerificationError.Severity.WARNING, "Use Zone", (GProp)(boolProp != null ? boolProp : this), "The zone time unit must be used for ZoneId Date/time type", new String[0]));
                    }
                } else if (uIDateTimeType != UIDateTimeType.ZoneId && uIDateTimeDataType != UIDateTimeDataType.ZonedDateTime) {
                    propVerification.add(new PropVerificationError("zoneType", PropVerificationError.Severity.WARNING, "Use Zone", (GProp)boolProp, "The zone is not part of the Date/time data type", new String[0]));
                }
                IntProp intProp = (IntProp)this.getProp("maxY", IntProp.class);
                IntProp intProp2 = (IntProp)this.getProp("minY", IntProp.class);
                if (intProp != null || intProp2 != null) {
                    int n3;
                    int n4 = intProp != null ? intProp.getInt(2020) : 2020;
                    int n5 = n3 = intProp2 != null ? intProp2.getInt(1990) : 1990;
                    if (n4 <= n3) {
                        propVerification.add(new PropVerificationError("yearLim", PropVerificationError.Severity.WARNING, "Maximum/Minimum year", (GProp)(intProp != null ? intProp : intProp2), "The maximum year is lower or equal to the minimum year", new String[0]));
                    } else if (n4 - n3 > 200) {
                        propVerification.add(new PropVerificationError("yearRange", PropVerificationError.Severity.WARNING, "Maximum/Minimum year", (GProp)(intProp != null ? intProp : intProp2), "The max/min year range is more than 200. It will have performance impact running on small devices.", new String[0]));
                    }
                }
                if ((vSField = this.getVSField()) != null && (type = vSField.getValueType()) != null) {
                    PropVerificationError.Severity severity = PropVerificationError.Severity.ERROR;
                    Object object = null;
                    if (uIDateTimeDataType == UIDateTimeDataType.ZoneId) {
                        if (type != Value.Type.String && type != Value.Type.KString && type != Value.Type.ZonedDateTime) {
                            object = "Date-time type 'ZoneId' can only be connected to a VSField with the value types 'String', 'KString' or 'ZonedDateTime'";
                        }
                    } else if (!(uIDateTimeDataType != UIDateTimeDataType.ZonedDateTime && uIDateTimeDataType != UIDateTimeDataType.OffsetDateTime && uIDateTimeDataType != UIDateTimeDataType.OffsetTime || type != Value.Type.LocalDate && type != Value.Type.LocalTime && type != Value.Type.LocalDateTime)) {
                        object = "Date-time type '" + String.valueOf(uIDateTimeDataType) + " converted to " + String.valueOf(type) + " will result in loss of precision";
                        severity = PropVerificationError.Severity.WARNING;
                    } else if (!type.equals((Object)uIDateTimeDataType.getValueType())) {
                        if ((n2 & 1) != 0) {
                            object = "Date-time type '" + String.valueOf(uIDateTimeDataType) + "' must be used for the Value type as well as conversion is not enabled";
                        } else if (!type.canConvertTo(uIDateTimeDataType.getValueType())) {
                            object = "Date-time type '" + String.valueOf(uIDateTimeDataType) + "' cannot be converted to Value type '" + String.valueOf(type) + "'";
                        }
                    }
                    if (object != null) {
                        GProp gProp = this.getProp("dtType");
                        if (gProp != null) {
                            propVerification.add(new PropVerificationError("conv", severity, "Date-time type", gProp, (String)object, new String[0]));
                        } else {
                            propVerification.add(new PropVerificationError((PropCnr)this, Atom.TYPE, severity, "Date-time type", (String)object, new String[0]));
                        }
                    }
                }
                vSField = this.getVSField();
                BoolProp boolProp5 = (BoolProp)this.getProp("$null", BoolProp.class);
                if (vSField == null || vSField.isNullAllowed() || boolProp5 == null || !boolProp5.getBool()) break;
                propVerification.add(new PropVerificationError("nullable", PropVerificationError.Severity.WARNING, "", (GProp)boolProp5, "The value should be required if connected to a non-nullable VS field", new String[0]));
                break;
            }
            case CALENDAR: {
                break;
            }
        }
        return true;
    }

    protected void setFocusReference(String string) {
        this.setPropValue("vsFocus", string, EditorVSFocusReference.class);
    }

    @Override
    public Object[] getTransferProps() {
        return null;
    }
}

