/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.navigator;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.dnd.PropertiesTransfer;
import com.iizigo.panel.ClientSideEditor;
import com.iizigo.project.ModuleFolder;
import com.iizigo.project.ModuleModel;
import com.iizigo.prop.DesignerProp;
import com.iizix.prop.GProp;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.navigator.resources.ResourceDragAdapterAssistant;
import org.eclipse.ui.part.ResourceTransfer;

public class DragAdapterAssistant
extends ResourceDragAdapterAssistant {
    private static final Transfer[] a = new Transfer[]{PropertiesTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()};

    public Transfer[] getSupportedTransferTypes() {
        return a;
    }

    public void dragStart(DragSourceEvent dragSourceEvent, IStructuredSelection iStructuredSelection) {
        ArrayList<DesignerProp> arrayList = Activator.getSelectedProps((ISelection)iStructuredSelection);
        ModuleFolder moduleFolder = ModuleFolder.getModuleFolder(arrayList);
        if (moduleFolder == null) {
            dragSourceEvent.detail = 1;
        }
        dragSourceEvent.doit = Activator.getSelectedGProps((ISelection)iStructuredSelection).length > 0 || Activator.getSelectedResources(iStructuredSelection).length > 0;
        ClientSideEditor.setDragging((ISelection)iStructuredSelection);
    }

    public boolean setDragData(DragSourceEvent dragSourceEvent, IStructuredSelection iStructuredSelection) {
        GProp<?>[] gPropArray;
        if (PropertiesTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            int n2;
            ArrayList<DesignerProp> arrayList = Activator.getSelectedProps((ISelection)iStructuredSelection);
            ModuleFolder moduleFolder = ModuleFolder.getModuleFolder(arrayList);
            if (moduleFolder == null) {
                dragSourceEvent.detail = 1;
            }
            if ((n2 = arrayList.size()) > 0) {
                GProp[] gPropArray2 = new GProp[n2];
                int n3 = 0;
                while (n3 < n2) {
                    gPropArray2[n3] = arrayList.get(n3).getPropCnr();
                    ++n3;
                }
                dragSourceEvent.data = gPropArray2;
                dragSourceEvent.image = ApplicationUI.getInstance().imageIizi;
                return true;
            }
        } else if (ResourceTransfer.getInstance().isSupportedType(dragSourceEvent.dataType) || FileTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            if (Activator.getSelectedResources(iStructuredSelection).length > 0) {
                return super.setDragData(dragSourceEvent, iStructuredSelection);
            }
        } else if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType) && (gPropArray = Activator.getSelectedGProps((ISelection)iStructuredSelection)).length > 0) {
            Object object = "";
            GProp<?>[] gPropArray3 = gPropArray;
            int n4 = gPropArray.length;
            int n5 = 0;
            while (n5 < n4) {
                GProp<?> gProp = gPropArray3[n5];
                try {
                    String string = gProp.getReferencePropName();
                    if (!((String)object).isEmpty()) {
                        object = (String)object + "\n";
                    }
                    object = (String)object + string;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n5;
            }
            if (!((String)object).isEmpty()) {
                dragSourceEvent.detail = 1;
                dragSourceEvent.data = object;
                return true;
            }
        }
        return false;
    }

    public void dragFinished(DragSourceEvent dragSourceEvent, IStructuredSelection iStructuredSelection) {
        ClientSideEditor.setDragging(null);
        ArrayList<DesignerProp> arrayList = Activator.getSelectedProps((ISelection)iStructuredSelection);
        HashSet<IProject> hashSet = new HashSet<IProject>();
        for (DesignerProp designerProp : arrayList) {
            ModuleModel moduleModel = designerProp.getModel();
            if (moduleModel == null) continue;
            hashSet.add(moduleModel.getProject());
        }
        for (IResource iResource : hashSet) {
            try {
                iResource.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

