/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.handler;

import com.iizigo.Activator;
import com.iizigo.handler.SelectionEnabler;
import com.iizigo.java.JavaHelper;
import com.iizigo.project.AddModuleNatureWizard;
import com.iizigo.project.ModuleNature;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConfigureModuleProject
extends AbstractHandler {
    private boolean a;

    public void setEnabled(Object object) {
        if (this.a) {
            return;
        }
        this.a = true;
        this.setBaseEnabled(SelectionEnabler.get((Object)object).isNonModuleProject);
        this.a = false;
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IProject iProject = Activator.getSelectedProject();
        if (iProject != null) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)executionEvent);
            boolean bl = false;
            try {
                bl = JavaHelper.hasJavaNature(iProject);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (!bl) {
                MessageDialog.openError((Shell)shell, (String)"IIZI Module project configuration", (String)("The IIZI Module Nature cannot be added to the project \"" + iProject.getName() + "\" because the required Java Nature is not present."));
            } else {
                try {
                    if (ModuleNature.hasModuleNature(iProject)) {
                        if (iProject.isNatureEnabled("com.iizigo.modulenature")) {
                            MessageDialog.openInformation((Shell)shell, (String)"IIZI Module project configuration", (String)("The project \"" + iProject.getName() + "\" already has the IIZI Module Nature, and the nature is enabled."));
                        } else {
                            MessageDialog.openWarning((Shell)shell, (String)"IIZI Module project configuration", (String)("The project \"" + iProject.getName() + "\" already has the IIZI Module Nature, but it is not enabled for the project."));
                        }
                    } else {
                        AddModuleNatureWizard.open(shell, iProject);
                    }
                }
                catch (CoreException coreException) {
                    Activator.openError(shell, "IIZI Module project configuration", "Failed getting the project nature for project \"" + iProject.getName() + "\".", coreException);
                }
            }
        }
        return null;
    }
}

