/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.font;

import com.iizigo.project.ModuleModel;
import com.iizix.ILog;
import com.iizix.SendTransaction;
import com.iizix.comm.ITransactionSender;
import com.iizix.prop.EnvProps;
import com.iizix.prop.font.BrowserFontFormat;
import com.iizix.prop.font.FontFile;
import com.iizix.prop.font.FontFiles;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ua_parser.Client;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DesignerFontManager {
    private ModuleModel a;
    private final HashSet<String> a;
    private final ITransactionSender a = new HashSet();

    public DesignerFontManager(ModuleModel moduleModel, ITransactionSender iTransactionSender) {
        this.a = moduleModel;
        this.a = iTransactionSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installFonts(List<FontFiles> list, EnvProps envProps) {
        BrowserFontFormat browserFontFormat;
        Object object;
        if (list.isEmpty()) {
            return true;
        }
        try {
            object = envProps.getParsedUserAgent();
            browserFontFormat = BrowserFontFormat.fromParsedUserAgent((Client)object);
        }
        catch (Exception exception) {
            ILog.WARNING(this.getClass(), (String)("Failed getting parsed user agent: " + exception.getMessage()));
            browserFontFormat = BrowserFontFormat.OTHER;
        }
        object = new StringBuilder();
        SendTransaction sendTransaction = null;
        int n2 = 0;
        Object object2 = this.a;
        synchronized (object2) {
            for (FontFiles fontFiles : list) {
                Object object3;
                String string = fontFiles.getFontIdentification();
                if (!((HashSet)((Object)this.a)).add(string)) continue;
                try {
                    FontFile fontFile = fontFiles.getFontFile(browserFontFormat);
                    if (fontFile != null) {
                        SendTransaction sendTransaction2 = new SendTransaction();
                        sendTransaction2.appendByte(7);
                        fontFile.appendFontData(sendTransaction2);
                        if (sendTransaction == null) {
                            sendTransaction = sendTransaction2;
                            continue;
                        }
                        sendTransaction.append(sendTransaction2);
                        continue;
                    }
                    object3 = "file not found";
                }
                catch (Throwable throwable) {
                    object3 = "Exception " + throwable.getMessage();
                    ILog.SEVERE(this.getClass(), (String)("Failed retrieving font file with ID " + string), (Throwable)throwable);
                }
                ((HashSet)((Object)this.a)).remove(string);
                ++n2;
                ((StringBuilder)object).append("\n - " + fontFiles.getReferencePropName() + "\", font ID \"" + string + "\": " + (String)object3);
            }
        }
        if (sendTransaction != null) {
            this.a.sendTransaction(sendTransaction);
        }
        if (n2 > 0) {
            try {
                object2 = envProps.getParsedUserAgent().toString();
            }
            catch (Throwable throwable) {
                object2 = "Error " + throwable.getMessage();
            }
            ILog.WARNING(this.getClass(), (String)("Failed installing " + n2 + " font file resources requested for browser " + String.valueOf(browserFontFormat) + ", " + (String)object2 + " :" + String.valueOf(object)));
        }
        return n2 == 0;
    }

    public boolean installFont(String string, EnvProps envProps) {
        if (FontFiles.isStandardFontFamily((String)string)) {
            return true;
        }
        if (this.a == null) {
            return false;
        }
        Map<String, List<FontFiles>> map = this.a.getInstalledFontsMap();
        List<FontFiles> list = map.get(string);
        return list != null && !list.isEmpty() ? this.installFonts(list, envProps) : true;
    }

    public void setModule(ModuleModel moduleModel) {
        this.a = moduleModel;
    }
}

