/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.util;

import com.iizix.util.IJarFile;
import com.iizix.util.JarFilePath;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JarClassLoader
extends SecureClassLoader
implements Closeable {
    private static final PermissionCollection a;
    private final ArrayList<JarFilePath> a;
    private final WeakHashMap<Closeable, Void> a;
    private boolean a;
    private boolean b;
    private String a = new WeakHashMap();

    static {
        ClassLoader.registerAsParallelCapable();
        a = JarClassLoader.class.getProtectionDomain().getPermissions();
    }

    public JarClassLoader(IJarFile iJarFile) {
        this(iJarFile, null, null);
    }

    public JarClassLoader(IJarFile iJarFile, ClassLoader classLoader) {
        this(iJarFile, null, classLoader);
    }

    public JarClassLoader(IJarFile iJarFile, String string, ClassLoader classLoader) throws IllegalArgumentException {
        this(classLoader, new JarFilePath(iJarFile, string));
    }

    public JarClassLoader(ClassLoader classLoader, JarFilePath ... jarFilePathArray) throws IllegalArgumentException {
        super(classLoader != null ? classLoader : JarClassLoader.getSystemClassLoader());
        ((ArrayList)((Object)this.a)).addAll(List.of(jarFilePathArray));
    }

    public final void add(IJarFile iJarFile) {
        this.add(iJarFile, null);
    }

    public final void add(IJarFile iJarFile, String string) {
        this.a();
        ((ArrayList)((Object)this.a)).add(new JarFilePath(iJarFile, string));
    }

    public final void add(JarFilePath jarFilePath) {
        this.a();
        ((ArrayList)((Object)this.a)).add(jarFilePath);
    }

    public final void initialize() throws IOException {
        this.a();
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            JarFilePath jarFilePath = (JarFilePath)iterator.next();
            IJarFile iJarFile = jarFilePath.a;
            if (iJarFile == null) continue;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            Manifest manifest = null;
            try {
                Attributes attributes;
                manifest = iJarFile.getManifest();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                    string2 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    string3 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    string5 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    string = attributes.getValue(Attributes.Name.SEALED);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            boolean bl = Boolean.parseBoolean(string);
            String string8 = jarFilePath.a;
            Enumeration<JarEntry> enumeration = iJarFile.entries();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string9;
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.isDirectory()) continue;
                Object object2 = jarEntry.getName();
                if (!((String)object2).endsWith("/")) {
                    object2 = (String)object2 + "/";
                }
                if (string8 != null) {
                    if (!((String)object2).startsWith(string8)) continue;
                    string9 = ((String)object2).equals(string8) ? "" : ((String)object2).substring(string8.length(), ((String)object2).length() - 1).replace('/', '.');
                } else {
                    string9 = ((String)object2).substring(0, ((String)object2).length() - 1).replace('/', '.');
                }
                if (this.getDefinedPackage(string9) != null) continue;
                String string10 = null;
                String string11 = null;
                String string12 = null;
                String string13 = null;
                String string14 = null;
                String string15 = null;
                String string16 = null;
                if (manifest != null) {
                    object = manifest.getAttributes((String)object2);
                    if (object != null) {
                        string11 = ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_TITLE);
                        string12 = ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_VERSION);
                        string13 = ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_VENDOR);
                        string14 = ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                        string15 = ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        string16 = ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                        string10 = ((Attributes)object).getValue(Attributes.Name.SEALED);
                    }
                    if (string11 == null) {
                        string11 = string2;
                    }
                    if (string12 == null) {
                        string12 = string3;
                    }
                    if (string13 == null) {
                        string13 = string4;
                    }
                    if (string14 == null) {
                        string14 = string5;
                    }
                    if (string15 == null) {
                        string15 = string6;
                    }
                    if (string16 == null) {
                        string16 = string7;
                    }
                    if (string10 == null) {
                        string10 = string;
                    }
                }
                object = null;
                boolean bl2 = Boolean.parseBoolean(string10);
                if (bl) {
                    if (!bl2) {
                        throw new IOException("Classpath entry " + (String)object2 + " is not sealed while Jar file is sealed");
                    }
                    object = iJarFile.getURL(jarEntry);
                }
                super.definePackage(string9, string11, string12, string13, string14, string15, string16, (URL)object);
            }
        }
        this.a = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object3;
        this.b = true;
        IOException iOException = null;
        Object object2 = this.a;
        synchronized (object2) {
            for (Object object3 : ((WeakHashMap)((Object)this.a)).keySet()) {
                try {
                    object3.close();
                }
                catch (IOException iOException2) {
                    if (iOException == null) {
                        iOException = iOException2;
                        continue;
                    }
                    iOException.addSuppressed(iOException2);
                }
            }
            ((WeakHashMap)((Object)this.a)).clear();
        }
        object3 = ((ArrayList)((Object)this.a)).iterator();
        while (object3.hasNext()) {
            object2 = (JarFilePath)object3.next();
            IJarFile iJarFile = ((JarFilePath)object2).a;
            if (iJarFile == null) continue;
            try {
                iJarFile.close();
            }
            catch (IOException iOException3) {
                if (iOException == null) {
                    iOException = iOException3;
                    continue;
                }
                iOException.addSuppressed(iOException3);
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public final Class<?> findClass(String string) throws ClassNotFoundException {
        this.b();
        if (!this.b) {
            Object object;
            try {
                object = this.getParent().loadClass(string);
                if (object != null) {
                    return object;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            object = string.replace('.', '/') + ".class";
            Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
            while (iterator.hasNext()) {
                Object object2;
                JarFilePath jarFilePath = (JarFilePath)iterator.next();
                if (jarFilePath.a != null) {
                    int n2;
                    object2 = jarFilePath.a((String)object);
                    if (object2 == null || ((ZipEntry)object2).isDirectory()) continue;
                    byte[] byArray = jarFilePath.a.getEntryData((ZipEntry)object2);
                    if (byArray == null) {
                        throw new ClassNotFoundException("Class " + string + " does not contain Jar file data");
                    }
                    ProtectionDomain protectionDomain = null;
                    Certificate[] certificateArray = ((JarEntry)object2).getCertificates();
                    if (certificateArray != null && (n2 = certificateArray.length) > 0) {
                        Principal[] principalArray = new Principal[n2];
                        while (--n2 >= 0) {
                            principalArray[n2] = ((X509Certificate)certificateArray[n2]).getSubjectX500Principal();
                        }
                        protectionDomain = new ProtectionDomain(new CodeSource(jarFilePath.a.getURL(), certificateArray), a, this, principalArray);
                    }
                    return this.defineClass(string, byArray, 0, byArray.length, protectionDomain);
                }
                object2 = jarFilePath.a((String)object);
                if (object2 == null) continue;
                try {
                    byte[] byArray = Files.readAllBytes(((File)object2).toPath());
                    return this.defineClass(string, byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException(string + this.a(), iOException);
                }
            }
        }
        throw new ClassNotFoundException(string + this.a());
    }

    @Override
    public final URL findResource(String string) {
        this.b();
        if (!this.b) {
            Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
            while (iterator.hasNext()) {
                Object object;
                JarFilePath jarFilePath = (JarFilePath)iterator.next();
                if (jarFilePath.a != null) {
                    object = jarFilePath.a(string);
                    if (object == null) continue;
                    return jarFilePath.a.getURL((ZipEntry)object);
                }
                object = jarFilePath.b(string);
                if (object == null) continue;
                try {
                    return ((File)object).toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public final Enumeration<URL> findResources(String string) {
        this.b();
        if (this.b) {
            return Collections.emptyEnumeration();
        }
        Vector<URL> vector = new Vector<URL>();
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            Object object;
            JarFilePath jarFilePath = (JarFilePath)iterator.next();
            if (jarFilePath.a != null) {
                object = jarFilePath.a(string);
                if (object == null) continue;
                vector.add(jarFilePath.a.getURL((ZipEntry)object));
                continue;
            }
            object = jarFilePath.b(string);
            if (object == null) continue;
            try {
                vector.add(((File)object).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return vector.isEmpty() ? Collections.emptyEnumeration() : vector.elements();
    }

    @Override
    public final InputStream getResourceAsStream(String string) {
        this.b();
        if (!this.b) {
            Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
            while (iterator.hasNext()) {
                Object object;
                JarFilePath jarFilePath = (JarFilePath)iterator.next();
                if (jarFilePath.a != null) {
                    object = jarFilePath.a(string);
                    if (object == null || ((ZipEntry)object).isDirectory()) continue;
                    try {
                        return this.a(jarFilePath.a.getInputStream((ZipEntry)object));
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                object = jarFilePath.a(string);
                if (object == null) continue;
                try {
                    return this.a(new FileInputStream((File)object));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void a() {
        if (this.a) {
            throw new IllegalStateException("Class loader is already initialized" + this.a());
        }
        if (this.b) {
            throw new IllegalStateException("Class loader is closed" + this.a());
        }
    }

    private void b() {
        if (!this.a) {
            throw new IllegalStateException("Class loader is not yet initialized" + this.a());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream a(InputStream inputStream) {
        if (!(inputStream instanceof ByteArrayInputStream)) {
            PermissionCollection permissionCollection = this.a;
            synchronized (permissionCollection) {
                ((WeakHashMap)((Object)this.a)).put(inputStream, null);
            }
        }
        return inputStream;
    }

    private String a() {
        if (this.a == null) {
            StringBuilder stringBuilder = new StringBuilder(", in [");
            boolean bl = false;
            Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
            while (iterator.hasNext()) {
                JarFilePath jarFilePath = (JarFilePath)iterator.next();
                if (bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = true;
                }
                jarFilePath.a(stringBuilder);
            }
            this.a = stringBuilder.append(']').toString();
            if (this.b) {
                stringBuilder.append(" - class loader CLOSED");
            } else if (!this.a) {
                stringBuilder.append(" - class loader NOT INITIALIZED");
            }
        }
        return this.a;
    }
}

