/*
 * Decompiled with CFR 0.152.
 */
package com.iizix;

import com.iizix.ILog;
import com.iizix.SendTransaction;
import com.iizix.j;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class WriteCache {
    private final int a;
    private final int b;
    private final int c;
    private final WeakHashMap<SendTransaction, Boolean> a;
    private final LinkedHashMap<String, j> a = (int)new WeakHashMap(8);

    public WriteCache() {
        this(700, 7, 200);
    }

    public WriteCache(int n2, int n3, int n4) {
        if (n3 < 7) {
            ILog.WARNING(this.getClass(), "Write cache minLength < 7, assuming 7, minLength = " + n3, new Exception("Constructor stack trace"));
            n3 = 7;
        } else if (n3 > 64) {
            ILog.WARNING(this.getClass(), "Write cache minLength > 64, assuming 64, minLength = " + n3, new Exception("Constructor stack trace"));
            n3 = 64;
        }
        if (n4 < n3 + 1) {
            ILog.WARNING(this.getClass(), "Write cache maxLength < minLength+1, assuming 200, maxLength = " + n4, new Exception("Constructor stack trace"));
            n4 = 200;
        } else if (n4 > 1024) {
            int n5 = Math.max(n3 + 1, 256);
            ILog.WARNING(this.getClass(), "Write cache maxLength > 1024, assuming " + n5 + ", maxLength = " + n4, new Exception("Constructor stack trace"));
            n4 = n5;
        }
        if (n2 < 10) {
            ILog.SEVERE(this.getClass(), "Write cache maxCount < 10: constructor should not have been called, assuming 700, maxCount = " + n2, new Exception("Constructor stack trace"));
            n2 = 700;
        } else if (n2 > 8192) {
            ILog.WARNING(this.getClass(), "Write cache maxCount > 8192, assuming 8192, maxCount = " + n2, new Exception("Constructor stack trace"));
            n2 = 8192;
        }
        this.a = (int)new LinkedHashMap(n2);
        this.a = n2;
        this.b = n3;
        this.c = n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(SendTransaction sendTransaction) {
        int n2 = this.a;
        synchronized (n2) {
            this.a.put(sendTransaction, Boolean.TRUE);
            if (this.a.size() > 9) {
                ILog.SEVERE(this.getClass(), "WriteCache.grab(SendTransaction): size = " + this.a.size(), new Exception("WriteCache.grab(sendTrans) stack trace"));
                int n3 = 0;
                Iterator iterator = this.a.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getKey() == null || entry.getValue() != Boolean.TRUE) {
                        ILog.SEVERE(this.getClass(), "WriteCache.grab(SendTransaction): previous grab for SendTransaction at index " + n3 + " has been garbage collected and did not release its WriteCache", new Exception("WriteCache.grab(sendTrans) stack trace"));
                        iterator.remove();
                    }
                    ++n3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void b(SendTransaction sendTransaction) {
        int n2 = this.a;
        synchronized (n2) {
            int n3;
            if (this.a.remove(sendTransaction) == null) {
                ILog.SEVERE(this.getClass(), "SendTransaction called WriteCache.release(sendTrans), but did not previously grab WriteCache", new Exception("WriteCache.release(sendTrans) stack trace"));
            }
            if (this.a.isEmpty() && (n3 = this.a.size()) > this.a) {
                ILog.WARNING(this.getClass(), "SendTransaction WriteCache has been overflowed by " + (n3 - this.a) + " items, consider adjusting the configured size or maximum count to a value larger or equal to " + n3 + " instead of configured size or maximum count " + this.a);
            }
        }
    }

    boolean a(int n2) {
        return n2 >= this.b && n2 <= this.c;
    }

    boolean a(String string) {
        return this.a.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int a(String string) {
        j j2;
        int n2 = this.a;
        synchronized (n2) {
            j2 = (j)this.a.remove(string);
            if (j2 == null) {
                int n3 = this.a.size();
                if (n3 == 1) {
                    int n4 = this.a.size();
                    if (n4 >= this.a) {
                        Iterator iterator = this.a.values().iterator();
                        j j3 = (j)iterator.next();
                        iterator.remove();
                        j2 = new j(string, j3.a);
                    } else {
                        j2 = new j(string, n4 + 1);
                    }
                } else {
                    if (n3 == 0) {
                        throw new InternalError("WriteCache.addString(s) called without prior WriteCache.grab(SendTransaction)");
                    }
                    j2 = new j(string, this.a.size() + 1);
                }
            }
        }
        this.a.put(string, j2);
        return j2.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpCache(String string) {
        StringBuilder stringBuilder = new StringBuilder("WriteCache: maximum count = ");
        int n2 = this.a;
        synchronized (n2) {
            int n3;
            stringBuilder.append(this.a).append(", cache count = ").append(this.a.size());
            Object object = Integer.toString(this.a);
            int n4 = n3 = ((String)object).length();
            object = " ";
            while (--n4 > 0) {
                object = (String)object + " ";
            }
            int n5 = 0;
            for (j j2 : this.a.values()) {
                String string2 = Integer.toString(n5++);
                stringBuilder.append(string).append('[').append(((String)object).substring(0, n3 - string2.length())).append("]: ").append(j2.a).append(" = \"").append(j2.a).append('\"');
            }
        }
        return stringBuilder.toString();
    }
}

