/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.Messages;

public class ExternalFeatureModelManager {
    private final ListenerList<IModelProviderListener> fListeners = new ListenerList();
    private IFeatureModel[] fModels;

    public static IFeatureModel createModel(File manifest) throws CoreException {
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(manifest.getParent());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(manifest));){
                model.load(stream, false);
                return model;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetFeature_FileDoesNotExist, (Object)manifest)));
        }
    }

    public void addModelProviderListener(IModelProviderListener listener) {
        this.fListeners.add((Object)listener);
    }

    private void fireModelProviderEvent(IModelProviderEvent e) {
        for (IModelProviderListener listener : this.fListeners) {
            listener.modelsChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        IFeatureModel[] oldModels = null;
        ExternalFeatureModelManager externalFeatureModelManager = this;
        synchronized (externalFeatureModelManager) {
            oldModels = this.fModels != null ? this.fModels : new IFeatureModel[]{};
            long startTime = System.currentTimeMillis();
            this.fModels = this.getExternalModels();
            if (PDECore.DEBUG_MODEL) {
                System.out.println("Time to load features from target platform (ms): " + (System.currentTimeMillis() - startTime));
                System.out.println("External features loaded: " + this.fModels.length);
            }
        }
        this.notifyListeners(oldModels, this.fModels);
    }

    private IFeatureModel[] getExternalModels() {
        ITargetDefinition target;
        if (PDECore.getDefault().getModelManager().isCancelled()) {
            return new IFeatureModel[0];
        }
        try {
            target = TargetPlatformHelper.getWorkspaceTargetResolved(null);
        }
        catch (CoreException e) {
            PDECore.log(e);
            return new IFeatureModel[0];
        }
        if (target == null) {
            return new IFeatureModel[0];
        }
        ArrayList<IFeatureModel> result = new ArrayList<IFeatureModel>();
        TargetFeature[] features = target.getAllFeatures();
        if (features != null) {
            TargetFeature[] targetFeatureArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                TargetFeature feature = targetFeatureArray[n2];
                IFeatureModel model = ExternalFeatureModelManager.getFreshFeatureModel(feature);
                if (model.isLoaded()) {
                    result.add(model);
                }
                ++n2;
            }
        }
        return result.toArray(new IFeatureModel[result.size()]);
    }

    private void notifyListeners(IFeatureModel[] oldModels, IFeatureModel[] newFeatureModels) {
        if (oldModels.length > 0 || newFeatureModels.length > 0) {
            int type = 0;
            if (oldModels.length > 0) {
                type |= 2;
            }
            if (newFeatureModels.length > 0) {
                type |= 1;
            }
            ModelProviderEvent replacedFeatures = new ModelProviderEvent(this, type, newFeatureModels, oldModels, null);
            this.fireModelProviderEvent(replacedFeatures);
        }
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public IFeatureModel[] getModels() {
        return this.fModels;
    }

    private static IFeatureModel getFreshFeatureModel(TargetFeature feature) {
        File manifest;
        String location = feature.getLocation();
        if (location != null && (manifest = new File(location, "feature.xml")).exists() && manifest.isFile()) {
            try {
                return ExternalFeatureModelManager.createModel(manifest);
            }
            catch (CoreException e) {
                PDECore.log(e);
            }
        }
        return (IFeatureModel)feature.getFeatureModel();
    }

    public static TargetFeature[] createFeatures(String platformHome, ArrayList<String> additionalLocations, IProgressMonitor monitor) {
        if (platformHome != null && platformHome.length() > 0) {
            URL[] featureURLs = PluginPathFinder.getFeaturePaths(platformHome);
            if (additionalLocations.isEmpty()) {
                return ExternalFeatureModelManager.createFeatures(featureURLs, monitor);
            }
            File[] dirs = new File[additionalLocations.size()];
            int i = 0;
            while (i < dirs.length) {
                String directory = additionalLocations.get(i);
                File dir = new File(directory, "features");
                if (!dir.exists()) {
                    dir = new File(directory);
                }
                dirs[i] = dir;
                ++i;
            }
            URL[] newUrls = PluginPathFinder.scanLocations(dirs);
            URL[] result = new URL[featureURLs.length + newUrls.length];
            System.arraycopy(featureURLs, 0, result, 0, featureURLs.length);
            System.arraycopy(newUrls, 0, result, featureURLs.length, newUrls.length);
            return ExternalFeatureModelManager.createFeatures(result, monitor);
        }
        return new TargetFeature[0];
    }

    private static TargetFeature[] createFeatures(URL[] featurePaths, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)featurePaths.length);
        LinkedHashMap<CallSite, TargetFeature> uniqueFeatures = new LinkedHashMap<CallSite, TargetFeature>();
        URL[] uRLArray = featurePaths;
        int n = featurePaths.length;
        int n2 = 0;
        while (n2 < n) {
            URL featurePath = uRLArray[n2];
            File manifest = new File(featurePath.getFile(), "feature.xml");
            if (!manifest.exists() || !manifest.isFile()) {
                subMonitor.split(1);
            } else {
                try {
                    TargetFeature model = new TargetFeature(manifest);
                    uniqueFeatures.put((CallSite)((Object)(model.getId() + "_" + model.getVersion())), model);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                subMonitor.split(1);
            }
            ++n2;
        }
        Collection models = uniqueFeatures.values();
        return models.toArray(new TargetFeature[models.size()]);
    }
}

