/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.internal.debug.ui.breakpoints.StandardJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MethodBreakpointEditor
extends StandardJavaBreakpointEditor {
    private Button fEntry;
    private Button fExit;
    public static final int PROP_ENTRY = 4114;
    public static final int PROP_EXIT = 4115;

    @Override
    public Control createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)0, (int)0, (int)0);
        super.createControl(composite);
        Composite watchComp = SWTFactory.createComposite((Composite)composite, (Font)parent.getFont(), (int)3, (int)1, (int)0, (int)0, (int)0);
        this.fEntry = this.createSusupendPropertyEditor(watchComp, this.processMnemonics(PropertyPageMessages.JavaLineBreakpointPage_10), 4114);
        this.fExit = this.createSusupendPropertyEditor(watchComp, this.processMnemonics(PropertyPageMessages.JavaLineBreakpointPage_11), 4115);
        return composite;
    }

    @Override
    protected void setBreakpoint(IJavaBreakpoint breakpoint) throws CoreException {
        super.setBreakpoint(breakpoint);
        if (breakpoint instanceof IJavaMethodBreakpoint) {
            IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)breakpoint;
            if (methodBreakpoint.isLambdaBreakpoint()) {
                this.fEntry.setEnabled(false);
                this.fExit.setEnabled(false);
                return;
            }
            this.fEntry.setEnabled(true);
            this.fExit.setEnabled(true);
            this.fEntry.setSelection(methodBreakpoint.isEntry());
            this.fExit.setSelection(methodBreakpoint.isExit());
        } else {
            this.fEntry.setEnabled(false);
            this.fExit.setEnabled(false);
            this.fEntry.setSelection(false);
            this.fExit.setSelection(false);
        }
    }

    @Override
    public void doSave() throws CoreException {
        super.doSave();
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint instanceof IJavaMethodBreakpoint) {
            IJavaMethodBreakpoint watchpoint = (IJavaMethodBreakpoint)breakpoint;
            watchpoint.setEntry(this.fEntry.getSelection());
            watchpoint.setExit(this.fExit.getSelection());
        }
    }
}

