/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.wsfile;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.jetty.IWSFileProviderServer;
import com.iizix.server.prop.ServerSettings;
import com.iizix.server.wsfile.WSFileProvider;
import com.iizix.urn.URNResourceType;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WSFileProviderEngine
implements IWSFileProviderServer {
    private final File a;
    private final Path a;
    private final Map<URNResourceType, WSFileProvider> a;
    private final Map<URNResourceType, Map<String, WSFileProvider>> b;
    private boolean a = new HashMap();

    public WSFileProviderEngine(ServerSettings serverSettings) throws IOException {
        this.b = new HashMap<URNResourceType, Map<String, WSFileProvider>>();
        String string = serverSettings.getFileProviderRoot();
        try {
            this.a = new File(string).getCanonicalFile();
            this.a = this.a.toPath();
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid root path \"" + string + "\": " + invalidPathException.getMessage());
        }
        if (!this.a.isDirectory()) {
            Files.createDirectories(this.a, new FileAttribute[0]);
        }
    }

    public WSFileProviderEngine(File file) throws IOException {
        this.b = new HashMap<URNResourceType, Map<String, WSFileProvider>>();
        file = file.getCanonicalFile();
        if (!file.isDirectory()) {
            throw new IOException("WSFileProviderEngine root directory " + String.valueOf(file) + " does not exist");
        }
        this.a = file;
        try {
            this.a = this.a.toPath();
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid root path \"" + String.valueOf(this.a) + "\": " + invalidPathException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSFileProvider getCreateFileProvider(URNResourceType uRNResourceType, String string, String string2, Object object, boolean bl, ServerSettings serverSettings) throws IOException {
        WSFileProvider wSFileProvider;
        if (this.a) {
            throw new IllegalStateException("Engine is disposed");
        }
        Class<?> clazz = uRNResourceType.idClass;
        if (clazz != null) {
            if (object == null) {
                throw new NullPointerException("id must be specified but is null");
            }
            clazz = object.getClass();
            if (!clazz.equals(uRNResourceType.idClass)) {
                throw new IllegalArgumentException("id class must be " + uRNResourceType.idClass.getCanonicalName() + " but is " + clazz.getCanonicalName());
            }
        }
        if (uRNResourceType.isSubjectBased) {
            Map<String, WSFileProvider> map;
            if (string2 == null) {
                throw new NullPointerException("Subject is null, type = " + String.valueOf(uRNResourceType));
            }
            Map<Object, Object> map2 = this.b;
            synchronized (map2) {
                map = this.b.get(uRNResourceType);
                if (map == null) {
                    map = new HashMap<String, WSFileProvider>();
                    this.b.put(uRNResourceType, map);
                }
            }
            map2 = map;
            synchronized (map2) {
                String string3;
                Object object2;
                Object object3;
                if (bl) {
                    object3 = new char[1];
                    object2 = new StringBuilder();
                    char[] cArray = string2.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c2 = cArray[n2];
                        if (c2 == '/' || c2 == '\\' || c2 < ' ' || c2 >= '\u007f') {
                            object3[0] = c2;
                            ((StringBuilder)object2).append(URLEncoder.encode(new String((char[])object3), StandardCharsets.UTF_8));
                        } else {
                            ((StringBuilder)object2).append(c2);
                        }
                        ++n2;
                    }
                    string3 = ((StringBuilder)object2).toString();
                    if (string3.isEmpty()) {
                        string3 = uRNResourceType.getUniqueDirectory();
                    }
                    if (!string3.equals(string2)) {
                        ILog.WARNING(this.getClass(), (String)("Subject based file provider with doPersistFileNames cannot find unique name from subject \"" + string2 + "\", assigning new subject \"" + string3 + "\": file type = " + uRNResourceType.name()));
                    }
                } else {
                    string3 = uRNResourceType.getUniqueDirectory();
                }
                if ((wSFileProvider = map.get(object3 = (Object)Utilities.encodeURIComponent((String)string3))) == null) {
                    object2 = uRNResourceType.internalSubDirectory + File.separatorChar + string3;
                    File file = Utilities.getCanonicalFile((File)new File(this.a, (String)object2));
                    String string4 = "/$$" + uRNResourceType.externalStartPath + "/" + (String)object3 + "/";
                    wSFileProvider = new WSFileProvider(file, string4, uRNResourceType, string, string2, bl, serverSettings);
                    map.put(string3, wSFileProvider);
                }
            }
        }
        File file = this.a;
        synchronized (file) {
            wSFileProvider = (WSFileProvider)this.a.get(uRNResourceType);
            if (wSFileProvider == null) {
                String string5 = uRNResourceType.internalSubDirectory;
                File file2 = Utilities.getCanonicalFile((File)new File(this.a, string5));
                String string6 = "/$$" + uRNResourceType.externalStartPath + "/";
                wSFileProvider = new WSFileProvider(file2, string6, uRNResourceType, uRNResourceType.descr, null, bl, serverSettings);
                this.a.put(uRNResourceType, wSFileProvider);
            }
        }
        return wSFileProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFileResourceFromExternalURL(String string) {
        String string2;
        URNResourceType uRNResourceType;
        if (this.a || !string.startsWith("/$$")) {
            return null;
        }
        int n = string.indexOf(63, 3);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(47, 3)) < 4) {
            return null;
        }
        if ((uRNResourceType = URNResourceType.ofExternalStartPath((String)(string2 = string.substring(3, n++)))) == null) {
            return null;
        }
        WSFileProvider wSFileProvider = null;
        String string3 = null;
        File file = null;
        if (uRNResourceType.isSubjectBased) {
            Map<String, WSFileProvider> map;
            int n2 = string.indexOf(47, n);
            if (n2 <= n) {
                return null;
            }
            Object object = this.b;
            synchronized (object) {
                map = this.b.get(uRNResourceType);
            }
            if (map != null) {
                object = string.substring(n, n2);
                string3 = string.substring(n2 + 1);
                Map<String, WSFileProvider> map2 = map;
                synchronized (map2) {
                    wSFileProvider = map.get(object);
                }
            }
        } else {
            string3 = string.substring(n);
            File file2 = this.a;
            synchronized (file2) {
                wSFileProvider = (WSFileProvider)this.a.get(uRNResourceType);
            }
        }
        if (wSFileProvider != null) {
            file = wSFileProvider.a(string3);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<WSFileProvider> arrayList;
        Map<URNResourceType, Map<String, WSFileProvider>> object3 = this.b;
        synchronized (object3) {
            if (this.a) {
                return;
            }
            this.a = true;
            arrayList = new ArrayList<WSFileProvider>();
            for (Map<String, WSFileProvider> map : this.b.values()) {
                arrayList.addAll(map.values());
            }
        }
        File file = this.a;
        synchronized (file) {
            arrayList.addAll(this.a.values());
        }
        for (WSFileProvider wSFileProvider : arrayList) {
            try {
                wSFileProvider.dispose(wSFileProvider.getType().doDeleteFiles, false);
            }
            catch (IOException iOException) {
                ILog.WARNING(this.getClass(), (String)("Failed disposing file provider: " + String.valueOf(wSFileProvider)), (Throwable)iOException);
            }
        }
    }
}

