/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.webthumbs;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.Utilities;
import com.iizix.server.IServerDisposeListener;
import com.iizix.server.ServerShell;
import com.iizix.server.prop.ServerSettings;
import com.iizix.server.webthumbs.WebThumbnail;
import com.iizix.server.webthumbs.a;
import com.iizix.server.wsfile.WSFileProvider;
import com.iizix.server.wsfile.WSFileProviderEngine;
import com.iizix.urn.URNResourceType;
import com.iizix.wsfile.IWSFile;
import jakarta.mail.internet.InternetAddress;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WebThumbs {
    public static final boolean DEBUG = false;
    static String a;
    private final ThreadPoolExecutor a;
    final WSFileProvider a;
    private final File a;
    private boolean a;
    private HashMap<String, WebThumbnail> a;
    private final ServerShell a;
    private final IServerDisposeListener a = new a(this);

    public static String siteToFileName(String string, int n, int n2, int n3) {
        if (n < 10 || n > 1000) {
            throw new IllegalArgumentException("width (10-1000) invalid: " + n);
        }
        if (n2 < 10 || n2 > 1000) {
            throw new IllegalArgumentException("height (10-1000) invalid: " + n2);
        }
        if (n3 < 0 || n3 > 100) {
            throw new IllegalArgumentException("quality (0-100) invalid: " + n3);
        }
        StringBuilder stringBuilder = new StringBuilder("website-").append(string.toLowerCase()).append("-thumbnail-").append(n).append('x').append(n2);
        if (n3 == 0) {
            stringBuilder.append(".png");
        } else {
            stringBuilder.append('-').append(n3).append(".jpg");
        }
        return stringBuilder.toString();
    }

    public static String siteToFileName(String string) {
        return "website-" + string.toLowerCase() + "-thumbnail.png";
    }

    public static String fileNameToSite(String string) {
        if (string.length() < 25 || !string.startsWith("website-") || !string.endsWith("-thumbnail.png")) {
            return null;
        }
        String string2 = string.substring(8, string.length() - 14);
        return string2.isEmpty() ? null : string2;
    }

    public static String urlToSite(URL uRL) throws MalformedURLException {
        return WebThumbs.stringToSite(uRL.toExternalForm());
    }

    public static String urlToSite(InternetAddress internetAddress) throws MalformedURLException {
        return WebThumbs.stringToSite(internetAddress.getAddress());
    }

    public static String stringToSite(String string) throws MalformedURLException {
        String string2 = string;
        int n = (string = string.trim()).indexOf("//");
        if (n >= 0) {
            string = string.substring(n + 2);
        }
        if ((n = string.indexOf(64)) >= 0) {
            if ((n = (string = string.substring(n + 1)).indexOf(62)) >= 0) {
                string = string.substring(0, n).trim();
            }
        } else {
            n = string.indexOf(58);
            if (n >= 0) {
                string = string.substring(0, n);
            }
        }
        if ((n = string.indexOf(47)) >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(63)) >= 0) {
            string = string.substring(0, n);
        }
        if ((string = string.trim().toLowerCase()).isEmpty() || string.indexOf(46) < 0) {
            throw new MalformedURLException("Invalid site (" + string + ") for thumbnails: " + string2);
        }
        try {
            new URI("http://" + string).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new MalformedURLException("Invalid website URL \"http[s]://" + string + "\" for thumbnails: " + exception.getMessage());
        }
        return string;
    }

    public WebThumbs(ServerShell serverShell) throws IOException {
        if (!serverShell.addDisposeListener(this.a)) {
            throw new IllegalStateException("WebThumbs must be created from the Server instance and not directly");
        }
        this.a = serverShell;
        ServerSettings serverSettings = serverShell.getServerSettings();
        File file = null;
        WSFileProvider wSFileProvider = null;
        ThreadPoolExecutor threadPoolExecutor = null;
        int n = serverSettings.getMaxConcurrentThumbnailsRequests();
        String string = serverSettings.getUrlboxIOAPIKey();
        if (!string.isEmpty()) {
            a = string;
            WSFileProviderEngine wSFileProviderEngine = serverShell.getFileProviderEngine();
            wSFileProvider = wSFileProviderEngine.getCreateFileProvider(URNResourceType.COMMON_PERSISTENT, "WebThumbs", "webthumbs", null, true, serverShell.getServerSettings());
            file = wSFileProvider.getRoot();
            ILog.INFO(this.getClass(), (String)("Website thumnail images are loaded from " + file.getPath()));
            threadPoolExecutor = new ThreadPoolExecutor(Math.min(5, n), n, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        } else {
            this.a = true;
        }
        this.a = file;
        this.a = wSFileProvider;
        this.a = threadPoolExecutor;
        if (!this.a) {
            this.a();
        }
    }

    public WSFileProvider getFileProvider() {
        return this.a;
    }

    private void a() {
        int n = 0;
        File[] fileArray = this.a.listFiles();
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                block8: {
                    String string;
                    String string2;
                    File file = fileArray2[n3];
                    if (file.isFile() && file.length() > 0L && (string2 = WebThumbs.fileNameToSite(string = file.getName())) != null && string.equals(WebThumbs.siteToFileName(string2)) && !((HashMap)((Object)this.a)).containsKey(string2)) {
                        try {
                            file = Utilities.getCanonicalFile((File)file);
                            string = file.getName();
                            IWSFile iWSFile = this.a.getFileFromFileName(string);
                            if (iWSFile == null) {
                                try {
                                    iWSFile = this.a.reserveFile(file, string2, null);
                                }
                                catch (NotFoundException notFoundException) {
                                    break block8;
                                }
                            }
                            WebThumbnail webThumbnail = new WebThumbnail(string2, file, iWSFile);
                            ((HashMap)((Object)this.a)).put(string2, webThumbnail);
                            ++n;
                        }
                        catch (Throwable throwable) {
                            ILog.SEVERE(this.getClass(), (String)"This should not be happening!", (Throwable)throwable);
                        }
                    }
                }
                ++n3;
            }
        }
        ILog.INFO(this.getClass(), (String)("Loaded " + n + " Website thumbnails"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebThumbnail requestWebThumbnail(String string) throws MalformedURLException, IllegalStateException {
        WebThumbnail webThumbnail;
        String string2 = this.a;
        synchronized (string2) {
            block15: {
                if (this.a) {
                    throw new IllegalStateException("WebThumbs instance is disposed of");
                }
                webThumbnail = (WebThumbnail)((HashMap)((Object)this.a)).get(string = WebThumbs.stringToSite(string));
                if (webThumbnail == null) {
                    boolean bl = false;
                    IWSFile iWSFile = null;
                    String string3 = WebThumbs.siteToFileName(string);
                    File file = Utilities.getCanonicalFile((File)new File(this.a, string3));
                    if (file.isFile() && file.length() > 0L) {
                        try {
                            iWSFile = this.a.getFileFromFileName(string3);
                            if (iWSFile == null) {
                                try {
                                    iWSFile = this.a.reserveFile(file, string, null);
                                }
                                catch (NotFoundException notFoundException) {}
                            }
                        }
                        catch (Throwable throwable) {
                            ILog.SEVERE(this.getClass(), (String)"This should not be happening!", (Throwable)throwable);
                        }
                        bl = iWSFile != null;
                    }
                    webThumbnail = new WebThumbnail(string, file, iWSFile);
                    ((HashMap)((Object)this.a)).put(string, webThumbnail);
                    if (!bl) {
                        try {
                            Runnable runnable = webThumbnail.a(this.a, this.a);
                            if (runnable != null) {
                                this.a.execute(runnable);
                            }
                        }
                        catch (Throwable throwable) {
                            if (this.a) break block15;
                            ILog.SEVERE(this.getClass(), (String)("Failed loading the thumbnail for the Website " + string), (Throwable)throwable);
                        }
                    }
                }
            }
        }
        return webThumbnail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(ServerShell serverShell) {
        WebThumbnail[] webThumbnailArray = this;
        synchronized (this) {
            if (this.a) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.a = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.a.purge();
            this.a.shutdownNow();
            serverShell.removeDisposeListener(this.a);
            Object object = this.a;
            synchronized (object) {
                webThumbnailArray = ((HashMap)((Object)this.a)).values().toArray(new WebThumbnail[((HashMap)((Object)this.a)).size()]);
                ((HashMap)((Object)this.a)).clear();
            }
            WebThumbnail[] webThumbnailArray2 = webThumbnailArray;
            int n = webThumbnailArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = webThumbnailArray2[n2];
                ((WebThumbnail)object).a();
                ++n2;
            }
            return;
        }
    }
}

