/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.js.build;

import com.iizix.IWebServerCompression;
import com.iizix.Utilities;
import com.iizix.js.build.Compressor;
import com.iizix.js.build.ISourceResolver;
import com.iizix.js.build.InfoFromSources;
import com.iizix.js.build.TransformHTMLSource;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HTMLSourceInfo {
    private final IWebServerCompression a;
    private final ISourceResolver a;
    private final String a;
    private long a;
    private long b;
    private final File a;
    private final File b;
    private Config[] a;

    HTMLSourceInfo(IWebServerCompression iWebServerCompression, ISourceResolver iSourceResolver, File file) throws FileNotFoundException {
        if (!file.isFile()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " is not found");
        }
        this.a = iWebServerCompression;
        this.a = iSourceResolver;
        this.b = file;
        this.a = file.getParentFile();
        String string = file.getName();
        int n = string.indexOf(46);
        this.a = string.substring(0, n) + "-build-";
    }

    public Config getConfig(boolean bl, boolean bl2) throws IOException {
        return this.a(bl, bl2, true);
    }

    synchronized Config a(boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n;
        Config config;
        long l = this.b.lastModified();
        if (l <= 0L) {
            throw new FileNotFoundException("File " + this.b.getAbsolutePath() + " is not found");
        }
        long l2 = this.b.length();
        if (this.a != l || l2 != this.b) {
            this.a = l;
            this.b = l2;
            if (this.a != null) {
                Config[] configArray = this.a;
                int n2 = this.a.length;
                int n3 = 0;
                while (n3 < n2) {
                    Config config2 = configArray[n3];
                    if (config2 != null) {
                        config2.a();
                    }
                    ++n3;
                }
                this.a = null;
            }
        }
        if (this.a == null) {
            this.a = new Config[4];
        }
        if ((config = this.a[n = (bl ? 0 : 1) | (bl2 ? 0 : 2)]) == null) {
            config = this.a[n] = new Config(bl, bl2, bl3);
        }
        if (bl3 && !config.a && !bl2) {
            config.getMinifiedCSS();
            config.getCompressedJS();
        }
        return config;
    }

    public boolean isCompressedConfigPresent(boolean bl) {
        String string = this.a + (bl ? "local" : "remote") + "-prod.";
        File file = new File(this.a, string + "css");
        File file2 = new File(this.a, string + "js");
        File file3 = new File(this.a, string + "html");
        File file4 = new File(this.a, string + "dat");
        return file.isFile() && file2.isFile() && file3.isFile() && file4.isFile();
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class Config {
        public final boolean isLocal;
        public final boolean isDevel;
        public final String source;
        public final List<String> cssList;
        public final List<String> jsList;
        public final List<String> amdList;
        public final Map<String, String> settings;
        private List<String> a;
        private List<String> b;
        private final HashMap<File, Long> a;
        private final HashMap<File, Long> b;
        private final HashMap<File, Long> c;
        private File a;
        private FileInputStream a;
        private File b;
        private final HashMap<File, File> d;
        private FileInputStream b;
        private File c;
        final boolean a;
        final String a = new HashMap();
        private File d;
        private File e;
        private File f;
        private File g;
        private File h;
        private File i;
        private File j;

        /*
         * WARNING - void declaration
         */
        private Config(boolean bl, boolean bl2, boolean bl3) throws IOException {
            this.b = new HashMap();
            this.c = new HashMap();
            this.d = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = null;
            this.isLocal = bl;
            this.isDevel = bl2;
            this.a = HTMLSourceInfo.this.a + (bl ? "local" : "remote") + "-" + (bl2 ? "dev" : "prod") + ".";
            this.d = new File(HTMLSourceInfo.this.a, this.a + "css");
            this.e = new File(HTMLSourceInfo.this.a, this.a + "css.gz");
            this.f = new File(HTMLSourceInfo.this.a, this.a + "js");
            this.g = new File(HTMLSourceInfo.this.a, this.a + "js.gz");
            this.h = new File(HTMLSourceInfo.this.a, this.a + "html");
            this.i = new File(HTMLSourceInfo.this.a, this.a + "html.gz");
            this.j = new File(HTMLSourceInfo.this.a, this.a + "dat");
            this.a = this.h.isFile();
            if (this.a) {
                File file;
                File file2;
                File file3;
                File file4;
                File parseException;
                File object;
                File file5 = this.d;
                if (!(file5.isFile() && (object = this.f).isFile() && (parseException = this.h).isFile() && (file4 = this.j).isFile())) {
                    void var10_14;
                    throw new IOException("Inconsistencies in web resources: missing compressed/minified file " + var10_14.getAbsolutePath());
                }
                if (!(!bl3 || (file3 = this.e) != null && file3.isFile() && (file2 = this.g) != null && file2.isFile() && (file = this.i) != null && file.isFile())) {
                    void var10_18;
                    throw new IOException("Inconsistencies in web resources: missing compressed/minified/GZip file " + (var10_18 != null ? var10_18.getAbsolutePath() : "Can't happen"));
                }
                if (bl3) {
                    this.a(arrayList, arrayList2, arrayList3, hashMap);
                }
                arrayList.add(this.d.getName());
                arrayList2.add(this.f.getName());
            } else if (bl3) {
                try {
                    string = TransformHTMLSource.getInstance().transform(HTMLSourceInfo.this.b, bl, true, false);
                    InfoFromSources.getInstance().getSources(string, new BufferedReader(new StringReader(string)), arrayList2, arrayList3, arrayList, hashMap);
                    this.a = this.a(arrayList);
                    this.b = this.a(arrayList2);
                    for (String string2 : arrayList) {
                        this.a((HashMap<File, Long>)((Object)this.a), string2);
                    }
                    for (String string3 : arrayList2) {
                        this.a((HashMap<File, Long>)((Object)this.b), string3);
                    }
                    for (String string4 : arrayList3) {
                        this.a(this.c, string4);
                    }
                    string = TransformHTMLSource.getInstance().transform(HTMLSourceInfo.this.b, bl, bl2, true);
                    if (!bl2) {
                        arrayList = new ArrayList();
                        arrayList2 = new ArrayList();
                        ArrayList<String> arrayList4 = new ArrayList<String>();
                        InfoFromSources.getInstance().getSources(HTMLSourceInfo.this.b.getAbsolutePath(), new BufferedReader(new StringReader(string)), arrayList2, arrayList4, arrayList, null);
                    }
                    string = Compressor.compressHTML(string);
                }
                catch (ParseException parseException) {
                    throw new IOException("Failed processing file " + HTMLSourceInfo.this.b.getAbsolutePath(), parseException);
                }
            }
            this.source = string;
            this.cssList = Collections.unmodifiableList(arrayList);
            this.jsList = Collections.unmodifiableList(arrayList2);
            this.amdList = Collections.unmodifiableList(arrayList3);
            this.settings = Collections.unmodifiableMap(hashMap);
        }

        synchronized void a() {
            File file = this.a;
            this.a = null;
            FileInputStream fileInputStream = this.a;
            this.a = null;
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (file != null && file.isFile() && !file.delete()) {
                file.deleteOnExit();
            }
            file = this.b;
            this.b = null;
            fileInputStream = this.b;
            this.b = null;
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (file != null && file.isFile() && !file.delete()) {
                file.deleteOnExit();
            }
            for (File file2 : this.d.values()) {
                if (!file2.isFile() || file2.delete()) continue;
                file2.deleteOnExit();
            }
            file = this.c;
            if (file != null && file.isFile() && !file.delete()) {
                file.deleteOnExit();
            }
        }

        private List<String> a(List<String> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                arrayList.add(string.indexOf(36) < 0 ? string : HTMLSourceInfo.this.a.resolveSourcePath(string).getPath());
            }
            return Collections.unmodifiableList(arrayList);
        }

        private void a(HashMap<File, Long> hashMap, String string) throws IOException {
            File file = HTMLSourceInfo.this.a.resolveSourcePath(string).getCanonicalFile();
            long l = file.lastModified();
            if (!file.exists() || l <= 0L) {
                throw new FileNotFoundException("File " + file.getAbsolutePath() + " is not found");
            }
            if (hashMap.putIfAbsent(file, l) != null) {
                throw new IOException("File " + file.getAbsolutePath() + " is added twice");
            }
        }

        private void a(FileInputStream fileInputStream, File file) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (file != null && file.isFile() && !file.delete()) {
                file.deleteOnExit();
            }
        }

        private void a(HashMap<File, Long> hashMap) throws FileNotFoundException {
            for (Map.Entry<File, Long> entry : hashMap.entrySet()) {
                File file = entry.getKey();
                long l = file.lastModified();
                if (l <= 0L) {
                    throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found anymore");
                }
                entry.setValue(l);
            }
        }

        private boolean a(HashMap<File, Long> hashMap) throws FileNotFoundException {
            for (Map.Entry entry : ((HashMap)((Object)this.a)).entrySet()) {
                File file = (File)entry.getKey();
                if (file.lastModified() == ((Long)entry.getValue()).longValue()) continue;
                if (InfoFromSources.a) {
                    System.err.println("File " + file.getAbsolutePath() + " has been modified");
                }
                this.a((HashMap<File, Long>)((Object)this.a));
                return true;
            }
            return false;
        }

        public synchronized File getMinifiedCSS() throws IOException {
            if (this.a) {
                return this.d;
            }
            if (this.isDevel) {
                throw new IOException("Configuration is Development and will not produce minified CSS");
            }
            File file = null;
            FileInputStream fileInputStream = null;
            boolean bl = this.a((HashMap<File, Long>)((Object)this.a));
            if (bl) {
                file = this.a;
                fileInputStream = this.a;
            }
            if (this.b == null || bl) {
                this.a = Compressor.getInstance(HTMLSourceInfo.this.a).invokeCSSCompressor(HTMLSourceInfo.this.b, this.a);
                this.a = new FileInputStream(this.a);
                HTMLSourceInfo.this.a.addFileRedirection(this.d.getName(), this.a);
            }
            this.a(fileInputStream, file);
            return this.a;
        }

        public synchronized File getCompressedJS() throws IOException {
            AbstractCollection abstractCollection;
            if (this.a) {
                return this.f;
            }
            if (this.isDevel) {
                throw new IOException("Configuration is Development and will not produce compressed JS");
            }
            File file = null;
            FileInputStream fileInputStream = null;
            boolean bl = this.a((HashMap<File, Long>)((Object)this.b));
            if (bl) {
                file = this.b;
                fileInputStream = this.b;
            }
            if (this.b == null || bl) {
                abstractCollection = new ArrayList<String>(this.b);
                ((ArrayList)abstractCollection).remove("iz/dojoenv.js");
                ((ArrayList)abstractCollection).remove("common/dojo.js");
                this.b = Compressor.getInstance(HTMLSourceInfo.this.a).invokeJSCompressor(HTMLSourceInfo.this.b, (List<String>)((Object)abstractCollection), Compressor.Level.SIMPLE);
                HTMLSourceInfo.this.a.addFileRedirection(this.f.getName(), this.b);
            }
            abstractCollection = new HashSet<File>(this.d.values());
            for (Map.Entry<File, Long> object : this.c.entrySet()) {
                Serializable serializable;
                File file2 = object.getKey();
                long l = file2.lastModified();
                if (l == object.getValue() && (serializable = this.d.get(HTMLSourceInfo.this.b)) != null && ((File)serializable).isFile()) {
                    ((HashSet)abstractCollection).remove(serializable);
                    continue;
                }
                serializable = new ArrayList<String>();
                ((ArrayList)serializable).add(file2.getAbsolutePath());
                File file3 = Compressor.getInstance(HTMLSourceInfo.this.a).invokeJSCompressor(file2, (List<String>)((Object)serializable), Compressor.Level.SIMPLE);
                object.setValue(l);
                this.d.put(file2, file3);
                HTMLSourceInfo.this.a.addFileRedirection(file2, file3);
            }
            for (File file4 : abstractCollection) {
                if (!file4.isFile() || file4.delete()) continue;
                file4.deleteOnExit();
            }
            this.a(fileInputStream, file);
            return this.b;
        }

        public File getCompressedHTML() throws IOException {
            if (this.a) {
                return this.h;
            }
            if (this.isDevel) {
                throw new IOException("Configuration is Development and will not produce compressed HTML");
            }
            if (this.source == null) {
                throw new IOException("HTML source is null");
            }
            if (this.c == null) {
                String string = this.h.getName();
                File file = File.createTempFile("iiziCompress", string);
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (FileWriter fileWriter = new FileWriter(file);){
                        fileWriter.write(this.source);
                        fileWriter.close();
                        this.c = file;
                        file = null;
                        HTMLSourceInfo.this.a.addFileRedirection(string, this.c);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.a(null, file);
                }
            }
            return this.c;
        }

        void a(boolean bl) throws IOException {
            PrintWriter printWriter;
            Path path;
            if (bl) {
                System.out.println(" - Minifying CSS");
            }
            File file = this.getMinifiedCSS();
            File file2 = this.d;
            File file3 = file;
            try {
                path = file.toPath();
                file3 = file2;
                Files.copy(path, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (InvalidPathException invalidPathException) {
                throw new IOException("Invalid path \"" + file3.getPath() + "\"", invalidPathException);
            }
            if (bl) {
                System.out.println(" - Creating CSS Gzip");
            }
            Utilities.createOrUpdateGzip((File)file2);
            if (bl) {
                System.out.println(" - Compressing JS");
            }
            file = this.getCompressedJS();
            file2 = this.f;
            file3 = file;
            try {
                path = file.toPath();
                file3 = file2;
                Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (InvalidPathException invalidPathException) {
                throw new IOException("Invalid path \"" + file3.getPath() + "\"", invalidPathException);
            }
            if (bl) {
                System.out.println(" - Creating JS Gzip");
            }
            Utilities.createOrUpdateGzip((File)file2);
            if (bl) {
                System.out.println(" - Compressed HTML");
            }
            file2 = this.h;
            if (this.source == null) {
                throw new IOException("HTML source is null: " + String.valueOf(file2));
            }
            Throwable throwable = null;
            Object var7_11 = null;
            try {
                printWriter = new PrintWriter(file2);
                try {
                    printWriter.println(this.source);
                }
                finally {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (bl) {
                System.out.println(" - Creating HTML Gzip");
            }
            Utilities.createOrUpdateGzip((File)file2);
            if (bl) {
                System.out.println(" - Writing AMD and settings information");
            }
            file2 = this.j;
            throwable = null;
            var7_11 = null;
            try {
                printWriter = new PrintWriter(file2);
                try {
                    printWriter.println("#CSS");
                    for (String object : this.cssList) {
                        printWriter.println(object);
                    }
                    printWriter.println();
                    printWriter.println("#JS");
                    for (String string : this.jsList) {
                        printWriter.println(string);
                    }
                    printWriter.println();
                    printWriter.println("#AMD");
                    for (String string : this.amdList) {
                        printWriter.println(string);
                    }
                    printWriter.println();
                    printWriter.println("#Settings");
                    for (Map.Entry entry : this.settings.entrySet()) {
                        printWriter.println((String)entry.getKey());
                        printWriter.println((String)entry.getValue());
                    }
                }
                finally {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }

        void b(boolean bl) throws IOException {
            if (!this.isDevel && !this.isLocal) {
                File file = HTMLSourceInfo.this.b;
                if (bl) {
                    System.out.println(" - Replacing original HTML with remote production version in " + String.valueOf(file));
                }
                Files.copy(this.h.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                file = new File(HTMLSourceInfo.this.b.getCanonicalPath() + ".gz");
                if (bl) {
                    System.out.println(" - Adding Gzip HTML file " + String.valueOf(file));
                }
                Files.copy(this.i.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }

        private void a(List<String> list, List<String> list2, List<String> list3, Map<String, String> map) throws IOException {
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.j));){
                String string = bufferedReader.readLine();
                if (string == null) {
                    throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " no CSS's found");
                }
                if (!string.trim().equals("#CSS")) {
                    throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " (#CSS not found)");
                }
                while (true) {
                    if ((string = bufferedReader.readLine()) == null) {
                        throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " no CSS's found");
                    }
                    if ((string = string.trim()).isEmpty()) break;
                    if (list.contains(string)) {
                        throw new IOException("CSS " + string + " is defined twice in " + String.valueOf(this.j));
                    }
                    list.add(string);
                }
                string = bufferedReader.readLine();
                if (string == null) {
                    throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " no JS's found");
                }
                if (!string.trim().equals("#JS")) {
                    throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " (#JS not found)");
                }
                while (true) {
                    if ((string = bufferedReader.readLine()) == null) {
                        throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " no JS's found");
                    }
                    if ((string = string.trim()).isEmpty()) break;
                    if (list2.contains(string)) {
                        throw new IOException("JavaScript source " + string + " is defined twice in " + String.valueOf(this.j));
                    }
                    list2.add(string);
                }
                string = bufferedReader.readLine();
                if (string == null) {
                    throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " no AMD's found");
                }
                if (!string.trim().equals("#AMD")) {
                    throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " (#AMD not found)");
                }
                while (true) {
                    if ((string = bufferedReader.readLine()) == null) {
                        throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " no AMD's found");
                    }
                    if ((string = string.trim()).isEmpty()) break;
                    if (list3.contains(string)) {
                        throw new IOException("JavaScript AMD source " + string + " is defined twice in " + String.valueOf(this.j));
                    }
                    list3.add(string);
                }
                string = bufferedReader.readLine();
                if (!string.trim().equals("#Settings")) {
                    throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " (#Settings not found)");
                }
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.isEmpty()) {
                        break;
                    }
                    String string2 = bufferedReader.readLine();
                    if (string2 == null) {
                        throw new EOFException("Invalid file format in " + HTMLSourceInfo.this.b.getAbsolutePath() + " (missing value setting)");
                    }
                    String string3 = map.put(string, string2);
                    if (string3 == null) continue;
                    throw new IOException("Setting " + string + " = \"" + string2 + "\" is defined twice (old = \"" + string3 + "\") in " + String.valueOf(this.j));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        void c(boolean bl) throws IOException {
            this.a(this.d, this.e, "Minified CSS", bl);
            this.a(this.f, this.g, "Compressed JS", bl);
            this.a(this.h, this.i, "Compressed HTML", bl);
            this.a(this.d, this.e, "Minified CSS", bl);
            this.a(this.j, null, "Files listing and settings", bl);
        }

        private void a(File file, File file2, String string, boolean bl) throws IOException {
            boolean bl2;
            if (file.exists()) {
                bl2 = file.delete();
                if (bl) {
                    System.out.println(" - " + string + ": delete --> " + String.valueOf(file) + " --> OK = " + bl2);
                }
                if (!bl2) {
                    System.err.println("Failed deleting file " + file.getCanonicalPath());
                }
            }
            if (file2 != null && file2.exists()) {
                bl2 = file2.delete();
                if (bl) {
                    System.out.println(" - " + string + ": delete --> " + String.valueOf(file2) + " --> OK = " + bl2);
                }
                if (!bl2) {
                    System.err.println("Failed deleting file " + file2.getCanonicalPath());
                }
            }
        }
    }
}

