/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.translate;

import com.iizix.ILog;
import com.iizix.text.KString;
import com.iizix.translate.ITranslationReply;
import com.iizix.translate.ITranslator;
import com.iizix.translate.RequestException;
import com.iizix.translate.Translation;
import com.iizix.translate.TranslationException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TranslationQueue {
    protected final String sourceLanguageCode;
    protected final String targetLanguageCode;
    protected final String sourceLanguageDescription;
    protected final String targetLanguageDescription;
    protected final ITranslator translator;
    private final LinkedHashMap<KString, LinkedHashSet<ITranslationReply>> a;
    private long a;
    private boolean a = new LinkedHashMap();

    protected TranslationQueue(String string, String string2, ITranslator iTranslator) {
        this.sourceLanguageCode = string;
        this.targetLanguageCode = string2;
        this.translator = iTranslator;
        this.sourceLanguageDescription = string != null ? iTranslator.getLanguageDescription(string) : "<auto-detect>";
        this.targetLanguageDescription = iTranslator.getLanguageDescription(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addRequest(KString kString, ITranslationReply iTranslationReply) {
        LinkedHashMap<KString, LinkedHashSet<ITranslationReply>> linkedHashMap = this.a;
        synchronized (linkedHashMap) {
            LinkedHashSet<ITranslationReply> linkedHashSet;
            block4: {
                linkedHashSet = this.a.get(kString);
                if (linkedHashSet == null) break block4;
                linkedHashSet.add(iTranslationReply);
                return false;
            }
            linkedHashSet = new LinkedHashSet();
            linkedHashSet.add(iTranslationReply);
            this.a.put(kString, linkedHashSet);
            this.scheduleJobInstance();
            return true;
        }
    }

    protected void scheduleJobInstance() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KString getNext() {
        LinkedHashMap<KString, LinkedHashSet<ITranslationReply>> linkedHashMap = this.a;
        synchronized (linkedHashMap) {
            block4: {
                if (!this.a.isEmpty()) break block4;
                this.clearJobInstance();
                return null;
            }
            return this.a.keySet().iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KString[] getAll() {
        LinkedHashMap<KString, LinkedHashSet<ITranslationReply>> linkedHashMap = this.a;
        synchronized (linkedHashMap) {
            block4: {
                if (!this.a.isEmpty()) break block4;
                this.clearJobInstance();
                return null;
            }
            return this.a.keySet().toArray(new KString[this.a.size()]);
        }
    }

    protected void clearJobInstance() {
    }

    protected void cancelJob() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        LinkedHashMap<KString, LinkedHashSet<ITranslationReply>> linkedHashMap = this.a;
        synchronized (linkedHashMap) {
            this.a = true;
            this.a.clear();
            this.cancelJob();
        }
    }

    protected boolean isCanceled() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getQueueElementCount() {
        LinkedHashMap<KString, LinkedHashSet<ITranslationReply>> linkedHashMap = this.a;
        synchronized (linkedHashMap) {
            return this.a.size();
        }
    }

    protected boolean processQueuedElement() {
        Translation translation;
        KString kString = this.getNext();
        if (kString == null) {
            return false;
        }
        try {
            translation = this.translator.translate(kString, this.sourceLanguageCode, this.targetLanguageCode);
        }
        catch (RequestException | TranslationException exception) {
            ILog.SEVERE(this.getClass(), "Translator failed: " + exception.getMessage(), "sourceText " + String.valueOf(kString), "sourceLanguageCode = " + this.sourceLanguageCode, "targetLanguageCode = " + this.targetLanguageCode);
            translation = new Translation(this.translator, kString, kString.getRawString(), this.sourceLanguageCode, this.targetLanguageCode, exception);
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), "Translator failed", "sourceText " + String.valueOf(kString), "sourceLanguageCode = " + this.sourceLanguageCode, "targetLanguageCode = " + this.targetLanguageCode, throwable);
            translation = new Translation(this.translator, kString, kString.getRawString(), this.sourceLanguageCode, this.targetLanguageCode, throwable);
        }
        this.onCompleted(kString, translation);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompleted(KString kString, Translation translation) {
        LinkedHashSet linkedHashSet;
        Object object2 = this.a;
        synchronized (object2) {
            linkedHashSet = (LinkedHashSet)this.a.remove(kString);
        }
        if (linkedHashSet == null) {
            if (!this.a) {
                ILog.SEVERE(this.getClass(), "Could not find sourceText", (Object)translation);
            }
            return;
        }
        for (Object object2 : linkedHashSet) {
            try {
                object2.onTranslationReply(translation);
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), "Failed invoking reply callback", translation, throwable);
            }
        }
        ++this.a;
    }

    public long getTranslatedCount() {
        return this.a;
    }

    public void deconfigure() {
        this.translator.deconfigure();
    }
}

