/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.text.util;

import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class BuildHTMLCharacterEntities {
    public static void main(String[] stringArray) {
        System.out.println("Creating com.iizix.text.HTMLCharacterEntities.java...");
        System.out.println("Note: quite slow loading of entity files, be patient...");
        try {
            LinkedHashMap<String, Integer> linkedHashMap = BuildHTMLCharacterEntities.a("http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent");
            linkedHashMap.putAll(BuildHTMLCharacterEntities.a("http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent"));
            linkedHashMap.putAll(BuildHTMLCharacterEntities.a("http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent"));
            PrintWriter printWriter = new PrintWriter(new FileWriter("../HTMLCharacterEntities.java"));
            printWriter.println("package com.iizix.text;");
            printWriter.println();
            printWriter.println("import java.util.HashMap;");
            printWriter.println();
            printWriter.println("/**");
            printWriter.println(" * Table for HTML character entities.");
            printWriter.println(" *");
            printWriter.println(" * <p>Built on " + String.valueOf(new Date()) + " by " + System.getProperty("user.name", "unknown") + " from:");
            printWriter.println(" * <br> - http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent");
            printWriter.println(" * <br> - http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent");
            printWriter.println(" * <br> - http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent");
            printWriter.println(" *");
            printWriter.println(" * @author com.iizix.text.util.BuildHTMLCharacterEntities");
            printWriter.println(" */");
            printWriter.println("public class HTMLCharacterEntities");
            printWriter.println("{");
            printWriter.println("  /**");
            printWriter.println("   * Table to build the character entities map.");
            printWriter.println("   */");
            printWriter.println("  private static final Object [] table =");
            printWriter.println("    {");
            int n2 = 0;
            for (String object : linkedHashMap.keySet()) {
                n2 = Math.max(n2, object.length());
            }
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                printWriter.println("    \"" + String.valueOf(((String)entry.getKey() + "\"                           ").subSequence(0, n2 + 1)) + ", " + String.valueOf(entry.getValue()) + ",");
            }
            printWriter.println("    };");
            printWriter.println();
            printWriter.println("  /**");
            printWriter.println("   * Character entity map from string to character.");
            printWriter.println("   */");
            printWriter.println("  private static final HashMap<String,Character>stringToChar = new HashMap<>(128);");
            printWriter.println();
            printWriter.println("  /**");
            printWriter.println("   * Character entity map from character to string.");
            printWriter.println("   */");
            printWriter.println("  private static final HashMap<Character,String>charToString = new HashMap<>(128);");
            printWriter.println();
            printWriter.println("  /**");
            printWriter.println("   * Constructs the maps.");
            printWriter.println("   */");
            printWriter.println("  static");
            printWriter.println("    {");
            printWriter.println("    for ( int ii=0; ii<table.length; )");
            printWriter.println("      {");
            printWriter.println("      String s=(String)table[ii++];");
            printWriter.println("      int v=(Integer)table[ii++];");
            printWriter.println("      char ch=(char)v;");
            printWriter.println("      stringToChar.put(s,ch);");
            printWriter.println("      charToString.put(ch,s);");
            printWriter.println("      }");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("  /**");
            printWriter.println("   * Maps a String character entity to a char. The string should only contain the actual text,");
            printWriter.println("   * not the surrounding \"&amp;...;\" decoration.");
            printWriter.println("   *");
            printWriter.println("   * @param string  The string without decorations, case sensitive.");
            printWriter.println("   *");
            printWriter.println("   * @return The character corresponding with the entity string, null ('\u0000') character otherwise.");
            printWriter.println("   */");
            printWriter.println("  public static final char getChar(String string)");
            printWriter.println("    {");
            printWriter.println("    Character ch=stringToChar.get(string);");
            printWriter.println("    return ch!=null? ch: '\u0000';");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("  /**");
            printWriter.println("   * Maps a char value to a String character entity.");
            printWriter.println("   *");
            printWriter.println("   * @param ch  The character to map.");
            printWriter.println("   *");
            printWriter.println("   * @return  The String character entity for the character, null if not found.");
            printWriter.println("   */");
            printWriter.println("  public static final String getString(char ch)");
            printWriter.println("    {");
            printWriter.println("    return charToString.get(ch);");
            printWriter.println("    }");
            printWriter.println("}");
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println("\nERROR: " + String.valueOf(exception));
        }
    }

    private static LinkedHashMap<String, Integer> a(String string) throws Exception {
        int n2;
        System.out.println(" - loading " + string);
        StringBuilder stringBuilder = new StringBuilder();
        Object object = null;
        LinkedHashMap<String, Integer> linkedHashMap = null;
        try (InputStream inputStream = new URI(string).toURL().openStream();){
            while ((n2 = inputStream.read()) >= 0) {
                if (n2 == 13 || n2 == 10) continue;
                stringBuilder.append((char)n2);
            }
            inputStream.close();
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        object = stringBuilder.toString();
        linkedHashMap = new LinkedHashMap<String, Integer>();
        int n3 = 0;
        while ((n2 = ((String)object).indexOf("<!ENTITY", n3)) >= 0) {
            int n4;
            int n5 = ((String)object).indexOf("<!--", n3);
            if (n5 >= 0 && n5 < n2) {
                if ((n3 = ((String)object).indexOf("-->", n3)) < 0) {
                    throw new Exception("Comment end not found");
                }
                n3 += 3;
                continue;
            }
            n3 = n2;
            int n6 = ((String)object).indexOf(62, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(((String)object).substring(n3, n6), " \t");
            n3 = n6 + 1;
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("amp")) {
                n4 = 38;
            } else if (string2.equals("lt")) {
                n4 = 60;
            } else {
                String string3 = stringTokenizer.nextToken();
                if (!string3.startsWith("\"&#") || !string3.endsWith(";\"")) {
                    throw new Exception("Unknown quoted value format");
                }
                n4 = Integer.parseInt(string3.substring(3, string3.length() - 2));
            }
            linkedHashMap.put(string2, n4);
            System.out.println("    " + string2 + "\t" + n4);
        }
        return linkedHashMap;
    }
}

