/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.text;

import com.iizix.ILog;
import com.iizix.event.RemoteEvent;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.text.IKStringHTMLHyperlinkEvent;
import com.iizix.text.KStringHTMLHyperlinkUITag;
import com.iizix.text.KStringHTMLHyperlinkVSTag;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public enum IKStringHyperlinkType {
    UI(KStringHTMLHyperlinkUITag.a),
    VS(KStringHTMLHyperlinkVSTag.a),
    Resource(null),
    External(null);

    private IKStringHTMLHyperlinkEvent a;

    private IKStringHyperlinkType(IKStringHTMLHyperlinkEvent iKStringHTMLHyperlinkEvent) {
        this.a = iKStringHTMLHyperlinkEvent;
    }

    public static void processHyperlink(GProp<?> gProp, RemoteEvent remoteEvent) {
        IClientSessionGyro iClientSessionGyro = gProp.getClientSessionGyro();
        if (iClientSessionGyro == null) {
            ILog.SEVERE(KStringHTMLHyperlinkVSTag.class, "Failed looking up Client Session Gyro for a KString hyperlink", (Object)("Event = " + String.valueOf(remoteEvent)));
            return;
        }
        boolean bl = true;
        try {
            PropCnr propCnr = remoteEvent.getParameters();
            int n2 = propCnr.getInt("t", -1);
            if (n2 < 0 || n2 > 3) {
                ILog.SEVERE(IKStringHyperlinkType.class, "Invalid KString hyperlink type: " + n2, (Object)("Event = " + String.valueOf(remoteEvent)));
            } else {
                String string = propCnr.getString("r");
                if (string == null) {
                    ILog.SEVERE(IKStringHyperlinkType.class, "Invalid hyperlink reference for: " + n2, (Object)("Event = " + String.valueOf(remoteEvent)));
                } else {
                    IKStringHTMLHyperlinkEvent iKStringHTMLHyperlinkEvent = IKStringHyperlinkType.values()[n2].a;
                    if (iKStringHTMLHyperlinkEvent != null) {
                        bl = iKStringHTMLHyperlinkEvent.onActivated(iClientSessionGyro, gProp, remoteEvent, string);
                    }
                }
            }
        }
        finally {
            if (bl) {
                iClientSessionGyro.exitClientLock();
            }
        }
    }
}

