/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.gyro;

import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.IPropCnr;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropException;

public interface IUIPanelAnimation
extends IPropCnr {
    public static final String ANIMATION_PROP_NAME = "animation";
    public static final int ANIMATION_NO_CSS3_FLAG = 0x800000;
    public static final int ANIMATION_NO_SCROLL_FLAG = 0x1000000;
    public static final int ANIMATION_DEFAULT = -1;
    public static final int ANIMATION_NONE = 0;
    public static final int ANIMATION_FADE_FAST = 1;
    public static final int ANIMATION_FADE_NORMAL = 10;
    public static final int ANIMATION_FADE_SLOW = 100;
    public static final int ANIMATION_FADE_SLOWER = 1000;
    public static final int ANIMATION_FADE_SLOWEST = 10000;
    public static final int ANIMATION_TYPE_NONE = 0;
    public static final int ANIMATION_TYPE_FADE = 1;
    public static final int ANIMATION_TYPE_SLIDE = 2;
    public static final int ANIMATION_TYPE_COVER = 3;
    public static final int ANIMATION_TYPE_REVEAL = 4;
    public static final int ANIMATION_SPEED_FAST = 1;
    public static final int ANIMATION_SPEED_NORMAL = 10;
    public static final int ANIMATION_SPEED_SLOW = 100;
    public static final int ANIMATION_SPEED_SLOWER = 1000;
    public static final int ANIMATION_SPEED_SLOWEST = 10000;
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$iizix$gyro$IUIPanelAnimation$Type;

    static {
        $SWITCH_TABLE$com$iizix$gyro$IUIPanelAnimation$Type = IUIPanelAnimation.$SWITCH_TABLE$com$iizix$gyro$IUIPanelAnimation$Type();
    }

    public static int getAnimationValue(Type type, Direction direction, Speed speed) {
        switch (type) {
            case NONE: {
                return 0;
            }
            case FADE: {
                return speed.speed;
            }
            case SLIDE: {
                return 11 * direction.direction * speed.speed;
            }
            case COVER: {
                return direction.direction * speed.speed;
            }
            case REVEAL: {
                return (10 + direction.direction) * speed.speed;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + String.valueOf((Object)type));
    }

    public static int getAnimationValue(int n2, int n3, int n4) {
        if (n2 >= 1 && n4 != 1 && n4 != 10 && n4 != 100 && n4 != 1000 && n4 != 10000) {
            throw new IllegalArgumentException("Invalid speed: " + n4);
        }
        if (n2 >= 2 && n3 != 2 && n3 != 4 && n3 != 6 && n3 != 8) {
            throw new IllegalArgumentException("Invalid speed: " + n4);
        }
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return n4;
            }
            case 2: {
                return 11 * n3 * n4;
            }
            case 3: {
                return n3 * n4;
            }
            case 4: {
                return (10 + n3) * n4;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + n2);
    }

    public static int getOppositeAnimation(int n2) {
        int n3 = n2;
        switch (n2 & 0xFE7FFFFF) {
            case -1: 
            case 0: 
            case 1: 
            case 10: 
            case 100: 
            case 1000: 
            case 10000: {
                return n2;
            }
            case 66: {
                n3 = 44;
                break;
            }
            case 660: {
                n3 = 440;
                break;
            }
            case 6600: {
                n3 = 4400;
                break;
            }
            case 66000: {
                n3 = 44000;
                break;
            }
            case 660000: {
                n3 = 440000;
                break;
            }
            case 44: {
                n3 = 66;
                break;
            }
            case 440: {
                n3 = 660;
                break;
            }
            case 4400: {
                n3 = 6600;
                break;
            }
            case 44000: {
                n3 = 66000;
                break;
            }
            case 440000: {
                n3 = 660000;
                break;
            }
            case 22: {
                n3 = 88;
                break;
            }
            case 220: {
                n3 = 880;
                break;
            }
            case 2200: {
                n3 = 8800;
                break;
            }
            case 22000: {
                n3 = 88000;
                break;
            }
            case 220000: {
                n3 = 880000;
                break;
            }
            case 88: {
                n3 = 22;
                break;
            }
            case 880: {
                n3 = 220;
                break;
            }
            case 8800: {
                n3 = 2200;
                break;
            }
            case 88000: {
                n3 = 22000;
                break;
            }
            case 880000: {
                n3 = 220000;
                break;
            }
            case 6: {
                n3 = 14;
                break;
            }
            case 60: {
                n3 = 140;
                break;
            }
            case 600: {
                n3 = 1400;
                break;
            }
            case 6000: {
                n3 = 14000;
                break;
            }
            case 60000: {
                n3 = 140000;
                break;
            }
            case 4: {
                n3 = 16;
                break;
            }
            case 40: {
                n3 = 160;
                break;
            }
            case 400: {
                n3 = 1600;
                break;
            }
            case 4000: {
                n3 = 16000;
                break;
            }
            case 40000: {
                n3 = 160000;
                break;
            }
            case 2: {
                n3 = 18;
                break;
            }
            case 20: {
                n3 = 180;
                break;
            }
            case 200: {
                n3 = 1800;
                break;
            }
            case 2000: {
                n3 = 18000;
                break;
            }
            case 20000: {
                n3 = 180000;
                break;
            }
            case 8: {
                n3 = 12;
                break;
            }
            case 80: {
                n3 = 120;
                break;
            }
            case 800: {
                n3 = 1200;
                break;
            }
            case 8000: {
                n3 = 12000;
                break;
            }
            case 80000: {
                n3 = 120000;
                break;
            }
            case 16: {
                n3 = 4;
                break;
            }
            case 160: {
                n3 = 40;
                break;
            }
            case 1600: {
                n3 = 400;
                break;
            }
            case 16000: {
                n3 = 4000;
                break;
            }
            case 160000: {
                n3 = 40000;
                break;
            }
            case 14: {
                n3 = 6;
                break;
            }
            case 140: {
                n3 = 60;
                break;
            }
            case 1400: {
                n3 = 600;
                break;
            }
            case 14000: {
                n3 = 6000;
                break;
            }
            case 140000: {
                n3 = 60000;
                break;
            }
            case 12: {
                n3 = 8;
                break;
            }
            case 120: {
                n3 = 80;
                break;
            }
            case 1200: {
                n3 = 800;
                break;
            }
            case 12000: {
                n3 = 8000;
                break;
            }
            case 120000: {
                n3 = 80000;
                break;
            }
            case 18: {
                n3 = 2;
                break;
            }
            case 180: {
                n3 = 20;
                break;
            }
            case 1800: {
                n3 = 200;
                break;
            }
            case 18000: {
                n3 = 2000;
                break;
            }
            case 180000: {
                n3 = 20000;
                break;
            }
            default: {
                return -1;
            }
        }
        return n3 | n2 & 0x1800000;
    }

    default public boolean setAnimation(int n2) {
        try {
            if (n2 == -1) {
                return this.removeProp(ANIMATION_PROP_NAME);
            }
            IntProp intProp = this.getProp(ANIMATION_PROP_NAME, IntProp.class);
            if (intProp != null) {
                intProp.setPropPrivate(this.isAnimationPropPrivate());
                return intProp.setPropValue(n2);
            }
            intProp = new IntProp(Atom.get(ANIMATION_PROP_NAME), n2);
            if (this.isAnimationPropPrivate()) {
                intProp.setPropPrivate(true);
            }
            return this.setProp(intProp);
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), "Failed setAnimation", propException);
            return false;
        }
    }

    public boolean isAnimationPropPrivate();

    default public boolean setAnimation(Type type, Direction direction, Speed speed) {
        return this.setAnimation(IUIPanelAnimation.getAnimationValue(type.ordinal(), direction.direction, speed.speed));
    }

    default public int getAnimation() {
        return this.getInt(ANIMATION_PROP_NAME, -1);
    }

    default public int getAnimation(int n2) {
        return this.getInt(ANIMATION_PROP_NAME, n2);
    }

    default public Type getAnimationType() {
        return Type.fromCompositeValue(this.getAnimation());
    }

    default public Direction getAnimationDirection() {
        return Direction.fromCompositeValue(this.getAnimation());
    }

    default public Speed getAnimationSpeed() {
        return Speed.fromCompositeValue(this.getAnimation());
    }

    default public String getAnimationDescription() {
        return IUIPanelAnimation.getAnimationDescription(this.getAnimation());
    }

    public static String getAnimationDescription(int n2) {
        Type type = Type.fromCompositeValue(n2);
        if (type == Type.NONE) {
            return type.toString();
        }
        Direction direction = Direction.fromCompositeValue(n2);
        Speed speed = Speed.fromCompositeValue(n2);
        return type.toString() + " " + String.valueOf((Object)direction) + " " + String.valueOf((Object)speed);
    }

    public static enum Direction {
        LEFT(4, "Left"),
        RIGHT(6, "Right"),
        UP(8, "Up"),
        DOWN(2, "Down");

        public final int direction;
        public final String description;

        private Direction(int n3, String string2) {
            this.direction = n3;
            this.description = string2;
        }

        public static Direction fromCompositeValue(int n2) {
            int n3 = n2 & 0xFE7FFFFF;
            String string = Integer.toString(n3);
            if (string.indexOf(56) >= 0) {
                return UP;
            }
            if (string.indexOf(50) >= 0) {
                return DOWN;
            }
            if (string.indexOf(52) >= 0) {
                return LEFT;
            }
            return RIGHT;
        }
    }

    public static enum Speed {
        FAST(1, "Fast (100 ms)"),
        NORMAL(10, "Normal (350 ms)"),
        SLOW(100, "Slow (600ms)"),
        SLOWER(1000, "Slower (1 second)"),
        SLOWEST(10000, "Slowest (10 seconds)");

        public final int speed;
        public final String description;

        private Speed(int n3, String string2) {
            this.speed = n3;
            this.description = string2;
        }

        public static Speed fromCompositeValue(int n2) {
            int n3 = n2 & 0xFE7FFFFF;
            switch (n3) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 22: 
                case 44: 
                case 66: 
                case 88: {
                    return FAST;
                }
                case 10: 
                case 20: 
                case 40: 
                case 60: 
                case 80: 
                case 120: 
                case 140: 
                case 160: 
                case 180: 
                case 220: 
                case 440: 
                case 660: 
                case 880: {
                    return NORMAL;
                }
                case 100: 
                case 200: 
                case 400: 
                case 600: 
                case 800: 
                case 1200: 
                case 1400: 
                case 1600: 
                case 1800: 
                case 2200: 
                case 4400: 
                case 6600: 
                case 8800: {
                    return SLOW;
                }
                case 1000: 
                case 2000: 
                case 4000: 
                case 6000: 
                case 8000: 
                case 12000: 
                case 14000: 
                case 16000: 
                case 18000: 
                case 22000: 
                case 44000: 
                case 66000: 
                case 88000: {
                    return SLOWER;
                }
                case 10000: 
                case 20000: 
                case 40000: 
                case 60000: 
                case 80000: 
                case 120000: 
                case 140000: 
                case 160000: 
                case 180000: 
                case 220000: 
                case 440000: 
                case 660000: 
                case 880000: {
                    return SLOWEST;
                }
            }
            return NORMAL;
        }
    }

    public static enum Type {
        NONE("None"),
        FADE("Fade"),
        SLIDE("Slide"),
        COVER("Cover"),
        REVEAL("Reveal");

        public final String description;

        private Type(String string2) {
            this.description = string2;
        }

        public static Type fromCompositeValue(int n2) {
            int n3 = n2 & 0xFE7FFFFF;
            switch (n3) {
                case 1: 
                case 10: 
                case 100: 
                case 1000: 
                case 10000: {
                    return FADE;
                }
                case 22: 
                case 44: 
                case 66: 
                case 88: 
                case 220: 
                case 440: 
                case 660: 
                case 880: 
                case 2200: 
                case 4400: 
                case 6600: 
                case 8800: 
                case 22000: 
                case 44000: 
                case 66000: 
                case 88000: 
                case 220000: 
                case 440000: 
                case 660000: 
                case 880000: {
                    return SLIDE;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 20: 
                case 40: 
                case 60: 
                case 80: 
                case 200: 
                case 400: 
                case 600: 
                case 800: 
                case 2000: 
                case 4000: 
                case 6000: 
                case 8000: 
                case 20000: 
                case 40000: 
                case 60000: 
                case 80000: {
                    return COVER;
                }
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 120: 
                case 140: 
                case 160: 
                case 180: 
                case 1200: 
                case 1400: 
                case 1600: 
                case 1800: 
                case 12000: 
                case 14000: 
                case 16000: 
                case 18000: 
                case 120000: 
                case 140000: 
                case 160000: 
                case 180000: {
                    return REVEAL;
                }
            }
            return NONE;
        }
    }
}

