/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.event;

import com.iizix.ILog;
import com.iizix.event.BubbleEvent;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropMgr;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RemoteEvent
extends BubbleEvent {
    private final int a;
    private PropCnr a;
    private PropMgr a;

    public RemoteEvent(GProp<?> gProp, int n2, PropCnr propCnr) {
        super(gProp, 99, false);
        if (n2 < 0 || n2 > 0x3FFFFFFF) {
            throw new IllegalArgumentException("localID 0-0x3FFFFFFF");
        }
        this.a = n2;
        this.a = propCnr;
    }

    public RemoteEvent(GProp<?> gProp, int n2, PropCnr propCnr, PropMgr propMgr) {
        super(gProp, 99, true);
        if (propMgr == null) {
            throw new IllegalArgumentException("originator not valid");
        }
        this.a = n2;
        this.a = propCnr;
        this.a = propMgr;
    }

    public int getLocalID() {
        return this.a;
    }

    public PropCnr getParameters() {
        return this.a;
    }

    public PropMgr getOriginator() {
        return this.a;
    }

    @Override
    protected StringBuilder paramString(StringBuilder stringBuilder) {
        stringBuilder = super.paramString(stringBuilder).append(",localID=").append(this.a);
        if (this.a != null) {
            stringBuilder.append(",params=[").append(this.a).append(']');
        }
        return stringBuilder;
    }

    public void retarget(GProp<?> gProp) {
        RemoteEvent remoteEvent = new RemoteEvent(gProp, this.a, this.a, this.a);
        gProp.onEvent(remoteEvent);
    }

    public void retarget(GProp<?> gProp, PropMgr propMgr) {
        if (!propMgr.isServer()) {
            ILog.WARNING(this.getClass(), "Target PropMgr is not of Server type for remote event", (Object)this);
        } else {
            RemoteEvent remoteEvent = new RemoteEvent(gProp, this.a, this.a);
            if (this.a != null) {
                try {
                    remoteEvent.a = this.a.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    remoteEvent.a = this.a;
                    ILog.SEVERE(this.getClass(), "Failed cloning the Remote Event parameters", cloneNotSupportedException);
                }
            }
            propMgr.queueRemoteEvent(remoteEvent);
        }
    }
}

