/*
 * Decompiled with CFR 0.152.
 */
package com.iizix;

import com.iizix.Messages;
import com.iizix.s;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtilities {
    public static final String XML_FILE_ENCODING = "UTF-8";
    private static final ErrorHandler a = new s();

    public static DocumentBuilder newDocumentBuilderWithoutSchema() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(a);
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InternalError("XML parser error", parserConfigurationException);
        }
    }

    private static Transformer a() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 2);
        Transformer transformer = transformerFactory.newTransformer();
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        transformer.setOutputProperty("encoding", XML_FILE_ENCODING);
        transformer.setOutputProperty("indent", "yes");
        return transformer;
    }

    public static Document createDocument() {
        return XMLUtilities.newDocumentBuilderWithoutSchema().newDocument();
    }

    public static Transformer createLoader(URL uRL) throws IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());){
                Templates templates = transformerFactory.newTemplates(new StreamSource(bufferedInputStream));
                return templates.newTransformer();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException("Failed creation of transformer", transformerConfigurationException);
        }
    }

    public static Document loadXMLDocument(String string) throws IOException, SAXException {
        return XMLUtilities.newDocumentBuilderWithoutSchema().parse(new InputSource(new StringReader(string)));
    }

    public static Document loadXMLDocument(File file) throws IOException, SAXException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            return XMLUtilities.loadXMLDocument(fileInputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Document loadXMLDocument(URL uRL) throws IOException, SAXException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = uRL.openStream();){
            return XMLUtilities.loadXMLDocument(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Document loadXMLDocument(InputStream inputStream) throws IOException, SAXException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            DocumentBuilder documentBuilder = XMLUtilities.newDocumentBuilderWithoutSchema();
            return documentBuilder.parse(inputStream);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new IOException(Messages.getString("XMLUtilities.factory.exception", factoryConfigurationError));
        }
    }

    public static String getXMLDocument(Document document) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        XMLUtilities.a().transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public static String getNodeString(Node node) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        XMLUtilities.a().transform(new DOMSource(node), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveXMLDocument(Document document, File file) throws IOException, TransformerException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, XML_FILE_ENCODING));){
                    XMLUtilities.saveXMLDocument(document, bufferedWriter);
                    bufferedWriter.close();
                }
                if (fileOutputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void saveXMLDocument(Document document, OutputStream outputStream) throws IOException, TransformerException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, XML_FILE_ENCODING));){
            XMLUtilities.saveXMLDocument(document, bufferedWriter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void saveXMLDocument(Document document, Writer writer) throws IOException, TransformerException {
        XMLUtilities.a().transform(new DOMSource(document), new StreamResult(writer));
    }

    public static void list(Document document) {
        System.out.println(Messages.getString("XMLUtilities.document.list", document.getDocumentURI()));
        XMLUtilities.list(document.getDocumentElement(), 1);
    }

    public static void list(Node node, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            System.out.print("  ");
            ++n3;
        }
        Object object = ": ";
        String string = node.getPrefix();
        if (string != null) {
            object = (String)object + "[" + string + "]:";
        }
        object = (String)object + node.getNodeName();
        if (!(node instanceof Element)) {
            System.out.println("Node" + (String)object + " \"" + node.getNodeValue() + "\" '" + node.getTextContent() + "' isText=" + (node.getNodeType() == 3));
            return;
        }
        object = "Element" + (String)object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n4 = 0;
        int n5 = namedNodeMap.getLength();
        while (n4 < n5) {
            Node node2 = namedNodeMap.item(n4);
            Object object2 = node2.getPrefix();
            object2 = object2 == null ? "" : "[" + (String)object2 + "]:";
            object = (String)object + " <" + (String)object2 + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\" '" + node.getTextContent() + "'>";
            ++n4;
        }
        System.out.println((String)object);
        node = node.getFirstChild();
        while (node != null) {
            XMLUtilities.list(node, n2 + 1);
            node = node.getNextSibling();
        }
    }

    public static String getAttributeString(Node node, String string) {
        return XMLUtilities.getAttributeString(node.getAttributes(), string);
    }

    public static String getAttributeString(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public static String getAttributeString(Node node, String string, String string2) {
        return XMLUtilities.getAttributeString(node.getAttributes(), string, string2);
    }

    public static String getAttributeString(NamedNodeMap namedNodeMap, String string, String string2) {
        String string3 = XMLUtilities.getAttributeString(namedNodeMap, string);
        return string3 != null ? string3 : string2;
    }

    public static Element getFirstElement(Element element, String string) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && node.getNodeName().equals(string)) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }
}

