/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.font.prop;

import com.iizigo.ApplicationUI;
import com.iizigo.font.prop.EditorFontFile;
import com.iizigo.font.prop.FontDesignerProp;
import com.iizigo.font.prop.IEditorFont;
import com.iizigo.font.prop.b;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizigo.webserver.InternalWebServer;
import com.iizix.ILog;
import com.iizix.SystemConfig;
import com.iizix.event.GEvent;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import com.iizix.prop.font.BrowserFontFormat;
import com.iizix.prop.font.FontFile;
import com.iizix.prop.font.FontFiles;
import com.iizix.prop.font.FontFormat;
import com.iizix.swt.SWTHelper;
import com.iizix.text.HTMLUtilities;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EditorFontFiles
extends FontFiles
implements IEditorFont,
IPropDesigner {
    private FontDesignerProp a;
    private String a;
    private static final List<TooltipItem> a;
    private final Class<?>[] a = new FontDesignerProp((PropCnr)this);

    static {
        a = List.of(TooltipItem.HEADER_IMAGE_DESCR_TYPE, TooltipItem.SEPARATOR, TooltipItem.newNormal("Font family", Atom.NAME), TooltipItem.newNormal("Description", Atom.DESCR), TooltipItem.newIntIndex("Cache on client", Atom.CACHE, CACHES), TooltipItem.newNormal("Local font name(s)", "local"), TooltipItem.SPACER_4PX, TooltipItem.newIntIndex("Font style", Atom.STYLE, STYLES), TooltipItem.newIntIndex("Font weight", Atom.WEIGHT, WEIGHTS_DESCR), TooltipItem.newNormal("Unicode range", Atom.RANGE), TooltipItem.newNormal("Additional styles", "add"));
    }

    public EditorFontFiles() {
    }

    public EditorFontFiles(Atom atom) {
        super(atom);
    }

    @Override
    public Image getCNImage() {
        return ApplicationUI.getInstance().imageFontFiles;
    }

    @Override
    public String getCNType() {
        return "Font files";
    }

    @Override
    public String getCNText() {
        return this.getFontFamily();
    }

    @Override
    public FontDesignerProp getDesigner() {
        return this.a;
    }

    public void onEventSelf(GEvent gEvent) {
        if (gEvent.isClearCacheEvent()) {
            this.a = null;
        }
        super.onEventSelf(gEvent);
    }

    public EditorFontFiles clone() {
        EditorFontFiles editorFontFiles = (EditorFontFiles)super.clone();
        editorFontFiles.a = new FontDesignerProp((PropCnr)editorFontFiles);
        return editorFontFiles;
    }

    public EditorFontFile[] getFontFiles() {
        return (EditorFontFile[])this.getProps(EditorFontFile.class);
    }

    @Override
    public Composite createTooltip(Composite composite) {
        String string;
        Object object;
        Browser browser;
        String string2;
        ApplicationUI applicationUI;
        Composite composite2 = DesignerProp.createCNToolTipItemList(composite, (PropCnr)this, (List<TooltipItem>)((Object)a), false);
        Browser browser2 = this.getFontFiles();
        if (((EditorFontFile[])browser2).length > 0) {
            applicationUI = new GridData(16384, 0x1000000, false, false, 2, 1);
            ((GridData)applicationUI).verticalIndent = 4;
            string2 = new Label(composite2, 0);
            string2.setText("Asset files:");
            string2.setLayoutData((Object)applicationUI);
            browser = browser2;
            int n2 = ((EditorFontFile[])browser).length;
            int n3 = 0;
            while (n3 < n2) {
                object = browser[n3];
                applicationUI = new GridData(16384, 0x1000000, false, false, 2, 1);
                ((GridData)applicationUI).horizontalIndent = 10;
                string2 = new Label(composite2, 0);
                string2.setLayoutData((Object)applicationUI);
                string = ((EditorFontFile)object).getCNText();
                if (string != null) {
                    string2.setText(string.replace("&", "&&"));
                }
                ++n3;
            }
        }
        applicationUI = ApplicationUI.getInstance();
        string2 = this.getLocalFontFaceCSS(null);
        if (string2.isEmpty()) {
            return composite2;
        }
        object = new GridData(4, 128, true, false, 2, 1);
        ((GridData)object).verticalIndent = applicationUI.s10();
        new Label(composite2, 258).setLayoutData(object);
        GridData gridData = new GridData(4, 128, true, false, 2, 1);
        gridData.verticalIndent = 6;
        Composite composite3 = SWTHelper.createBrowserOrCompositeForFailure(composite2, applicationUI.widgetBackground);
        composite3.setLayoutData((Object)gridData);
        if (composite3 instanceof Browser) {
            browser = (Browser)composite3;
            browser.setVisible(false);
            browser.setSize(0, 0);
            string = browser.getDisplay();
            new b(this, browser, "onJSInitialized", gridData, applicationUI, browser, composite, (Display)string, string2);
            string.asyncExec(() -> {
                if (browser.isDisposed()) {
                    return;
                }
                String string = InternalWebServer.getInstance().getFileUrl("fontFaces/fontFacePreview.html") + "?bust=" + SystemConfig.BUILD;
                if (!browser.setUrl(string)) {
                    ILog.WARNING(this.getClass(), (String)("Failed setting browser URL = " + string));
                }
            });
        }
        return composite2;
    }

    public Class<?>[] getPossibleChildren() {
        return this.a;
    }

    public String assignValue(String string, Atom atom, String[] stringArray, String string2, String string3) {
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            if (!stringArray[n2].equalsIgnoreCase(string)) continue;
            this.setInt(atom, n2);
            return null;
        }
        return "Value ('" + string + "') for " + string2 + " not valid, assuming " + string3;
    }

    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        StringProp stringProp = (StringProp)this.getProp(Atom.NAME, StringProp.class);
        if (stringProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, Atom.NAME, PropVerificationError.Severity.WARNING, "Font family", "Missing font family name", new String[0]));
        } else if (stringProp.getString().isEmpty()) {
            propVerification.add(new PropVerificationError("no.name", PropVerificationError.Severity.WARNING, "Font family", (GProp)stringProp, "Missing font family name", new String[0]));
        }
        return true;
    }

    public String getLocalFontFaceCSS(String string) {
        Object object;
        Object object2;
        BrowserFontFormat browserFontFormat = SWTHelper.isUsingMSIE() ? BrowserFontFormat.MSIE : BrowserFontFormat.ALL;
        Object object3 = null;
        String string2 = null;
        FontFile fontFile = this.getFontFile(browserFontFormat);
        if (fontFile != null) {
            object2 = fontFile.getAssetReference();
            if (object2 != null) {
                if (string != null) {
                    object3 = string + object2.getReference().replace(":/", "$/");
                } else {
                    object = object2.getFileURL();
                    if (object != null) {
                        object3 = ((URL)object).toExternalForm();
                    } else {
                        string2 = "asset reference URL is undefined";
                    }
                }
            } else {
                string2 = "asset reference is undefined";
            }
        } else {
            string2 = "supported font file type cannot be found for the browser";
        }
        if (object3 != null && fontFile != null) {
            Object object4;
            object2 = new StringBuilder("font-family:'").append(this.getFontFamily()).append("';").append(this.getFontFaceBaseDeclaration()).append("src:");
            object = this.getLocalNames();
            if (object != null) {
                String[] stringArray = ((String)object).split(",");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    object4 = stringArray[n3];
                    ((StringBuilder)object2).append("local('").append((String)object4).append("'),");
                    ++n3;
                }
            }
            ((StringBuilder)object2).append("url('").append((String)object3).append("')");
            object4 = fontFile.getFormat();
            if (object4 != FontFormat.UNDEFINED) {
                ((StringBuilder)object2).append(" format('").append(object4.type).append("')");
            }
            ((StringBuilder)object2).append(';');
            return ((StringBuilder)object2).toString();
        }
        if (string2 != null) {
            ILog.WARNING(this.getClass(), (String)("Failed processing font family '" + this.getFontFamily() + "': " + string2 + ", property = " + String.valueOf(this)));
        }
        return "";
    }

    public String getAvailableGlyphs(Collection<File> collection) {
        String string = this.a;
        if (string != null) {
            return string;
        }
        EditorFontFile[] editorFontFileArray = this.getFontFiles();
        int n2 = editorFontFileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file;
            FilePropCnr filePropCnr;
            AssetReference assetReference;
            EditorFontFile editorFontFile = editorFontFileArray[n3];
            FontFormat fontFormat = editorFontFile.getFormat();
            if (!(fontFormat != FontFormat.TrueType && fontFormat != FontFormat.OpenType || (assetReference = editorFontFile.getAssetReference()) == null || (filePropCnr = (FilePropCnr)assetReference.getFileURIPropCnr()) == null || (file = filePropCnr.getFile()) == null || collection != null && collection.contains(file) || !file.isFile())) {
                try {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                        Font font = Font.createFont(0, bufferedInputStream);
                        StringBuilder stringBuilder = new StringBuilder();
                        int n4 = 32;
                        while (n4 < 0x10FFFF) {
                            if (font.canDisplay(n4)) {
                                stringBuilder.append((char)n4);
                            }
                            ++n4;
                        }
                        this.a = HTMLUtilities.escapeTagValueString((String)stringBuilder.toString());
                        return this.a;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FontFormatException | IOException exception) {
                    if (collection != null && file.isFile()) {
                        collection.add(file);
                    }
                    ILog.WARNING(this.getClass(), (String)("Failed loading font file " + file.getAbsolutePath() + ": " + exception.getMessage()));
                }
            }
            ++n3;
        }
        return null;
    }
}

