/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.app;

import com.iizigo.Activator;
import com.iizigo.app.ApplicationDistributorJob;
import com.iizigo.app.ApplicationDistributorPropertyPage;
import com.iizigo.app.prop.AppDistributionProps;
import com.iizigo.project.ProjectManager;
import com.iizix.app.CancelException;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ApplicationDistributorLauncher
implements IEditorLauncher {
    public void open(IPath iPath) {
        Object object;
        iPath = iPath.makeAbsolute();
        Shell shell = Activator.getSomeShell();
        try {
            object = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath);
            if (ProjectManager.getInstance().getModuleModel((IResource)object) != null) {
                ApplicationDistributorLauncher.launchBuild(shell, (IFile)object);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = iPath.toFile();
        try {
            PropCnr propCnr = Activator.loadPropertiesFile((File)object);
            if (!(propCnr instanceof AppDistributionProps)) {
                throw new PropException((GProp)propCnr, "Application distribution property not found in distribution file " + ((File)object).getAbsolutePath());
            }
            AppDistributionProps appDistributionProps = (AppDistributionProps)propCnr;
            String string = ((File)object).getName().equals(".iiziApp") ? "" : " and the file name is not \".iiziApp\"";
            appDistributionProps.setLoadedFile((File)object);
            List list = appDistributionProps.verifyTree(Activator.getInstance().getKStringInfoProvider());
            if (appDistributionProps.getPropTreeErrorSeverity(true) > 0 || list != null) {
                StringBuilder stringBuilder = new StringBuilder();
                if (list != null) {
                    stringBuilder.append("\n\nProblems:");
                    for (String string2 : list) {
                        stringBuilder.append("\n - " + string2);
                    }
                }
                MessageDialog.openError((Shell)shell, (String)"Application Distribution", (String)("The Application Distribution file contains errors and can therefore not be used. As the file is not inside an open IIZI Module project" + string + ", it cannot be opened for editing." + String.valueOf(stringBuilder)));
                return;
            }
            MessageDialog.openInformation((Shell)shell, (String)"Application Distribution", (String)("The Application Distribution file is not inside an open IIZI Module project" + string + ", it can therefore not run inside the workbench. It can however run using the IIZI Application Distributor Command Line utility. This is however not yet supported, but can be done manually with a normal Java JRE without Eclipse."));
        }
        catch (PropException | IOException throwable) {
            Activator.openError(shell, "Open Application distribution", "Failed to load the Application distribution file.", throwable);
        }
    }

    public static boolean launchBuild(Shell shell, IFile iFile) throws CancelException {
        AppDistributionProps appDistributionProps;
        block11: {
            if (!iFile.getName().equals(".iiziApp")) {
                throw new CancelException("File name is not \".iiziApp\"");
            }
            if (!ProjectManager.getInstance().isRegistered(iFile.getProject())) {
                throw new CancelException("File is not inside an open Module project");
            }
            if (!iFile.isAccessible()) {
                IProject iProject = iFile.getProject();
                if (iProject.isAccessible() && MessageDialog.openQuestion((Shell)shell, (String)"Application Distribution", (String)"Project is not enabled for Application Distribution.\n\nDo you wish to open the configuration for editing?")) {
                    PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)iProject, (String)ApplicationDistributorPropertyPage.ID, null, null).open();
                }
                return false;
            }
            try {
                PropCnr propCnr = Activator.loadPropertiesFile(iFile);
                if (!(propCnr instanceof AppDistributionProps)) {
                    throw new CoreException((IStatus)Activator.createErrorStatus("Application distribution property not found in distribution file " + String.valueOf(iFile.getFullPath())));
                }
                appDistributionProps = (AppDistributionProps)propCnr;
                appDistributionProps.setLoadedFile(iFile);
                List list = appDistributionProps.verifyTree(Activator.getInstance().getKStringInfoProvider());
                if (appDistributionProps.getPropTreeErrorSeverity(true) <= 0 && list == null) break block11;
                StringBuilder stringBuilder = new StringBuilder();
                if (list != null) {
                    stringBuilder.append("\n\nProblems:");
                    for (String string : list) {
                        stringBuilder.append("\n - " + string);
                    }
                }
                if (MessageDialog.openQuestion((Shell)shell, (String)"Application Distribution", (String)("The Application Distribution file contains errors and can therefore not run.\n\nDo you wish to open the configuration for editing?" + String.valueOf(stringBuilder)))) {
                    PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)iFile, (String)ApplicationDistributorPropertyPage.ID, null, null).open();
                }
                return false;
            }
            catch (CoreException coreException) {
                Activator.openError(shell, "Open Application distribution", coreException);
                return false;
            }
        }
        ApplicationDistributorJob applicationDistributorJob = new ApplicationDistributorJob(iFile, appDistributionProps, false);
        applicationDistributorJob.setUser(true);
        applicationDistributorJob.setPriority(40);
        applicationDistributorJob.schedule();
        return true;
    }
}

