/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.server;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.ImageRegistry;
import com.iizigo.editor.CommonViewerEx;
import com.iizigo.editor.IDraggingFix;
import com.iizigo.editor.MultiSelectionProvider;
import com.iizigo.editor.PropEditorPart;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.handler.CommonActions;
import com.iizigo.handler.SelectionEnabler;
import com.iizigo.jface.PartAction;
import com.iizigo.jface.ViewerToolTipSupport;
import com.iizigo.plugin.PluginDescriptor;
import com.iizigo.project.ModuleModel;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.IPropertyEditorController;
import com.iizigo.prop.PropertyEditor;
import com.iizigo.prop.editor.dialog.SelectProjectDialog;
import com.iizigo.server.IServerConfigFileListener;
import com.iizigo.server.NewServerConfigWizard;
import com.iizigo.server.ServerConfigFile;
import com.iizigo.server.a;
import com.iizigo.server.c;
import com.iizigo.server.config.EditorLetsEncryptDomain;
import com.iizigo.server.config.EditorMailProps;
import com.iizigo.server.config.EditorServerAppConfig;
import com.iizigo.server.config.EditorServerConfigEnvProps;
import com.iizigo.server.config.EditorServerPluginConfig;
import com.iizigo.server.config.EditorServerSettings;
import com.iizigo.server.config.EditorWebServerPortConfig;
import com.iizigo.server.launch.DevelServerLaunchConfigurationTab;
import com.iizigo.swt.InvokeSWTLater;
import com.iizigo.swt.LineWidget;
import com.iizigo.swt.OutlinedComposite;
import com.iizix.IDisposedPart;
import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.event.EventListener;
import com.iizix.event.GEvent;
import com.iizix.mail.Mail;
import com.iizix.mail.MailSender;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IPropErrorItem;
import com.iizix.prop.IPropUndoRedo;
import com.iizix.prop.MailProps;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropErrorItemOrigin;
import com.iizix.prop.PropException;
import com.iizix.server.prop.IServerApplicationSetup;
import com.iizix.server.prop.IServerApplicationSetupPropCnr;
import com.iizix.swt.IzMenu;
import jakarta.mail.Address;
import jakarta.mail.Message;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerConfigComposite
extends Composite
implements IDraggingFix,
IPropertyEditorController,
IServerConfigFileListener,
EventListener,
IPropUndoRedo,
ISelectionChangedListener {
    private final MultiSelectionProvider a;
    private IUndoContext a;
    private ServerConfigFile a;
    private Exception a;
    private Link a;
    private Composite a;
    private EditorServerSettings a;
    private CommonViewerEx a;
    private SashForm a;
    private PropertyEditor a;
    private Tree a;
    private IzMenu a;
    private ToolBar a;
    private Composite b;
    private CommonActions a;
    private boolean a;
    private final SelectionEnabler a;
    private final IWorkbenchPart a;
    private final IMemento a;
    private final Runnable a;
    private ArrayList<PropErrorItemOrigin> a;
    private PropCnr[] a;
    private final ApplicationUI a;
    private PartAction a;
    private PartAction b;
    private PartAction c;
    private PartAction d;
    private PartAction e;
    private PartAction f;
    private PartAction g;
    private int a;
    private int b;
    private final InvokeSWTLater a = new InvokeSWTLater(300, () -> this.updateStates());

    public ServerConfigComposite(IWorkbenchPart iWorkbenchPart, Composite composite, IMemento iMemento, Runnable runnable) {
        super(composite, 0);
        this.a = iWorkbenchPart;
        this.a = iMemento;
        this.a = runnable;
        this.a.setDraggingFix(this);
        this.a.addSelectionChangedListener(this);
        this.addListener(12, event -> this.dispose());
    }

    public void dispose() {
        super.dispose();
        if (this.a != null) {
            this.a.removePropListener(this);
        }
        if (this.a != null) {
            this.a.removeListener(this);
            this.a.release();
            this.a = null;
        }
        this.a = null;
    }

    public ServerConfigFile getServerConfigFile() {
        return this.a;
    }

    public EditorServerSettings getSettings() {
        return this.a;
    }

    public void setServerConfigFile(ServerConfigFile serverConfigFile, Exception exception) {
        if (serverConfigFile != this.a && this.a != null) {
            if (this.a != null) {
                this.a.removePropListener(this);
            }
            this.a.removeListener(this);
            this.a.release();
        }
        this.a = serverConfigFile;
        this.a = serverConfigFile != null ? serverConfigFile.getSettings() : null;
        this.a = exception;
        Control[] controlArray = this.a.getChildren();
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Control control = controlArray[n3];
            control.dispose();
            ++n3;
        }
        this.a = null;
        if (serverConfigFile == null) {
            this.c();
        } else {
            this.e();
        }
        this.a();
        this.layout(true, true);
        if (this.b != null && this.a != null) {
            this.a.addPropListener(this);
            this.g();
        }
    }

    @Override
    public void onServerConfigFileUpdated(ServerConfigFile serverConfigFile) {
        this.updateStates();
    }

    private void a() {
        boolean bl;
        boolean bl2 = bl = this.a != null && this.a.isDirty();
        if (this.a != bl) {
            this.a = bl;
            this.b();
        }
    }

    public boolean isDirty() {
        this.a();
        return this.a;
    }

    private void b() {
        this.a.run();
    }

    public void saveState(IMemento iMemento) {
        iMemento.putString("file", this.a != null ? this.a.getPath() : "");
        if (this.a != null) {
            int[] nArray = this.a.getWeights();
            iMemento.putInteger("sash.0", nArray[0]);
            iMemento.putInteger("sash.1", nArray[1]);
            PropHelper.saveViewer(iMemento, "tree", (TreeViewer)this.a);
            this.a.saveState(iMemento.createChild("propEditor"));
        }
    }

    public void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        this.setLayout((Layout)gridLayout);
        this.setBackground(this.a.border);
        this.a = new Composite((Composite)this, 0);
        this.a.setBackground(this.a.widgetBackground);
        this.a.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.a == null) {
            this.c();
        } else {
            this.e();
        }
    }

    private void c() {
        Label label;
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = gridLayout.horizontalSpacing = this.a.s10();
        gridLayout.marginWidth = gridLayout.horizontalSpacing;
        gridLayout.marginHeight = gridLayout.horizontalSpacing;
        this.a.setLayout((Layout)gridLayout);
        this.a = new Link(this.a, 64);
        this.a.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.a.setText("No Server configuration file is set. Click to <a href=\"open\">open an existing file</a> or use the <a href=\"wizard\">wizard to create a new file</a>.");
        this.a.addListener(13, event -> {
            if ("open".equals(event.text)) {
                FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.iiziServer"});
                String string = fileDialog.open();
                if (string != null) {
                    this.a(string, true);
                }
            } else {
                NewServerConfigWizard newServerConfigWizard = new NewServerConfigWizard();
                newServerConfigWizard.setServerConfigComposite(this);
                WizardDialog wizardDialog = new WizardDialog(this.a.getShell(), (IWizard)newServerConfigWizard);
                wizardDialog.setTitle(newServerConfigWizard.getWindowTitle());
                wizardDialog.setTitleImage(this.a.getImage("new_server_config.png"));
                wizardDialog.open();
            }
        });
        List<File> list = ServerConfigFile.getHistory();
        if (!list.isEmpty()) {
            File file2;
            label = new Label(this.a, 16384);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label.setText("Recent file names:");
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.minimumWidth = this.a.cx(150);
            Combo combo = new Combo(this.a, 12);
            combo.setLayoutData((Object)gridData);
            for (File file2 : list) {
                combo.add(file2.getPath());
            }
            gridData = new GridData(16384, 0x1000000, false, false);
            gridData.widthHint = this.a.cx(80);
            file2 = new Button(this.a, 8);
            file2.setLayoutData(gridData);
            file2.setText("&Open");
            file2.setEnabled(false);
            file2.addListener(13, event -> {
                String string = combo.getText();
                if (string != null && !string.isEmpty()) {
                    this.a(string, true);
                }
            });
            combo.addListener(13, arg_0 -> ServerConfigComposite.a((Button)file2, combo, arg_0));
        }
        if (this.a != null) {
            label = new CLabel(this.a, 0);
            label.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
            label.setImage(ApplicationUI.getInstance().imageError);
            label.setText("Failed to load the Server Configuration file: " + this.a.getMessage());
            label.setToolTipText(Utilities.getStackTrace((Throwable)this.a));
        }
    }

    void a(String string, boolean bl) {
        block2: {
            try {
                ServerConfigFile serverConfigFile = ServerConfigFile.open(string);
                this.setServerConfigFile(serverConfigFile, null);
                serverConfigFile.updateHistory();
            }
            catch (PropException | IOException throwable) {
                if (!bl) break block2;
                Activator.openError(this.getShell(), "Server Configuration", "Failed opening Server Configuration file '" + string + "'.", throwable);
            }
        }
    }

    private void d() {
        ImageRegistry imageRegistry = ImageRegistry.getInstance();
        this.a = new PartAction((IDisposedPart)this, "Add port configuration", "Adds a new port configuration for the web server", this.a.getNewImageDescriptor(this.a.getImage("server_port_config.gif"))).with(() -> {
            boolean bl = this.a(true);
        });
        this.b = new PartAction((IDisposedPart)this, "Add configuration environment", "Adds a new configuration environment", this.a.getNewImageDescriptor(this.a.getImage("server_config_env.gif"))).with(() -> {
            boolean bl = this.b(true);
        });
        this.c = new PartAction((IDisposedPart)this, "Add app configuration", "Adds a new app configuration for server to load at startup.\nThe app must be compiled with App distribution to a Jar file.", this.a.getNewImageDescriptor(this.a.getImage("application_settings.gif"))).with(() -> {
            boolean bl = this.c(true);
        });
        this.d = new PartAction((IDisposedPart)this, "Add Let's Encrypt domain", "Adds a new Let's Encrypt domain to be used with HTTPS port configuration(s)", this.a.getNewImageDescriptor(this.a.getImage("letsencrypt.png"))).with(() -> {
            boolean bl = this.d(true);
        });
        this.e = new PartAction((IDisposedPart)this, "Add new mail sender", "Adds a new mail sender", this.a.getNewImageDescriptor(this.a.getImage("mail_sender.png"))).with(() -> {
            boolean bl = this.e(true);
        });
        this.f = new PartAction((IDisposedPart)this, "Send test mail...", "Sends a test mail", imageRegistry.get("mail.gif")).with(() -> {
            boolean bl = this.f(true);
        });
        this.g = new PartAction((IDisposedPart)this, "Collect plug-in configurations", "Collects configuration(s) from project(s) plug-in(s)", imageRegistry.get("collect.png")).with(() -> {
            boolean bl = this.g(true);
        });
    }

    public void updateStates() {
        this.a.updateStates();
        this.a.setEnabled(this.a(false));
        this.b.setEnabled(this.b(false));
        this.c.setEnabled(this.c(false));
        this.d.setEnabled(this.d(false));
        this.e.setEnabled(this.e(false));
        this.f.setEnabled(this.f(false));
        this.g.setEnabled(this.g(false));
        this.a();
    }

    private void e() {
        this.d();
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.a.setLayout((Layout)gridLayout);
        this.a = new ToolBar(this.a, 0x800000);
        this.a.setLayoutData((Object)new GridData(4, 128, true, false));
        LineWidget lineWidget = new LineWidget(this.a, true, 0, -1);
        lineWidget.setLayoutData(new GridData(4, 128, true, false));
        this.a = new CommonActions(this.a, this, this, this.a, this.a, null, () -> this.updateStates(), 7);
        this.a = new SashForm(this.a, 66048);
        this.a.setSashWidth(3);
        this.a.setLayoutData((Object)new GridData(4, 4, true, true));
        OutlinedComposite outlinedComposite = new OutlinedComposite((Composite)this.a);
        this.a = new c(this, outlinedComposite, 2, 32);
        this.a = this.a.getTree();
        this.a.setLayoutData((Object)new GridData(4, 128, true, true));
        ViewerToolTipSupport.enableFor((ColumnViewer)this.a);
        this.a.addPostSelectionChangedListener(this);
        this.a.setComparator((ViewerComparator)new com.iizigo.navigator.ViewerComparator());
        outlinedComposite.addLine(1024, 0, -1);
        outlinedComposite.setFirstChildAsCenterArea();
        this.a = new IzMenu((Control)this.a);
        this.a.setMenu((Control)this.a, false).omitDisabled();
        this.a.addControl((Control)this.a, (ISelectionProvider)this.a);
        this.a(0);
        this.a(1);
        this.f();
        this.a(2);
        this.a(3);
        this.a(4);
        this.a(5);
        this.f();
        this.a((IAction)this.a);
        this.a((IAction)this.d);
        this.f();
        this.a((IAction)this.b);
        this.a((IAction)this.g);
        this.f();
        this.a((IAction)this.c);
        this.f();
        this.a((IAction)this.e);
        this.a((IAction)this.f);
        outlinedComposite = new OutlinedComposite((Composite)this.a);
        try {
            this.a = new PropertyEditor(this, outlinedComposite, Activator.setupServerConfig, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError("Cannot create properties", exception);
        }
        this.a.setFixedTooltips();
        outlinedComposite.addLine(128, 0, -1);
        outlinedComposite.setFirstChildAsCenterArea();
        this.a.setInput(new Object[]{this.a.getDesigner()});
        this.a.refresh();
        this.a.expandAll();
        this.a.setSelection((ISelection)new StructuredSelection((Object)this.a.getDesigner()), true);
        if (this.a != null) {
            IMemento iMemento = this.a.getChild("propEditor");
            if (iMemento != null) {
                this.a.restoreState(iMemento);
            }
            PropHelper.restoreTree(null, this.a, "tree", (TreeViewer)this.a, (PropCnr)this.a);
            Integer n2 = this.a.getInteger("sash.0");
            Integer n3 = this.a.getInteger("sash.1");
            if (n2 != null && n3 != null) {
                this.a.setWeights(new int[]{n2, n3});
            }
        }
    }

    private void a(int n2) {
        this.a(this.a.get(n2));
    }

    private void a(IAction iAction) {
        new ActionContributionItem(iAction).fill(this.a, -1);
        this.a.add(iAction);
    }

    private void f() {
        PropEditorPart.addToolbarSeparator(this.a);
        this.a.addSeparator();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.a = Activator.getPropCnrs(Activator.getSelectedProps(selectionChangedEvent.getSelection()));
        this.a.setEditedProperties(this.a);
        this.updateStates();
    }

    public SelectionEnabler getSelectionEnabler() {
        return this.a;
    }

    @Override
    public Object getUndoContext() {
        return this.a;
    }

    public void setTargetViewer(Object object) {
    }

    @Override
    public IPropUndoRedo getUndoRedo() {
        return this;
    }

    protected void onDragBegin() {
        ++this.a;
    }

    protected void onDragEnd() {
        if (--this.a == 0) {
            this.a.onDragEnd();
        }
    }

    @Override
    public boolean isDragging() {
        return this.a > 0;
    }

    @Override
    public ModuleModel getModuleModel() {
        return null;
    }

    @Override
    public MultiSelectionProvider getMultiSelectionProvider() {
        return this.a;
    }

    public Object getTargetViewer() {
        return this.b > 0 ? null : this.a;
    }

    @Override
    public void setBlockViewerFocus(boolean bl) {
        this.b = bl ? ++this.b : --this.b;
    }

    @Override
    public void setPropertyError(GProp<?> gProp, String string, IPropErrorItem iPropErrorItem) {
        if (gProp.getParent() == null) {
            if (iPropErrorItem == null) {
                gProp.removePropError(string);
            } else {
                gProp.addPropError(iPropErrorItem);
            }
        } else {
            PropHelper.setError(gProp, string, iPropErrorItem, this);
        }
        this.updateStates();
    }

    @Override
    public void removePropertyValue(GProp<?> gProp) {
        PropHelper.doDelete("Un-defined property", new GProp[]{gProp}, this, () -> this.updateStates());
    }

    @Override
    public void setPropertyAttrFlag(GProp<?> gProp, int n2, boolean bl) {
        PropHelper.setAttribute(gProp, n2, bl, this);
        this.updateStates();
    }

    @Override
    public void setPropertyValue(PropCnr propCnr, GProp<?> gProp, Object object) {
        if (gProp.getParent() == propCnr) {
            PropHelper.setValue("Edit property", new GProp[]{gProp}, new Object[]{object}, (IPropUndoRedo)this);
        } else {
            GProp gProp2 = propCnr.getProp(gProp.getPropAtom());
            if (gProp2 != null) {
                PropHelper.setValue("Edit property", new GProp[]{gProp2}, new Object[]{object}, (IPropUndoRedo)this);
            } else {
                PropHelper.doAdd("Define property", propCnr, gProp, (IPropUndoRedo)this, false);
            }
        }
        this.updateStates();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.a != null) {
            this.a.doSave(this.getShell(), iProgressMonitor);
        }
    }

    private boolean a(boolean bl) {
        if (bl) {
            EditorWebServerPortConfig editorWebServerPortConfig = new EditorWebServerPortConfig(this.a.createUniqueAtom("$port"));
            PropHelper.doAdd("Add port configuration", (PropCnr)this.a, editorWebServerPortConfig, (IPropUndoRedo)this, false);
        }
        return true;
    }

    private boolean b(boolean bl) {
        if (bl) {
            EditorServerConfigEnvProps editorServerConfigEnvProps = new EditorServerConfigEnvProps(this.a.createUniqueAtom("env"));
            PropHelper.doAdd("Add configuration environment", (PropCnr)this.a, editorServerConfigEnvProps, (IPropUndoRedo)this, false);
        }
        return true;
    }

    private boolean c(boolean bl) {
        EditorServerConfigEnvProps editorServerConfigEnvProps;
        PropCnr[] propCnrArray = this.a;
        if (propCnrArray == null || propCnrArray.length != 1) {
            return false;
        }
        PropCnr propCnr = propCnrArray[0];
        if (!(propCnrArray[0] instanceof EditorServerConfigEnvProps) && !(propCnrArray[0] instanceof EditorServerAppConfig)) {
            return false;
        }
        EditorServerConfigEnvProps editorServerConfigEnvProps2 = editorServerConfigEnvProps = propCnr instanceof EditorServerConfigEnvProps ? (EditorServerConfigEnvProps)propCnr : (EditorServerConfigEnvProps)propCnr.getParent(EditorServerConfigEnvProps.class);
        if (editorServerConfigEnvProps == null) {
            return false;
        }
        if (bl) {
            EditorServerAppConfig editorServerAppConfig;
            Object object = "app";
            int n2 = 1;
            block0: while (true) {
                EditorServerAppConfig[] editorServerAppConfigArray = (EditorServerAppConfig[])this.a.getAllProps(EditorServerAppConfig.class);
                int n3 = editorServerAppConfigArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    editorServerAppConfig = editorServerAppConfigArray[n4];
                    if (!((String)object).equals(editorServerAppConfig.getPropName())) {
                        ++n4;
                        continue;
                    }
                    object = "app" + ++n2;
                    continue block0;
                }
                break;
            }
            editorServerAppConfig = new EditorServerAppConfig(Atom.get((String)object));
            PropHelper.doAdd("Add app configuration", (PropCnr)editorServerConfigEnvProps, editorServerAppConfig, (IPropUndoRedo)this, false);
        }
        return true;
    }

    private boolean d(boolean bl) {
        if (bl) {
            EditorLetsEncryptDomain editorLetsEncryptDomain = new EditorLetsEncryptDomain(this.a.createUniqueAtom("my.domain.com"));
            PropHelper.doAdd("Add Let's Encrypt domain", (PropCnr)this.a, editorLetsEncryptDomain, (IPropUndoRedo)this, false);
        }
        return true;
    }

    private boolean e(boolean bl) {
        if (bl) {
            EditorMailProps editorMailProps = new EditorMailProps(this.a.createUniqueAtom("mail"));
            PropHelper.doAdd("Add Main Sender", (PropCnr)this.a, editorMailProps, (IPropUndoRedo)this, false);
        }
        return true;
    }

    private boolean f(boolean bl) {
        Object[] objectArray;
        String[] stringArray;
        block12: {
            File file;
            EditorMailProps editorMailProps;
            block11: {
                block10: {
                    GProp<?>[] gPropArray = Activator.getSelectedGProps(this.a.getSelection());
                    if (gPropArray.length != 1 || !(gPropArray[0] instanceof EditorMailProps)) {
                        return false;
                    }
                    editorMailProps = (EditorMailProps)gPropArray[0];
                    if (editorMailProps.getPropTreeErrorSeverity(false) > 0) {
                        return false;
                    }
                    stringArray = new String[1];
                    file = null;
                    file = DevelServerLaunchConfigurationTab.getDefaultServerDirectory();
                    if (bl) break block10;
                    return true;
                }
                a a2 = new a(this.getShell());
                objectArray = a2.a();
                if (objectArray != null) break block11;
                return false;
            }
            if (stringArray[0] == null) {
                String string = editorMailProps.getString("directory");
                if (string == null || string.isEmpty()) {
                    stringArray[0] = "Mail directory must be specified";
                } else {
                    File file2 = file.toPath().resolve(string).toFile();
                    BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> this.a(editorMailProps, file2, (Address[])objectArray, stringArray));
                }
            }
            if (stringArray[0] != null) break block12;
            return true;
        }
        try {
            MessageDialog.openError((Shell)this.getShell(), (String)"Failed sending test mail", (String)("Failed sending test mail to recipients " + (String)(objectArray.length == 1 ? "\"" + objectArray[0].toString() + "\"" : Arrays.toString(objectArray))));
            return false;
        }
        catch (IOException | InvalidPathException exception) {
            stringArray[0] = "Failed getting server home directory";
            ILog.SEVERE(this.getClass(), (String)stringArray[0], (Throwable)exception);
            stringArray[0] = String.valueOf(stringArray[0]) + ": " + exception.getMessage();
            return false;
        }
    }

    private boolean g(boolean bl) {
        DesignerProp designerProp = Activator.getFirstSelectedProperty(this.a.getSelection());
        if (designerProp != null) {
            PropCnr propCnr = designerProp.getPropCnr();
            while (propCnr != null && !propCnr.isPropRoot()) {
                if (propCnr instanceof EditorServerConfigEnvProps) {
                    EditorServerConfigEnvProps editorServerConfigEnvProps = (EditorServerConfigEnvProps)propCnr;
                    if (bl) {
                        this.a(editorServerConfigEnvProps);
                    }
                    return true;
                }
                propCnr = propCnr.getParent();
            }
        }
        return false;
    }

    private void a(EditorServerConfigEnvProps editorServerConfigEnvProps) {
        IServerApplicationSetup iServerApplicationSetup;
        PropCnr propCnr;
        PluginDescriptor pluginDescriptor;
        Object object;
        Object object2;
        SelectProjectDialog selectProjectDialog = new SelectProjectDialog(this.getShell(), "Select Module projects", "Select Module projects to collect the plug-in information to the Server configuration environment.", true);
        ModuleModel[] moduleModelArray = selectProjectDialog.open();
        if (moduleModelArray == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap hashMap2 = new HashMap();
        Object object3 = moduleModelArray;
        int n2 = moduleModelArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = object3[n3];
            object = ((ModuleModel)object2).getRootContainer();
            PluginDescriptor[] pluginDescriptorArray = ((ModuleModel)object2).getPlugins();
            PluginDescriptor[] pluginDescriptorArray2 = pluginDescriptorArray;
            int n4 = pluginDescriptorArray.length;
            int n5 = 0;
            while (n5 < n4) {
                pluginDescriptor = pluginDescriptorArray2[n5];
                propCnr = pluginDescriptor.getServerApplicationSetupInstances((PropCnr)object);
                if (propCnr != null && ((IServerApplicationSetup[])propCnr).length > 0) {
                    PropCnr propCnr2 = propCnr;
                    int n6 = ((IServerApplicationSetup[])propCnr2).length;
                    int n7 = 0;
                    while (n7 < n6) {
                        iServerApplicationSetup = propCnr2[n7];
                        List list = iServerApplicationSetup.getSetupPropertyContainers((PropCnr)object);
                        if (!list.isEmpty()) {
                            String string = iServerApplicationSetup.getID();
                            hashMap.put(string, iServerApplicationSetup.getDescription());
                            LinkedHashSet linkedHashSet = (LinkedHashSet)hashMap2.get(string);
                            if (linkedHashSet == null) {
                                linkedHashSet = new LinkedHashSet();
                                hashMap2.put(string, linkedHashSet);
                            }
                            linkedHashSet.addAll(list);
                        }
                        ++n7;
                    }
                }
                ++n5;
            }
            ++n3;
        }
        object2 = new ComplexOperation("Collect plug-in configurations", null, this);
        for (Map.Entry entry : hashMap2.entrySet()) {
            object3 = (String)entry.getKey();
            object = (String)hashMap.get(object3);
            boolean bl = true;
            pluginDescriptor = Atom.get((String)object3);
            EditorServerPluginConfig editorServerPluginConfig = (EditorServerPluginConfig)editorServerConfigEnvProps.getProp((Atom)pluginDescriptor, EditorServerPluginConfig.class);
            if (editorServerPluginConfig == null) {
                editorServerPluginConfig = new EditorServerPluginConfig((Atom)pluginDescriptor);
                editorServerPluginConfig.setString(Atom.DESCR, (String)object);
                ((ComplexOperation)((Object)object2)).addProp((PropCnr)editorServerConfigEnvProps, (GProp<?>)editorServerPluginConfig);
                bl = false;
            }
            for (IServerApplicationSetupPropCnr iServerApplicationSetupPropCnr : (LinkedHashSet)entry.getValue()) {
                try {
                    propCnr = ((PropCnr)iServerApplicationSetupPropCnr).clone();
                    pluginDescriptor = propCnr.getPropAtom();
                    if (bl) {
                        iServerApplicationSetup = editorServerPluginConfig.getProp((Atom)pluginDescriptor);
                        if (iServerApplicationSetup != null) {
                            ((ComplexOperation)((Object)object2)).removeProp((GProp<?>)iServerApplicationSetup);
                        }
                        ((ComplexOperation)((Object)object2)).addProp((PropCnr)editorServerPluginConfig, (GProp<?>)propCnr);
                        continue;
                    }
                    if (editorServerPluginConfig.containsProp((Atom)pluginDescriptor)) continue;
                    editorServerPluginConfig.addProp2((IGProp)propCnr);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    ILog.SEVERE(this.getClass(), (String)"Clone failed", (Object[])new Object[]{iServerApplicationSetupPropCnr, cloneNotSupportedException});
                }
            }
        }
        if (((ComplexOperation)((Object)object2)).hasPerformedAnOperation()) {
            PropHelper.executeOperation(this.getShell(), (AbstractOperation)object2);
            this.a.refresh();
            this.a.expandToLevel(editorServerConfigEnvProps.getDesigner(), -1);
        }
        this.updateStates();
    }

    public void addErrorComposite(Composite composite) {
        this.b = composite;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        if (this.a != null) {
            this.a.addPropListener(this);
            PropHelper.doVerify(this.a.getRootParent());
        }
        this.g();
    }

    private void g() {
        boolean bl;
        if (this.b == null || this.isDisposed() || this.b.isDisposed()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        if (this.a != null) {
            this.a.getErroredPropItems(arrayList, true);
        }
        this.b.setVisible(!(bl = arrayList.isEmpty()));
        GridData gridData = (GridData)this.b.getLayoutData();
        gridData.exclude = bl;
        if (!arrayList.equals(this.a)) {
            this.a = arrayList;
            Control[] controlArray = this.b.getChildren();
            int n2 = controlArray.length;
            while (--n2 >= 0) {
                controlArray[n2].dispose();
            }
            if (this.a != null) {
                this.a.getDesigner().appendTooltipPropErrors(this.b);
            }
            this.b.getParent().getParent().layout(true, true);
        }
    }

    public void onEvent(GEvent gEvent) {
        if (this.a != null && gEvent.isVerifyEvent()) {
            PropHelper.queueVerify(this.a.getRootParent(), () -> this.g());
        }
        this.a.trigger();
    }

    private static /* synthetic */ void a(Button button, Combo combo, Event event) {
        button.setEnabled(combo.getSelectionIndex() >= 0);
    }

    private /* synthetic */ void a(EditorMailProps editorMailProps, File file, Address[] addressArray, String[] stringArray) {
        try {
            MailSender mailSender = new MailSender((MailProps)editorMailProps, null, file);
            Mail mail = mailSender.createMail();
            mail.getMessage().setRecipients(Message.RecipientType.TO, addressArray);
            mail.setSubject("Test mail");
            mail.setText("Hello from IIZI, sent " + String.valueOf(new Date()));
            mail.send(true);
            mailSender.dispose();
        }
        catch (Throwable throwable) {
            stringArray[0] = "Failed sending test mail: " + throwable.getMessage();
            ILog.WARNING(this.getClass(), (String)stringArray[0]);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    protected final class DragSourceDelegator
    implements DragSourceListener {
        private final DragSourceListener a;

        protected DragSourceDelegator(DragSourceListener dragSourceListener) {
            this.a = dragSourceListener;
        }

        public void dragStart(DragSourceEvent dragSourceEvent) {
            ServerConfigComposite.this.onDragBegin();
            this.a.dragStart(dragSourceEvent);
        }

        public void dragSetData(DragSourceEvent dragSourceEvent) {
            this.a.dragSetData(dragSourceEvent);
        }

        public void dragFinished(DragSourceEvent dragSourceEvent) {
            this.a.dragFinished(dragSourceEvent);
            ServerConfigComposite.this.onDragEnd();
        }
    }
}

