/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary.fetch;

import com.tabnine.eclipse.shared.api.binary.exceptions.NoValidBinaryToRunException;
import com.tabnine.eclipse.shared.api.binary.fetch.BinaryFetchUtils;
import com.tabnine.eclipse.shared.api.binary.fetch.BinaryRemoteSource;
import com.tabnine.eclipse.shared.api.binary.fetch.BinaryVersion;
import com.tabnine.eclipse.shared.api.binary.fetch.BundleDownloader;
import com.tabnine.eclipse.shared.api.binary.fetch.LocalBinaryVersions;
import com.vdurmont.semver4j.Semver;
import java.util.Optional;

public class BinaryVersionFetcher {
    private LocalBinaryVersions localBinaryVersions;
    private BinaryRemoteSource binaryRemoteSource;
    private BundleDownloader bundleDownloader;
    private static String FIRST_BAD_VERSION = "4.5.0";
    private static String LAST_BAD_VERSION = "4.5.12";

    public BinaryVersionFetcher(LocalBinaryVersions localBinaryVersions, BinaryRemoteSource binaryRemoteSource, BundleDownloader bundleDownloader) {
        this.localBinaryVersions = localBinaryVersions;
        this.binaryRemoteSource = binaryRemoteSource;
        this.bundleDownloader = bundleDownloader;
    }

    public String fetchBinary() {
        Semver semver;
        Optional<BinaryVersion> optional = this.locateLocalBootstrapSupportedVersion();
        if (optional.isPresent() && ((semver = new Semver(optional.get().getVersion())).isGreaterThan(LAST_BAD_VERSION) || semver.isLowerThan(FIRST_BAD_VERSION))) {
            return optional.get().getVersionFullPath();
        }
        semver = BinaryVersionFetcher.downloadRemoteVersion(this.binaryRemoteSource, this.bundleDownloader);
        if (semver.isPresent()) {
            return ((BinaryVersion)semver.get()).getVersionFullPath();
        }
        throw new NoValidBinaryToRunException();
    }

    private Optional<BinaryVersion> locateLocalBootstrapSupportedVersion() {
        Optional<BinaryVersion> optional = this.localBinaryVersions.activeVersion();
        if (optional.isPresent()) {
            return optional;
        }
        return this.localBinaryVersions.listExisting().stream().findFirst();
    }

    private static Optional<BinaryVersion> downloadRemoteVersion(BinaryRemoteSource binaryRemoteSource, BundleDownloader bundleDownloader) {
        return binaryRemoteSource.fetchPreferredVersion(BinaryFetchUtils.getTabNineBundleVersionUrl()).flatMap(bundleDownloader::downloadAndExtractBundle);
    }
}

