/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api;

import com.tabnine.eclipse.shared.api.ConcurrentState$Procedure;
import com.tabnine.eclipse.shared.api.ConcurrentState$Unsubscribe;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConcurrentState<T> {
    private volatile Optional<T> value = Optional.empty();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final AtomicBoolean hasChanged = new AtomicBoolean(false);
    private final Set<Consumer<T>> listeners = ConcurrentHashMap.newKeySet();

    public ConcurrentState() {
    }

    protected ConcurrentState(T t2) {
        this.value = Optional.of(t2);
    }

    public Optional<T> get() {
        return ConcurrentState.withLock(this.rwLock.readLock(), () -> this.value);
    }

    public void set(T object) {
        object = Optional.of(object);
        ConcurrentState.withLock(this.rwLock.writeLock(), () -> {
            this.hasChanged.set(!object.equals(this.value));
            this.value = object;
        });
        this.notifyListeners();
    }

    public void setWith(Function<Optional<T>, T> function) {
        ConcurrentState.withLock(this.rwLock.writeLock(), () -> {
            this.hasChanged.set(!((Optional)(function = Optional.of(function.apply(this.value)))).equals(this.value));
            this.value = function;
        });
        this.notifyListeners();
    }

    public ConcurrentState$Unsubscribe onChange(Consumer<T> consumer) {
        ConcurrentState.withLock(this.rwLock.readLock(), () -> {
            this.value.ifPresent(consumer);
            this.listeners.add(consumer);
        });
        return () -> this.listeners.remove(consumer);
    }

    private void notifyListeners() {
        ConcurrentState.withLock(this.rwLock.readLock(), () -> {
            if (this.hasChanged.getAndSet(false)) {
                this.value.ifPresent(object -> this.listeners.forEach(consumer -> consumer.accept(object)));
            }
        });
    }

    private static <O> O withLock(Lock lock, Supplier<O> supplier) {
        lock.lock();
        try {
            supplier = supplier.get();
            return (O)supplier;
        }
        finally {
            lock.unlock();
        }
    }

    private static void withLock(Lock lock, ConcurrentState$Procedure concurrentState$Procedure) {
        lock.lock();
        try {
            concurrentState$Procedure.invoke();
        }
        finally {
            lock.unlock();
        }
    }
}

