/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractMarketplaceDiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.StyledTextHelper;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractSimpleDiscoveryItem<T extends CatalogItem>
extends AbstractMarketplaceDiscoveryItem<T> {
    public AbstractSimpleDiscoveryItem(Composite parent, int style, MarketplaceDiscoveryResources resources, IMarketplaceWebBrowser browser, T connector, CatalogViewer viewer) {
        super(parent, style, resources, browser, connector, viewer);
    }

    @Override
    protected boolean alignIconWithName() {
        return true;
    }

    protected void createButtons(Composite parent) {
    }

    @Override
    protected abstract Icon getIcon();

    @Override
    protected abstract String getDescriptionText();

    @Override
    protected abstract String getNameLabelText();

    protected String getSublineText() {
        return null;
    }

    @Override
    protected void createDescription(Composite parent) {
        String descriptionText = this.getDescriptionText();
        if (descriptionText != null && !"".equals(descriptionText)) {
            super.createDescription(parent);
        }
    }

    @Override
    protected void createTagsLabel(Composite parent) {
        this.createButtonBar(parent);
    }

    protected void createButtonBar(Composite parent) {
        String sublineText = this.getSublineText();
        String descriptionText = this.getDescriptionText();
        int usedRows = 0;
        if (descriptionText != null && !"".equals(descriptionText)) {
            ++usedRows;
        }
        if (sublineText != null && !"".equals(sublineText)) {
            ++usedRows;
        }
        int availableRows = 3;
        this.createButtonBar(parent, availableRows - usedRows);
    }

    @Override
    protected StyledText createProviderLabel(Composite parent) {
        return this.createSublineLabel(parent);
    }

    protected StyledText createSublineLabel(Composite parent) {
        String sublineText = this.getSublineText();
        if (sublineText == null) {
            return null;
        }
        StyledText subline = StyledTextHelper.createStyledTextLabel(parent);
        subline.setEditable(false);
        GridDataFactory.fillDefaults().indent(8, 8).span(3, 1).align(1, 0x1000000).grab(true, false).applyTo((Control)subline);
        subline.setForeground(this.resources.getColorDisabled());
        subline.setText(sublineText);
        StyleRange range = StyledTextHelper.createDynamicForegroundRange(subline, 0, subline.getText().length(), 2);
        subline.setStyleRange(range);
        new StyleHelper().on((Widget)subline).setClasses(new String[]{"subline", "disabled"});
        return subline;
    }

    protected void createButtonBar(Composite parent, int vSpan) {
        Label spacer = this.createButtonBarSpacer(parent);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).span(1, vSpan).applyTo((Control)spacer);
        Composite buttonContainer = new Composite(parent, 0);
        buttonContainer.setBackgroundMode(1);
        GridDataFactory.swtDefaults().indent(0, 8).align(0x1000008, 0x1000008).grab(false, false).span(2, vSpan).applyTo((Control)buttonContainer);
        GridLayoutFactory.fillDefaults().numColumns(0).equalWidth(true).applyTo(buttonContainer);
        this.createButtons(buttonContainer);
    }

    protected Button createButton(Composite parent, String text, String tooltipText, int id) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 9);
        button.setText(text);
        if (tooltipText != null) {
            button.setToolTipText(tooltipText);
        }
        button.setFont(JFaceResources.getFontRegistry().getBold(""));
        button.setData((Object)id);
        AbstractSimpleDiscoveryItem.createButtonLayoutData(button, this.getPixelConverter()).align(0x1000008, 0x1000008).grab(false, false).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSimpleDiscoveryItem.this.buttonPressed((Integer)e.widget.getData());
            }
        });
        return button;
    }

    protected void buttonPressed(int id) {
    }

    @Override
    protected void createInstallButtons(Composite parent) {
    }

    @Override
    protected void createInstallInfo(Composite parent) {
    }

    @Override
    protected void createSocialButtons(Composite parent) {
    }

    @Override
    protected void searchForProvider(String searchTerm) {
    }

    @Override
    protected void searchForTag(String tag) {
    }
}

