/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.BaseEditor;
import com.iizigo.prop.editor.TextShadowValidator;
import com.iizigo.prop.editor.dialog.TextShadowDialog;
import com.iizix.prop.StringProp;
import org.eclipse.swt.widgets.Event;

public class TextShadowPropEditor
extends BaseEditor<StringProp, String> {
    @Override
    protected void create() {
        this.createGridLayout(2, 0);
        this.createMoreButton("Display Text Shadow designer");
        this.createText();
    }

    @Override
    protected void onDoubleClick(Event event) {
        event.doit = false;
        this.onMore();
    }

    @Override
    public void onMore() {
        String string = new TextShadowDialog(this.parent.getShell(), this.getCurrentInput()).open();
        if (string != null) {
            this.setInput(string);
        }
    }

    @Override
    protected String getToolTipText() {
        return "Enter a string with 4 parameters separated by spaces:\n - horizontal-offset-unit\n - vertical-offset-unit\n - blur-size-unit\n - color (RGBA)";
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    protected String getValue(String string) throws Exception {
        if (string.isEmpty()) {
            return null;
        }
        TextShadowValidator textShadowValidator = new TextShadowValidator(string);
        String string2 = textShadowValidator.error;
        if (string2 == null && textShadowValidator.tooManyParams) {
            string2 = "Too many parameters entered, only 4 should be specified";
        } else if (string2 == null) {
            if (textShadowValidator.horz == null) {
                string2 = "Horizontal offset not specified";
            } else if (textShadowValidator.vert == null) {
                string2 = "Vertical offset not specified";
            }
        }
        if (string2 == null) {
            return textShadowValidator.getCSSValue();
        }
        throw new Exception(string2);
    }

    @Override
    public String formatValue(String string) {
        try {
            return this.getValue(string.trim());
        }
        catch (Exception exception) {
            return string.trim();
        }
    }
}

