/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.barcode;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.pdf417.encoder.Compaction;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.iizix.Utilities;
import com.iizix.barcode.BarcodeException;
import com.iizix.barcode.BarcodeType;
import com.iizix.barcode.BarcodeURN;
import com.iizix.barcode.BarcodeValidationException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class BarcodeBuilder
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3487306102027295909L;
    private static final Object[] a = new Object[]{EncodeHintType.ERROR_CORRECTION, "errorcorrection", EncodeHintType.CHARACTER_SET, "charset", EncodeHintType.DATA_MATRIX_SHAPE, "shape", EncodeHintType.MARGIN, "margin", EncodeHintType.PDF417_COMPACT, "compact", EncodeHintType.PDF417_COMPACTION, "compaction", EncodeHintType.PDF417_DIMENSIONS, "dimensions", EncodeHintType.AZTEC_LAYERS, "layers", EncodeHintType.QR_VERSION, "version"};
    final BarcodeType a;
    String a;
    boolean a;
    private int a;
    private int b;
    private HashMap<EncodeHintType, Object> a;
    private static volatile /* synthetic */ int[] a;

    BarcodeBuilder(BarcodeType barcodeType) {
        this.a = barcodeType;
    }

    BarcodeBuilder(BarcodeType barcodeType, String string, String string2) throws BarcodeException {
        this.a = barcodeType;
        this.a = string;
        this.a = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        block30: while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(61);
            if (n < 0) {
                throw new BarcodeException("Parameter \"" + string3 + "\" is missing value (no '=')");
            }
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1);
            if (string5.isEmpty()) {
                throw new BarcodeException("Parameter \"" + string3 + "\" has no value (after '=')");
            }
            try {
                switch (string4) {
                    case "width": {
                        this.a = Integer.parseInt(string5);
                        if (this.a >= 0) continue block30;
                        throw new BarcodeException("Invalid width: " + this.a + " (negative)");
                    }
                    case "height": {
                        this.b = Integer.parseInt(string5);
                        if (this.b >= 0) continue block30;
                        throw new BarcodeException("Invalid height: " + this.b + " (negative)");
                    }
                    case "errorcorrection": {
                        if (barcodeType == BarcodeType.QR_CODE) {
                            this.errorCorrection(ErrorCorrectionLevel.valueOf((String)string5.toUpperCase(Locale.ENGLISH)));
                            continue block30;
                        }
                        this.errorCorrection(Integer.parseInt(string5));
                        continue block30;
                    }
                    case "charset": {
                        this.charset(string5);
                        continue block30;
                    }
                    case "shape": {
                        this.shape(SymbolShapeHint.valueOf((String)string5.toUpperCase(Locale.ENGLISH)));
                        continue block30;
                    }
                    case "margin": {
                        this.margin(Integer.parseInt(string5));
                        continue block30;
                    }
                    case "compact": {
                        if (string5.equals("true")) {
                            this.compact(true);
                            continue block30;
                        }
                        if (string5.equals("false")) {
                            this.compact(false);
                            continue block30;
                        }
                        throw new IllegalArgumentException("boolean value must be \"true\" or \"false\"");
                    }
                    case "compaction": {
                        this.compaction(Compaction.valueOf((String)string5.toUpperCase(Locale.ENGLISH)));
                        continue block30;
                    }
                    case "dimensions": {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ",");
                        this.dimensions(Integer.parseInt(stringTokenizer2.nextToken()), Integer.parseInt(stringTokenizer2.nextToken()), Integer.parseInt(stringTokenizer2.nextToken()), Integer.parseInt(stringTokenizer2.nextToken()));
                        continue block30;
                    }
                    case "layers": {
                        this.layers(Integer.parseInt(string5));
                        continue block30;
                    }
                    case "version": {
                        this.version(Integer.parseInt(string5));
                        continue block30;
                    }
                    default: {
                        throw new BarcodeException("Invalid parameter \"" + string3 + "\"=\"" + string5 + "\"");
                    }
                }
            }
            catch (BarcodeException barcodeException) {
                throw barcodeException;
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("Invalid numerical value for parameter \"" + string3 + "\"=\"" + string5 + "\"", numberFormatException);
            }
            catch (Throwable throwable) {
                throw new BarcodeException("Invalid value for parameter \"" + string3 + "\"=\"" + string5 + "\"", throwable);
            }
        }
        this.a = false;
    }

    public BarcodeBuilder validate(boolean bl) {
        this.a = bl;
        return this;
    }

    public BarcodeBuilder text(String string) throws BarcodeValidationException {
        this.a = Objects.requireNonNull(string);
        if (this.a) {
            try {
                this.a.getWriter().encode(string, this.a.format, 0, 0);
            }
            catch (WriterException writerException) {
                throw new BarcodeValidationException("Invalid barcode text \"" + string + "\": " + writerException.getMessage(), writerException);
            }
        }
        return this;
    }

    public BarcodeBuilder size(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size cannot be negative: " + n);
        }
        this.a = this.b = n;
        return this;
    }

    public BarcodeBuilder size(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("width cannot be negative: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("height cannot be negative: " + n2);
        }
        this.a = n;
        this.b = n2;
        return this;
    }

    public BarcodeBuilder errorCorrection(ErrorCorrectionLevel errorCorrectionLevel) {
        if (this.a == BarcodeType.QR_CODE) {
            if (errorCorrectionLevel != null) {
                if (this.a == null) {
                    this.a = new HashMap();
                }
                this.a.put(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel);
            } else if (this.a != null) {
                this.a.remove(EncodeHintType.ERROR_CORRECTION);
            }
        } else if (this.a && errorCorrectionLevel != null) {
            throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the error correction level to ErrorCorrectionLevel." + String.valueOf(errorCorrectionLevel));
        }
        return this;
    }

    public BarcodeBuilder errorCorrection(int n) {
        switch (BarcodeBuilder.a()[this.a.ordinal()]) {
            case 1: {
                if (n < 0 || n > 8) {
                    throw new IllegalArgumentException("Invalid error correction level for AZTEC (percent range 0-100): " + n);
                }
                this.a.put(EncodeHintType.ERROR_CORRECTION, n);
                break;
            }
            case 10: {
                if (n < 0 || n > 8) {
                    throw new IllegalArgumentException("Invalid error correction level for PDF_417 (range 0-8): " + n);
                }
                this.a.put(EncodeHintType.ERROR_CORRECTION, n);
                break;
            }
            default: {
                if (!this.a) break;
                throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the error correction level to ErrorCorrectionLevel." + n);
            }
        }
        return this;
    }

    public BarcodeBuilder charset(String string) {
        switch (BarcodeBuilder.a()[this.a.ordinal()]) {
            case 1: 
            case 10: 
            case 11: {
                if (string != null) {
                    if (this.a) {
                        try {
                            Charset.forName(string);
                        }
                        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                            throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the charSet encoding \"" + string + "\": " + illegalArgumentException.getMessage(), illegalArgumentException);
                        }
                    }
                    if (this.a == null) {
                        this.a = new HashMap();
                    }
                    this.a.put(EncodeHintType.CHARACTER_SET, string);
                    break;
                }
                if (this.a == null) break;
                this.a.remove(EncodeHintType.CHARACTER_SET);
                break;
            }
            default: {
                if (!this.a || string == null) break;
                throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the charsetName: " + string);
            }
        }
        return this;
    }

    public BarcodeBuilder charset(Charset charset) {
        switch (BarcodeBuilder.a()[this.a.ordinal()]) {
            case 1: 
            case 10: 
            case 11: {
                if (charset != null) {
                    if (this.a == null) {
                        this.a = new HashMap();
                    }
                    this.a.put(EncodeHintType.CHARACTER_SET, charset.name());
                    break;
                }
                if (this.a == null) break;
                this.a.remove(EncodeHintType.CHARACTER_SET);
                break;
            }
            default: {
                if (!this.a || charset == null) break;
                throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the charset: " + String.valueOf(charset));
            }
        }
        return this;
    }

    public BarcodeBuilder shape(SymbolShapeHint symbolShapeHint) {
        if (this.a == BarcodeType.DATA_MATRIX) {
            if (symbolShapeHint != null) {
                if (this.a == null) {
                    this.a = new HashMap();
                }
                this.a.put(EncodeHintType.DATA_MATRIX_SHAPE, symbolShapeHint);
            } else if (this.a != null) {
                this.a.remove(EncodeHintType.DATA_MATRIX_SHAPE);
            }
        } else if (this.a && symbolShapeHint != null) {
            throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the shape: " + String.valueOf(symbolShapeHint));
        }
        return this;
    }

    public BarcodeBuilder margin(int n) {
        switch (BarcodeBuilder.a()[this.a.ordinal()]) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                if (n >= 0) {
                    if (this.a == null) {
                        this.a = new HashMap();
                    }
                    this.a.put(EncodeHintType.MARGIN, n);
                    break;
                }
                if (this.a == null) break;
                this.a.remove(EncodeHintType.MARGIN);
                break;
            }
            default: {
                if (!this.a || n < 0) break;
                throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the margin: " + n);
            }
        }
        return this;
    }

    public BarcodeBuilder compact(boolean bl) {
        if (this.a == BarcodeType.PDF_417) {
            if (this.a == null) {
                this.a = new HashMap();
            }
            this.a.put(EncodeHintType.PDF417_COMPACT, bl);
        } else if (this.a) {
            throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the PDF417 compact mode: " + bl);
        }
        return this;
    }

    public BarcodeBuilder compaction(Compaction compaction) {
        if (this.a == BarcodeType.PDF_417) {
            if (compaction != null) {
                if (this.a == null) {
                    this.a = new HashMap();
                }
                this.a.put(EncodeHintType.PDF417_COMPACTION, compaction);
            } else if (this.a != null) {
                this.a.remove(EncodeHintType.PDF417_COMPACTION);
            }
        } else if (this.a && compaction != null) {
            throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the PDF417 compaction: " + String.valueOf(compaction));
        }
        return this;
    }

    public BarcodeBuilder dimensions(int n, int n2, int n3, int n4) {
        if (this.a == BarcodeType.PDF_417) {
            if (n != 0 && n2 != 0 && n3 != 0 && n4 != 0) {
                if (this.a) {
                    String string = null;
                    if (n < 0) {
                        string = "minCols<0: " + n;
                    } else if (n2 < 0) {
                        string = "maxCols<0: " + n2;
                    } else if (n3 < 0) {
                        string = "minRows<0: " + n3;
                    } else if (n4 < 0) {
                        string = "maxRows<0: " + n4;
                    } else if (n >= n2) {
                        string = "minCols>=maxCols: minCols=" + n + ", maxCols=" + n2;
                    } else if (n3 >= n4) {
                        string = "minRows>=maxRows: minRows=" + n3 + ", maxRows=" + n4;
                    }
                    if (string != null) {
                        throw new BarcodeValidationException("Cannot set the PDF417 dimensions: " + string);
                    }
                }
                if (this.a == null) {
                    this.a = new HashMap();
                }
                this.a.put(EncodeHintType.PDF417_DIMENSIONS, new Dimensions(n, n2, n3, n4));
            } else if (this.a != null) {
                this.a.remove(EncodeHintType.PDF417_DIMENSIONS);
            }
        } else if (this.a) {
            throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the PDF417 dimensions");
        }
        return this;
    }

    public BarcodeBuilder layers(int n) {
        if (this.a == BarcodeType.AZTEC) {
            if (n != 0) {
                if (this.a && (n < -4 || n > 32)) {
                    throw new BarcodeValidationException("Invalid AZTEC layer number (range -4 to 32): " + n);
                }
                if (this.a == null) {
                    this.a = new HashMap();
                }
                this.a.put(EncodeHintType.AZTEC_LAYERS, n);
            } else if (this.a != null) {
                this.a.remove(EncodeHintType.AZTEC_LAYERS);
            }
        } else if (this.a) {
            throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the AZTEC layer number: " + n);
        }
        return this;
    }

    public BarcodeBuilder version(int n) {
        if (this.a == BarcodeType.QR_CODE) {
            if (n != 0) {
                if (this.a && (n < 1 || n > 40)) {
                    throw new BarcodeValidationException("Invalid QR_CODE version number (range 1 to 40): " + n);
                }
                if (this.a == null) {
                    this.a = new HashMap();
                }
                this.a.put(EncodeHintType.QR_VERSION, n);
            } else if (this.a != null) {
                this.a.remove(EncodeHintType.QR_VERSION);
            }
        } else if (this.a) {
            throw new BarcodeValidationException("Barcode format or type " + String.valueOf((Object)this.a) + " cannot set the QR_CODE version number: " + n);
        }
        return this;
    }

    public BarcodeBuilder checkParams() throws BarcodeValidationException {
        if (this.a == null) {
            throw new BarcodeValidationException("Missing barcode text contents");
        }
        if (this.a < 0) {
            throw new BarcodeValidationException("Invalid barcode negative width: " + this.a);
        }
        if (this.b < 0) {
            throw new BarcodeValidationException("Invalid barcode negative width: " + this.b);
        }
        if (this.a != null && this.a.isEmpty()) {
            this.a = null;
        }
        return this;
    }

    public String asURNString() throws BarcodeException {
        try {
            this.checkParams();
            this.a.getWriter().encode(this.a, this.a.format, this.a, this.b, (Map)this.a);
            String string = this.a;
            int n = this.a;
            int n2 = this.b;
            Object[] objectArray = this.a;
            StringBuilder stringBuilder = new StringBuilder("urn:iz-barcode:").append(this.a.lowerCase).append(':').append(Utilities.encodeURIComponent((String)string));
            if (n > 0) {
                stringBuilder.append(":width=").append(n);
            }
            if (n2 > 0) {
                stringBuilder.append(":height=").append(n2);
            }
            if (objectArray != null && !objectArray.isEmpty()) {
                int n3 = 0;
                int n4 = a.length;
                while (n3 < n4) {
                    Object v;
                    if ((v = objectArray.get(a[n3++])) instanceof Dimensions) {
                        Dimensions dimensions = (Dimensions)v;
                        stringBuilder.append(":dimensions=").append(dimensions.getMinCols()).append(',').append(dimensions.getMaxCols()).append(',').append(dimensions.getMinRows()).append(',').append(dimensions.getMaxRows());
                    } else if (v != null) {
                        stringBuilder.append(':').append(a[n3]).append('=').append(v.toString().toLowerCase());
                    }
                    ++n3;
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            throw new BarcodeException("Barcode format or type " + String.valueOf((Object)this.a) + " encoding exception: " + throwable.getMessage(), throwable);
        }
    }

    public BarcodeURN asURN() throws BarcodeException {
        BarcodeBuilder barcodeBuilder = this.clone();
        barcodeBuilder.a = false;
        return new BarcodeURN(barcodeBuilder.asURNString(), barcodeBuilder);
    }

    public String asSVG() throws BarcodeException {
        try {
            this.checkParams();
            BitMatrix bitMatrix = this.a.getWriter().encode(this.a, this.a.format, this.a, this.b, (Map)this.a);
            return this.a.isTwoDimensional ? BarcodeBuilder.b(bitMatrix, this.a, this.b) : BarcodeBuilder.a(bitMatrix, this.a, this.b);
        }
        catch (Throwable throwable) {
            throw new BarcodeException("Barcode format or type " + String.valueOf((Object)this.a) + " encoding exception: " + throwable.getMessage(), throwable);
        }
    }

    public BufferedImage asBufferedImage() throws BarcodeException {
        try {
            this.checkParams();
            return MatrixToImageWriter.toBufferedImage((BitMatrix)this.a.getWriter().encode(this.a, this.a.format, this.a, this.b, (Map)this.a));
        }
        catch (Throwable throwable) {
            throw new BarcodeException("Barcode format or type " + String.valueOf((Object)this.a) + " encoding exception: " + throwable.getMessage(), throwable);
        }
    }

    public void toOutputStream(OutputStream outputStream) throws BarcodeException, IOException {
        this.toOutputStream("png", outputStream);
    }

    public void toOutputStream(String string, OutputStream outputStream) throws BarcodeException, IOException {
        if (!ImageIO.write((RenderedImage)this.asBufferedImage(), string, outputStream)) {
            throw new IOException("Unsupported formatName \"" + string + "\": no image writers found");
        }
    }

    public File toFile(File file) throws BarcodeException, IOException {
        return this.toFile("png", file);
    }

    public File toFile(String string, File file) throws BarcodeException, IOException {
        if (!ImageIO.write((RenderedImage)this.asBufferedImage(), string, file)) {
            throw new IOException("Unsupported formatName \"" + string + "\": no image writers found");
        }
        return file;
    }

    public String getParamsString() {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder("format=").append((Object)this.a);
        String string = this.a;
        if (string != null) {
            stringBuilder.append(",text=").append(string);
        }
        int n = this.a;
        stringBuilder.append(",width=");
        if (n > 0) {
            stringBuilder.append(n);
        }
        int n2 = this.b;
        stringBuilder.append(",height=");
        if (n2 > 0) {
            stringBuilder.append(n2);
        }
        if ((objectArray = this.a) != null && !objectArray.isEmpty()) {
            int n3 = 0;
            int n4 = a.length;
            while (n3 < n4) {
                Object v;
                if ((v = objectArray.get(a[n3++])) instanceof Dimensions) {
                    Dimensions dimensions = (Dimensions)v;
                    stringBuilder.append(",dimensions=[").append(dimensions.getMinCols()).append(',').append(dimensions.getMaxCols()).append(',').append(dimensions.getMinRows()).append(',').append(dimensions.getMaxRows()).append(']');
                } else if (v != null) {
                    stringBuilder.append(',').append(a[n3]).append('=').append(v);
                }
                ++n3;
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getParamsString() + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BarcodeBuilder) {
            BarcodeBuilder barcodeBuilder = (BarcodeBuilder)object;
            if (this.a == barcodeBuilder.a && this.a == barcodeBuilder.a && this.a == barcodeBuilder.a && this.b == barcodeBuilder.b && Objects.equals(this.a, barcodeBuilder.a)) {
                Object[] objectArray;
                Object[] objectArray2 = this.a;
                if (objectArray2 != null && objectArray2.isEmpty()) {
                    objectArray2 = null;
                }
                if ((objectArray = barcodeBuilder.a) != null && objectArray.isEmpty()) {
                    objectArray = null;
                }
                return Objects.equals(objectArray2, objectArray);
            }
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = this.a;
        if (objectArray.isEmpty()) {
            objectArray = null;
        }
        return Objects.hash(new Object[]{this.a, this.a, this.a, this.b, this.a, objectArray});
    }

    public BarcodeBuilder clone() {
        try {
            BarcodeBuilder barcodeBuilder = (BarcodeBuilder)super.clone();
            if (barcodeBuilder.a != null) {
                barcodeBuilder.a = barcodeBuilder.a.isEmpty() ? null : (HashMap)barcodeBuilder.a.clone();
            }
            return barcodeBuilder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public BarcodeType getBarcodeType() {
        return this.a;
    }

    public boolean isValidating() {
        return this.a;
    }

    public String getText() {
        return this.a;
    }

    public int getWidth() {
        return this.a;
    }

    public int getHeight() {
        return this.a;
    }

    public ErrorCorrectionLevel getErrorCorrection() {
        Object v;
        Object[] objectArray = this.a;
        if (objectArray != null && (v = objectArray.get(EncodeHintType.ERROR_CORRECTION)) instanceof ErrorCorrectionLevel) {
            return (ErrorCorrectionLevel)v;
        }
        return null;
    }

    public Map<EncodeHintType, ?> getHints() {
        Object[] objectArray = this.a;
        return objectArray != null && !objectArray.isEmpty() ? (Map)objectArray.clone() : null;
    }

    static String a(BitMatrix bitMatrix, int n, int n2) {
        BitArray bitArray = bitMatrix.getRow(0, null);
        int n3 = bitArray.getSize();
        if (n < n3) {
            n = n3;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        StringBuilder stringBuilder = new StringBuilder("<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" width=\"").append(n).append("px\" height=\"").append(n2).append("px\" viewbox=\"0 0 ").append(n3).append(" 1\" preserveAspectRatio=\"none\"><path d=\"");
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            if (bitArray.get(n4)) {
                if (bl) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append('M').append(n4).append(",0h1v1h-1z");
                bl = true;
            }
            ++n4;
        }
        return stringBuilder.append("\"/></svg>").toString();
    }

    static String b(BitMatrix bitMatrix, int n, int n2) {
        int n3 = bitMatrix.getWidth();
        int n4 = bitMatrix.getHeight();
        if (n < n3) {
            n = n3;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        StringBuilder stringBuilder = new StringBuilder("<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" width=\"").append(n).append("px\" height=\"").append(n2).append("px\" viewBox=\"0 0 ").append(n3).append(" ").append(n4).append("\"><path d=\"");
        boolean bl = false;
        BitArray bitArray = null;
        int n5 = 0;
        while (n5 < n4) {
            bitArray = bitMatrix.getRow(n5, bitArray);
            int n6 = 0;
            while (n6 < n3) {
                if (bitArray.get(n6)) {
                    if (bl) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append('M').append(n6).append(',').append(n5).append("h1v1h-1z");
                    bl = true;
                }
                ++n6;
            }
            ++n5;
        }
        return stringBuilder.append("\"/></svg>").toString();
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[BarcodeType.values().length];
        try {
            nArray[BarcodeType.AZTEC.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.CODABAR.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.CODE_128.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.CODE_39.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.CODE_93.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.DATA_MATRIX.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.EAN_13.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.EAN_8.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.ITF.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.PDF_417.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.QR_CODE.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.UPC_A.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BarcodeType.UPC_E.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

