/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.UndoTransaction;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.prop.BaseEditor;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.EditedPropController;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.prop.FolderPropCnr;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.IPropertyEditorController;
import com.iizigo.prop.editor.dialog.SelectPropDialog;
import com.iizigo.prop.editor.dialog.SelectPropViewerFilter;
import com.iizigo.swt.IzToolTip;
import com.iizigo.swt.WizardDialog;
import com.iizigo.vs.NewVSComponentWizard;
import com.iizigo.vs.NewVirtualSpaceWizard;
import com.iizigo.vs.prop.EditorVSAction;
import com.iizigo.vs.prop.EditorVSColumnHeader;
import com.iizigo.vs.prop.EditorVSField;
import com.iizigo.vs.prop.EditorVSTable;
import com.iizigo.vs.prop.EditorVirtualSpace;
import com.iizix.ILog;
import com.iizix.Value;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IComplexOperation;
import com.iizix.prop.IGProp;
import com.iizix.prop.IPropCnr;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.ReferenceString;
import com.iizix.prop.ui.UIContainer;
import com.iizix.prop.ui.UIPanelBase;
import com.iizix.prop.vs.IVSColumnBestValueListener;
import com.iizix.prop.vs.IVSFieldListener;
import com.iizix.prop.vs.IVSParticipant;
import com.iizix.prop.vs.IVSTableColumnReferenceOwner;
import com.iizix.prop.vs.VSAction;
import com.iizix.prop.vs.VSColumnHeader;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VSField;
import com.iizix.prop.vs.VSFieldReference;
import com.iizix.prop.vs.VSParticipant;
import com.iizix.prop.vs.VSReference;
import com.iizix.prop.vs.VSReferenceOwnerData;
import com.iizix.prop.vs.VSRelativeReference;
import com.iizix.prop.vs.VSTable;
import com.iizix.prop.vs.VSTableColumnReference;
import com.iizix.prop.vs.VSTableReference;
import com.iizix.prop.vs.VirtualSpace;
import com.iizix.swt.IzMenu;
import com.iizix.swt.IzMenuItem;
import com.iizix.swt.SWTHelper;
import java.util.HashSet;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class VSRelativeReferencePropEditor
extends BaseEditor<VSRelativeReference<?>, String> {
    private static final Class<?>[] a = new Class[]{VSField.class};
    protected String title;
    protected String moreText;
    protected String tooltipText;
    protected String itemDefined;
    protected Image image;
    protected Class<?>[] classes = a;
    protected boolean isVSRoot;
    protected IzToolTip tip;
    private IzMenu a;
    protected IzMenuItem miSelect;
    protected IzMenuItem miGoto;

    protected void setup() {
        this.title = "Select a VS Field";
        this.moreText = "Selects a VS Field";
        this.tooltipText = "Enter a name of a VS Field";
        this.itemDefined = "VS Field";
        this.classes = a;
    }

    @Override
    protected void create() {
        block28: {
            this.setup();
            if (this.options == null) break block28;
            HashSet hashSet = null;
            String[] stringArray = this.options;
            int n2 = this.options.length;
            int n3 = 0;
            while (n3 < n2) {
                block29: {
                    String string = stringArray[n3];
                    int n4 = string.indexOf(61);
                    if (n4 <= 0) break block29;
                    String string2 = string.substring(n4 + 1).trim();
                    switch (string.substring(0, n4).toLowerCase()) {
                        case "title": {
                            this.title = string2;
                            break;
                        }
                        case "more": {
                            this.moreText = string2;
                            break;
                        }
                        case "tooltip": {
                            this.tooltipText = string2;
                            break;
                        }
                        case "image": {
                            this.image = this.appUI.getImage(string2);
                            break;
                        }
                        case "root": {
                            this.isVSRoot = Boolean.parseBoolean(string2);
                            break;
                        }
                        case "class": {
                            try {
                                Class<?> clazz = Class.forName(string2);
                                if (hashSet == null) {
                                    hashSet = new HashSet();
                                }
                                hashSet.add(clazz);
                                break;
                            }
                            catch (Exception exception) {
                                ILog.SEVERE(this.getClass(), (String)("Failed loading class " + string2), (Throwable)exception);
                            }
                        }
                    }
                }
                ++n3;
            }
            if (hashSet != null) {
                this.classes = hashSet.toArray(new Class[hashSet.size()]);
            }
        }
        if (this.image == null) {
            this.image = this.appUI.imageVSField;
        }
        this.createGridLayout(2, 0);
        this.createMoreButton(this.moreText);
        this.createText();
        this.tip = new IzToolTip((Control)this.text);
        this.a = this.createMoreIzMenu();
        this.a.omitDisabled().addMenuListener(() -> this.buildMenu());
    }

    protected void buildMenu() {
        PropCnr propCnr;
        VSReference vSReference;
        this.a.clear();
        this.onCreateMenu(this.a, false);
        boolean bl = false;
        if (this.propController.getParents().length == 1 && ((vSReference = (propCnr = this.propController.getParents()[0]).getVSReference(this.info.atom)) != null || propCnr.createVSReference(this.info.atom, new PropCnr[1]) != null)) {
            VirtualSpace virtualSpace;
            VirtualSpace virtualSpace2 = virtualSpace = vSReference != null ? (VirtualSpace)vSReference.getTargetReference() : null;
            if (virtualSpace == null) {
                this.a.add("Connect to &VirtualSpace...", this.appUI.imageVSField, event -> {
                    EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(0);
                }).add("C&reate VirtualSpace and connect it...", this.appUI.getNewImage(this.appUI.imageVSField), event -> {
                    EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(1);
                }).addSeparator();
            }
            Class<?>[] classArray = this.classes;
            int n2 = this.classes.length;
            int n3 = 0;
            while (n3 < n2) {
                Class<?> clazz = classArray[n3];
                if (clazz == VSField.class) {
                    this.a.add("Create VS &Field...", this.appUI.getNewImage(this.appUI.imageVSField), event -> this.onCreateVSField());
                    bl = true;
                } else if (clazz == VSTable.class) {
                    this.a.add("Create VS &Table...", this.appUI.getNewImage(this.appUI.imageVSTable), event -> this.onCreateVSTable());
                    bl = true;
                } else if (clazz == VSColumnHeader.class) {
                    VSTableColumnReference vSTableColumnReference = new VSTableColumnReference(this.info.atom);
                    this.a.add("Create VS Table &Column...", this.appUI.getNewImage(this.appUI.imageVSColumn), event -> VSRelativeReferencePropEditor.onCreateVSColumn(this.getVirtualSpace(-1), this.controller, this.propController, this.text, vSTableColumnReference));
                    bl = true;
                } else if (clazz == VSAction.class) {
                    this.a.add("Create VS &Action...", this.appUI.getNewImage(this.appUI.imageVSAction), event -> this.onCreateVSAction());
                    bl = true;
                }
                ++n3;
            }
        }
        if (bl) {
            this.a.addSeparator();
        }
        this.miSelect = new IzMenuItem(this.a, this.title + "...", this.image, event -> this.onList());
        this.a.addSeparator();
        this.miGoto = new IzMenuItem(this.a, "Show reference in Editor", this.appUI.imageShowInEditor, event -> {
            boolean bl = this.onGoto(true);
        });
        this.onCreateMenu(this.a, true);
        this.miGoto.setEnabled(this.onGoto(false));
    }

    protected EditorVirtualSpace getVirtualSpace(int n2) {
        return VSRelativeReferencePropEditor.getVirtualSpace(this.shell, n2, this.controller, this.propController, this.info.atom);
    }

    protected static EditorVirtualSpace getVirtualSpace(Shell shell, int n2, IPropertyEditorController iPropertyEditorController, EditedPropController<?, ?> editedPropController, Atom atom) {
        PropCnr propCnr;
        PropCnr[] propCnrArray = null;
        PropCnr propCnr2 = editedPropController.getParents()[0];
        VSReference vSReference = propCnr2.getVSReference(atom);
        if (vSReference == null) {
            propCnrArray = new PropCnr[1];
            vSReference = propCnr2.createVSReference(atom, propCnrArray);
            if (vSReference == null) {
                ILog.WARNING(VSRelativeReference.class, (String)("VirtualSpace not found: cannot show create VS component dialogs because property failed to return a created VSReference: " + String.valueOf(propCnr2)));
                return null;
            }
            propCnr = propCnrArray[0];
        } else {
            propCnr = vSReference.getParent();
        }
        EditorVirtualSpace editorVirtualSpace = (EditorVirtualSpace)vSReference.getTargetReference();
        if (editorVirtualSpace == null && propCnr != null) {
            Object object;
            String string;
            Object object2;
            Object object3;
            String string2;
            if (propCnr instanceof IPropDesigner) {
                IPropDesigner iPropDesigner = (IPropDesigner)propCnr;
                string2 = iPropDesigner.getDesigner().getCNDescriptionType();
            } else {
                string2 = propCnr.getClass().getName();
                int n3 = string2.lastIndexOf(46);
                if (n3 > 0) {
                    string2 = string2.substring(n3 + 1);
                }
            }
            ApplicationUI applicationUI = ApplicationUI.getInstance();
            int n4 = n2;
            if (n4 < 0) {
                object3 = new MessageDialog(shell, "Create/Connect VirtualSpace", applicationUI.imageVirtualSpace, "The VirtualSpace connection is not set for the " + string2 + ".\n\nDo you wish to Connect to an existing VirtualSpace or to Create and connect to a New VirtualSpace?", 3, new String[]{"Connect", "Create", "Cancel"}, 0);
                n4 = object3.open();
            }
            if (n4 == 0) {
                object3 = new SelectPropDialog(shell, "Select VirtualSpace for Connection", applicationUI.imageVirtualSpace, iPropertyEditorController.getModuleModel(), null, new SelectPropViewerFilter(new Class[]{EditorVirtualSpace.class}), new Class[]{EditorVirtualSpace.class}, "", 4);
                object2 = ((SelectPropDialog)((Object)object3)).open();
                if (object2 == null) {
                    return null;
                }
                string = propCnr.getPropFromReference((String)object2);
                if (!(string instanceof EditorVirtualSpace)) {
                    ILog.WARNING(VSRelativeReference.class, (String)("Selected VirtualSpace " + (String)object2 + " not found!"));
                    return null;
                }
                object = (EditorVirtualSpace)((Object)string);
                editorVirtualSpace = object;
            } else if (n4 == 1) {
                object3 = new NewVirtualSpaceWizard(false);
                object2 = new org.eclipse.jface.wizard.WizardDialog(shell, (IWizard)object3);
                if (object2.open() != 0) {
                    return null;
                }
                editorVirtualSpace = object3.getVirtualSpace();
            } else {
                return null;
            }
            object3 = editorVirtualSpace.getReferencePropName();
            object2 = new ReferenceString((String)object3);
            string = "Set VirtualSpace connection";
            if (vSReference instanceof VSParticipant) {
                object = new UndoTransaction(string, (IUndoContext)iPropertyEditorController.getUndoContext());
                ComplexOperation complexOperation = new ComplexOperation(string, null, iPropertyEditorController.getUndoRedo());
                IVSParticipant iVSParticipant = (IVSParticipant)propCnr;
                editorVirtualSpace.getParticipantsHolder().add(iVSParticipant, (IComplexOperation)complexOperation);
                PropHelper.queueVerify(propCnr);
                PropHelper.queueVerify((PropCnr)editorVirtualSpace);
                if (vSReference.getParent() == null) {
                    try {
                        vSReference.setPropValue((String)object3);
                    }
                    catch (PropException propException) {
                        throw new InternalError("Shouldn't be", propException);
                    }
                    complexOperation.addProp(propCnr, (GProp<?>)vSReference);
                } else {
                    complexOperation.setPropValue((GProp<?>)vSReference, object2);
                }
                PropHelper.executeOperation(shell, complexOperation);
                ((UndoTransaction)((Object)object)).commit();
            } else {
                object = new ComplexOperation(string, null, iPropertyEditorController.getUndoRedo());
                ((ComplexOperation)((Object)object)).setPropValue((GProp<?>)vSReference, object2);
                PropHelper.executeOperation(shell, (AbstractOperation)object);
            }
        }
        return editorVirtualSpace;
    }

    protected void onCreateVSField() {
        EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(-1);
        if (editorVirtualSpace != null) {
            WizardDialog wizardDialog;
            PropCnr propCnr;
            Object object;
            Value.Type type = null;
            PropCnr[] propCnrArray = this.propController.getParents();
            PropCnr propCnr2 = propCnrArray[0];
            if (propCnr2 instanceof IVSFieldListener) {
                IVSFieldListener iVSFieldListener = (IVSFieldListener)propCnr2;
                type = iVSFieldListener.getBestVSFieldValueType((VSRelativeReference)new VSFieldReference(this.info.atom));
                object = propCnrArray;
                int n2 = propCnrArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    propCnr = object[n3];
                    if (propCnr != iVSFieldListener) {
                        type = null;
                        break;
                    }
                    ++n3;
                }
            }
            if ((wizardDialog = new WizardDialog(this.shell, (Wizard)(propCnr = NewVSComponentWizard.newVSFieldWizard(editorVirtualSpace, type, true, null, true, this.controller.getUndoRedo())))).open() == 0) {
                EditorVSField editorVSField = propCnr.getComponent();
                object = editorVSField.getRelativePropName(editorVirtualSpace);
                this.text.setText((String)object);
            }
        }
        this.text.setFocus();
    }

    protected void onCreateVSTable() {
        NewVSComponentWizard<EditorVSTable> newVSComponentWizard;
        WizardDialog wizardDialog;
        EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(-1);
        if (editorVirtualSpace != null && (wizardDialog = new WizardDialog(this.shell, newVSComponentWizard = NewVSComponentWizard.newVSTableWizard(editorVirtualSpace, null, this.controller.getUndoRedo()))).open() == 0) {
            EditorVSTable editorVSTable = newVSComponentWizard.getComponent();
            String string = editorVSTable.getRelativePropName(editorVirtualSpace);
            this.text.setText(string);
        }
        this.text.setFocus();
    }

    protected void onCreateVSAction() {
        NewVSComponentWizard<EditorVSAction> newVSComponentWizard;
        WizardDialog wizardDialog;
        EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(-1);
        if (editorVirtualSpace != null && (wizardDialog = new WizardDialog(this.shell, newVSComponentWizard = NewVSComponentWizard.newVSActionWizard(editorVirtualSpace, this.controller.getUndoRedo()))).open() == 0) {
            EditorVSAction editorVSAction = newVSComponentWizard.getComponent();
            String string = editorVSAction.getRelativePropName(editorVirtualSpace);
            this.text.setText(string);
        }
        this.text.setFocus();
    }

    protected static void onCreateVSColumn(EditorVirtualSpace editorVirtualSpace, IPropertyEditorController iPropertyEditorController, EditedPropController<?, ?> editedPropController, Text text, VSRelativeReference<?> vSRelativeReference) {
        if (editorVirtualSpace != null) {
            Object object;
            PropCnr propCnr;
            IVSTableColumnReferenceOwner iVSTableColumnReferenceOwner;
            IVSColumnBestValueListener iVSColumnBestValueListener;
            Object object2;
            Value.Type type = null;
            PropCnr[] propCnrArray = editedPropController.getParents();
            VSReferenceOwnerData vSReferenceOwnerData = null;
            PropCnr propCnr2 = propCnrArray[0];
            if (propCnr2 instanceof IVSTableColumnReferenceOwner) {
                IVSTableColumnReferenceOwner iVSTableColumnReferenceOwner2 = (IVSTableColumnReferenceOwner)propCnr2;
                vSReferenceOwnerData = iVSTableColumnReferenceOwner2.getVSTableReferenceOwnerData();
                object2 = propCnrArray;
                int n2 = propCnrArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    iVSColumnBestValueListener = object2[n3];
                    if (!(iVSColumnBestValueListener instanceof IVSTableColumnReferenceOwner)) {
                        vSReferenceOwnerData = null;
                        break;
                    }
                    iVSTableColumnReferenceOwner = (IVSTableColumnReferenceOwner)iVSColumnBestValueListener;
                    if (iVSTableColumnReferenceOwner.getVSTableReferenceOwnerData().owner != vSReferenceOwnerData.owner) {
                        vSReferenceOwnerData = null;
                        break;
                    }
                    ++n3;
                }
            }
            if ((propCnr = propCnrArray[0]) instanceof IVSColumnBestValueListener) {
                iVSColumnBestValueListener = (IVSColumnBestValueListener)propCnr;
                type = iVSColumnBestValueListener.getBestVSColumnHeaderValueType(vSRelativeReference);
                object = propCnrArray;
                int n4 = propCnrArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    PropCnr propCnr3 = object[n5];
                    if (propCnr3 != iVSColumnBestValueListener) {
                        type = null;
                        break;
                    }
                    ++n5;
                }
            }
            NewVSComponentWizard<EditorVSColumnHeader> newVSComponentWizard = NewVSComponentWizard.newVSTableColumnWizard(editorVirtualSpace, type, true, null, true, (VSReferenceOwnerData<VSTable, VSTableReference>)vSReferenceOwnerData, iPropertyEditorController.getUndoRedo());
            object2 = new WizardDialog(text.getShell(), newVSComponentWizard);
            if (object2.open() == 0) {
                iVSTableColumnReferenceOwner = newVSComponentWizard.getComponent();
                if (vSReferenceOwnerData != null) {
                    VSTable vSTable = (VSTable)vSReferenceOwnerData.getVSComponent();
                    if (vSTable == null) {
                        ILog.SEVERE(VSRelativeReference.class, (String)("Failed to find the VSTable in " + String.valueOf(vSReferenceOwnerData.owner)));
                        return;
                    }
                    object = iVSTableColumnReferenceOwner.getRelativePropName((IPropCnr)vSTable.getHeader());
                } else {
                    object = iVSTableColumnReferenceOwner.getRelativePropName((IPropCnr)editorVirtualSpace);
                }
                text.setText((String)object);
            }
        }
        text.setFocus();
    }

    protected void onCreateMenu(IzMenu izMenu, boolean bl) {
    }

    @Override
    public void onMore() {
        this.buildMenu();
        SWTHelper.showPopupMenu(this.a, (Control)this.more);
    }

    private DesignerProp a(IPropDesigner iPropDesigner, PropCnr propCnr) {
        while (!(propCnr instanceof UIPanelBase)) {
            if (propCnr instanceof UIContainer) {
                VirtualSpace virtualSpace;
                Object object;
                UIPanelBase uIPanelBase;
                UIContainer uIContainer = (UIContainer)propCnr;
                if (this.isVSRoot && (uIPanelBase = uIContainer.getUIPanel()) != null && (object = uIPanelBase.getVSParticipant()) != null && (virtualSpace = object.getVirtualSpace()) instanceof EditorVirtualSpace) {
                    EditorVirtualSpace editorVirtualSpace = (EditorVirtualSpace)virtualSpace;
                    return editorVirtualSpace.getDesigner();
                }
                uIPanelBase = uIContainer.getVSStateFocus();
                if (uIPanelBase instanceof IPropDesigner) {
                    object = (IPropDesigner)uIPanelBase;
                    if (iPropDesigner.isChild((IGProp)uIPanelBase)) {
                        iPropDesigner = object;
                        break;
                    }
                }
            }
            if ((propCnr = propCnr.getParent()) != null && !(propCnr instanceof FilePropCnr) && !(propCnr instanceof FolderPropCnr)) continue;
        }
        return iPropDesigner.getDesigner();
    }

    protected void onList() {
        EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(-1);
        if (editorVirtualSpace != null) {
            SelectPropViewerFilter selectPropViewerFilter = new SelectPropViewerFilter(this.classes);
            PropCnr propCnr = this.propController.getParents()[0];
            Object[] objectArray = new Object[]{this.isVSRoot ? editorVirtualSpace : this.a(editorVirtualSpace, propCnr)};
            String string = new SelectPropDialog(this.shell, this.title, this.image, this.controller.getModuleModel(), objectArray, selectPropViewerFilter, this.classes, this.text.getText(), -1).open();
            if (string != null) {
                String string2 = null;
                GProp gProp = editorVirtualSpace.getPropFromReference(string);
                if (gProp == null) {
                    string2 = "Property reference \"" + string + "\" could not be found!";
                } else {
                    string = gProp.getRelativePropName((IPropCnr)editorVirtualSpace);
                    if (string == null) {
                        string2 = "Property reference \"" + string + "\" is not relative the VirtualSpace \"" + editorVirtualSpace.getReferencePropName() + "\"!";
                    } else {
                        this.setCurrentValue(string);
                    }
                }
                if (string2 != null) {
                    Activator.openError(this.shell, "Relative VirtualSpace Error", string2);
                }
            }
        }
        this.text.setFocus();
    }

    @Override
    protected void onDoubleClick(Event event) {
        if (this.onGoto(false)) {
            event.doit = false;
            this.onGoto(true);
        } else {
            this.onList();
        }
    }

    protected boolean onGoto(boolean bl) {
        VSComponent vSComponent = this.getCurrentReferenceTarget();
        if (vSComponent == null) {
            return false;
        }
        return PropHelper.doOpenAndFocus(bl, vSComponent, -1);
    }

    protected VSComponent getCurrentReferenceTarget() {
        return this.getReferenceTarget((String)this.propController.getCurrentValue());
    }

    protected VSComponent getReferenceTarget(String string) {
        VSComponent vSComponent;
        PropCnr propCnr = this.propController.getParents()[0];
        VSReference vSReference = propCnr.getVSReference(this.info.atom);
        if (string == null || vSReference == null) {
            return null;
        }
        Object object = vSReference.getReference();
        if (((String)object).isEmpty() || string.isEmpty()) {
            return null;
        }
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        String string2 = (String)object + string;
        GProp gProp = this.controller.getModuleModel().getRootContainer().getPropFromReference(string2);
        return gProp instanceof VSComponent ? (vSComponent = (VSComponent)gProp) : null;
    }

    @Override
    protected String getToolTipText() {
        return this.tooltipText;
    }

    @Override
    protected void setToolTipText(String string) {
        if (string == null) {
            if (this.getSeverity() == 0) {
                VSComponent vSComponent = this.getCurrentReferenceTarget();
                while (vSComponent != null && !(vSComponent instanceof IPropDesigner)) {
                    vSComponent = vSComponent.getParent();
                }
                if (vSComponent instanceof IPropDesigner) {
                    IPropDesigner iPropDesigner = (IPropDesigner)vSComponent;
                    this.tip.setProperty(iPropDesigner.getDesigner());
                    return;
                }
            }
            string = this.getToolTipText2();
        }
        this.tip.setText(string, 0);
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    protected String getValue(String string) {
        return string;
    }

    @Override
    public String formatValue(String string) {
        return string;
    }
}

