/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.gyro;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.geo.BackgroundLocationConfiguration;
import com.iizix.geo.DeviceLocation;
import com.iizix.geo.IBackgroundLocationModeListener;
import com.iizix.geo.ILocationListener;
import com.iizix.geo.ILocationService;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionConnectionListener;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.prop.GeoLocation;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.gyro.ClientSessionGyro;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class c
implements IBackgroundLocationModeListener,
ILocationListener,
ILocationService,
IClientSessionConnectionListener {
    private final AppSessionGyro a;
    private BackgroundLocationConfiguration a;
    private GenericListener<ILocationListener> a;
    private GenericListener<IBackgroundLocationModeListener> b;

    c(AppSessionGyro appSessionGyro) {
        this.a = appSessionGyro;
        appSessionGyro.addClientConnectionListener(this);
    }

    public boolean isClientSessionService() {
        return false;
    }

    public GeoLocation getCurrentLocation() {
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n2];
            GeoLocation geoLocation = clientSessionGyro.getLocationService().getCurrentLocation();
            if (geoLocation != null) {
                return geoLocation;
            }
            ++n2;
        }
        return null;
    }

    public boolean isBackgroundModeSupported() {
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n2];
            if (clientSessionGyro.getLocationService().isBackgroundModeSupported()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isBackgroundLocationEnabled() {
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n2];
            if (clientSessionGyro.getLocationService().isBackgroundLocationEnabled()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean showAppSettings() {
        boolean bl = false;
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n2];
            if (clientSessionGyro.getLocationService().showAppSettings()) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public int configureBackgroundLocation(BackgroundLocationConfiguration backgroundLocationConfiguration) {
        this.a = backgroundLocationConfiguration;
        int n = 0;
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n2 = clientSessionGyroArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n3];
            clientSessionGyro.getLocationService().configureBackgroundLocation(backgroundLocationConfiguration);
            ++n;
            ++n3;
        }
        return n;
    }

    public boolean isBackgroundLocationConfigured() {
        return this.a != null;
    }

    public int startBackgroundLocation() {
        BackgroundLocationConfiguration backgroundLocationConfiguration = this.a;
        if (backgroundLocationConfiguration == null) {
            throw new IllegalStateException("Location service is not configured yet");
        }
        int n = 0;
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n2 = clientSessionGyroArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n3];
            ILocationService iLocationService = clientSessionGyro.getLocationService();
            if (!iLocationService.isBackgroundLocationConfigured()) {
                iLocationService.configureBackgroundLocation(backgroundLocationConfiguration);
            }
            try {
                iLocationService.startBackgroundLocation();
                ++n;
            }
            catch (IllegalStateException illegalStateException) {
                ILog.WARNING(this.getClass(), (String)("Client session background location is not configured: " + clientSessionGyro.getClientSessionInfo().getConnectionID()), (Throwable)illegalStateException);
            }
            ++n3;
        }
        return n;
    }

    public int stopBackgroundLocation() {
        int n = 0;
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n2 = clientSessionGyroArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n3];
            clientSessionGyro.getLocationService().stopBackgroundLocation();
            ++n;
            ++n3;
        }
        return n;
    }

    public DeviceLocation getLatestLocation() {
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n2];
            DeviceLocation deviceLocation = clientSessionGyro.getLocationService().getLatestLocation();
            if (deviceLocation != null) {
                return deviceLocation;
            }
            ++n2;
        }
        return null;
    }

    public int requestLocation(ILocationListener iLocationListener) {
        if (iLocationListener == null) {
            throw new NullPointerException("callback is null");
        }
        int n = 0;
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n2 = clientSessionGyroArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n3];
            clientSessionGyro.getLocationService().requestLocation(iLocationListener);
            ++n;
            ++n3;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addLocationChangeListener(ILocationListener iLocationListener) {
        if (iLocationListener == null) {
            return false;
        }
        Object object = this;
        synchronized (object) {
            AppSessionGyro appSessionGyro = this.a;
            if (appSessionGyro == null) {
                this.a = appSessionGyro = new GenericListener(ILocationListener.class);
            }
            if (!appSessionGyro.addListener(iLocationListener)) {
                return false;
            }
        }
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = clientSessionGyroArray[n2];
            ((ClientSessionGyro)object).getLocationService().addLocationChangeListener((ILocationListener)this);
            ++n2;
        }
        return true;
    }

    public boolean removeLocationChangeListener(ILocationListener iLocationListener) {
        if (iLocationListener == null) {
            return false;
        }
        AppSessionGyro appSessionGyro = this.a;
        if (appSessionGyro == null || !appSessionGyro.removeListener(iLocationListener)) {
            return false;
        }
        if (!appSessionGyro.hasListeners()) {
            ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
            int n = clientSessionGyroArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n2];
                clientSessionGyro.getLocationService().removeLocationChangeListener((ILocationListener)this);
                ++n2;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addBackgroundModeListener(IBackgroundLocationModeListener iBackgroundLocationModeListener) {
        if (iBackgroundLocationModeListener == null) {
            return false;
        }
        Object object = this;
        synchronized (object) {
            GenericListener genericListener = this.b;
            if (genericListener == null) {
                this.b = genericListener = new GenericListener(IBackgroundLocationModeListener.class);
            }
            if (!genericListener.addListener((Object)iBackgroundLocationModeListener)) {
                return false;
            }
        }
        ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = clientSessionGyroArray[n2];
            ((ClientSessionGyro)object).getLocationService().addBackgroundModeListener((IBackgroundLocationModeListener)this);
            ++n2;
        }
        return true;
    }

    public boolean removeBackgroundModeListener(IBackgroundLocationModeListener iBackgroundLocationModeListener) {
        if (iBackgroundLocationModeListener == null) {
            return false;
        }
        GenericListener<IBackgroundLocationModeListener> genericListener = this.b;
        if (genericListener == null || !genericListener.removeListener((Object)iBackgroundLocationModeListener)) {
            return false;
        }
        if (!genericListener.hasListeners()) {
            ClientSessionGyro[] clientSessionGyroArray = this.a.getClientSessionGyros();
            int n = clientSessionGyroArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n2];
                clientSessionGyro.getLocationService().removeBackgroundModeListener((IBackgroundLocationModeListener)this);
                ++n2;
            }
        }
        return true;
    }

    public void onClientConnection(IAppSessionGyro iAppSessionGyro, IClientSessionGyro iClientSessionGyro) {
        GenericListener<IBackgroundLocationModeListener> genericListener;
        AppSessionGyro appSessionGyro = this.a;
        if (appSessionGyro != null && appSessionGyro.hasListeners()) {
            iClientSessionGyro.getLocationService().addLocationChangeListener((ILocationListener)this);
        }
        if ((genericListener = this.b) != null && genericListener.hasListeners()) {
            iClientSessionGyro.getLocationService().addBackgroundModeListener((IBackgroundLocationModeListener)this);
        }
    }

    public void onClientDisposed(IAppSessionGyro iAppSessionGyro, IClientSessionGyro iClientSessionGyro) {
    }

    public void onLocationChanged(IClientSessionGyro iClientSessionGyro, DeviceLocation deviceLocation) {
        AppSessionGyro appSessionGyro = this.a;
        if (appSessionGyro != null) {
            appSessionGyro.forEach(iLocationListener -> iLocationListener.onLocationChanged(iClientSessionGyro, deviceLocation));
        }
    }

    public void onBackgroundLocationModeChanged(IClientSessionGyro iClientSessionGyro, boolean bl) {
        GenericListener<IBackgroundLocationModeListener> genericListener = this.b;
        if (genericListener != null) {
            genericListener.forEach(iBackgroundLocationModeListener -> iBackgroundLocationModeListener.onBackgroundLocationModeChanged(iClientSessionGyro, bl));
        }
    }
}

